/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javaxt.utils.Base64;
import javaxt.utils.Date;
import javaxt.utils.Value;
import javaxt.utils.string;
import javaxt.webservices.Option;
import javaxt.xml.DOM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Parameter {
    private String name;
    private String type;
    private Object value;
    private int minOccurs = 0;
    private int maxOccurs = 1;
    protected boolean IsNillable;
    protected boolean IsAttribute;
    private Parameter[] children = null;
    private Option[] options = null;
    private Node parentNode;

    protected Parameter(Node ParameterNode) throws InstantiationException {
        if (!ParameterNode.getNodeName().equalsIgnoreCase("parameter")) {
            throw new InstantiationException(DOM.getText(ParameterNode));
        }
        this.parentNode = ParameterNode.getParentNode();
        NamedNodeMap attr = ParameterNode.getAttributes();
        this.name = DOM.getAttributeValue(attr, "name");
        this.type = DOM.getAttributeValue(attr, "type");
        this.IsAttribute = this.bool(DOM.getAttributeValue(attr, "isattribute"));
        this.IsNillable = this.bool(DOM.getAttributeValue(attr, "isnillable"));
        if (this.name.length() == 0) {
            throw new InstantiationException(DOM.getText(ParameterNode));
        }
        try {
            this.minOccurs = this.cint(DOM.getAttributeValue(attr, "minOccurs").trim());
            if (this.minOccurs < 0) {
                this.minOccurs = 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String maxOccurs = DOM.getAttributeValue(attr, "maxOccurs").trim();
        if (maxOccurs.equalsIgnoreCase("unbounded")) {
            this.maxOccurs = Short.MAX_VALUE;
        } else if (maxOccurs.equals("")) {
            this.maxOccurs = 1;
        } else {
            try {
                this.maxOccurs = this.cint(maxOccurs);
                if (this.maxOccurs < 0) {
                    this.maxOccurs = 0;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Node node : DOM.getNodes(ParameterNode.getChildNodes())) {
            if (!node.getNodeName().equalsIgnoreCase("parameter")) continue;
            try {
                params.add(new Parameter(node));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (!params.isEmpty()) {
            this.children = params.toArray(new Parameter[params.size()]);
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (Node node : DOM.getNodes(ParameterNode.getChildNodes())) {
            if (!node.getNodeName().equalsIgnoreCase("options")) continue;
            for (Node optionNode : DOM.getNodes(node.getChildNodes())) {
                String value;
                String name = value = DOM.getAttributeValue(optionNode.getAttributes(), "value");
                options.add(new Option(name, value));
            }
        }
        if (!options.isEmpty()) {
            this.options = options.toArray(new Option[options.size()]);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        if (val == null) {
            this.value = null;
            return;
        }
        if (this.isComplex()) {
            String str;
            if (val instanceof String && (str = (String)val).trim().startsWith("<")) {
                this.value = str;
            }
        } else if (val.getClass().isArray()) {
            if (this.getMaxOccurs() > 1) {
                Object[] a = (Object[])val;
                Object[] b = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    b[i] = this.getValue(a[i]);
                }
                this.value = b;
            } else if (val instanceof byte[]) {
                this.value = this.getValue(val);
            }
        } else {
            this.value = this.getValue(val);
        }
    }

    private Object getValue(Object val) {
        if (this.type.equalsIgnoreCase("base64Binary")) {
            if (val instanceof byte[]) {
                return val;
            }
            if (val instanceof String) {
                return Base64.decode((String)val);
            }
            if (val instanceof File) {
                return new javaxt.io.File((File)val).getBytes().toByteArray();
            }
            if (val instanceof javaxt.io.File) {
                return ((javaxt.io.File)val).getBytes().toByteArray();
            }
        } else {
            if (this.type.equalsIgnoreCase("boolean")) {
                return new Value(val).toBoolean();
            }
            if (!this.type.equalsIgnoreCase("byte")) {
                if (this.type.equalsIgnoreCase("double")) {
                    return new Value(val).toDouble();
                }
                if (this.type.equalsIgnoreCase("dateTime")) {
                    if (val instanceof java.util.Date) {
                        return (java.util.Date)val;
                    }
                    if (val instanceof Date) {
                        return ((Date)val).getDate();
                    }
                    if (val instanceof String) {
                        try {
                            return new Date((String)val).getDate();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    if (this.type.equalsIgnoreCase("decimal")) {
                        return new Value(val).toBigDecimal();
                    }
                    if (this.type.equalsIgnoreCase("float")) {
                        return new Value(val).toFloat();
                    }
                    if (this.type.equalsIgnoreCase("int")) {
                        return new Value(val).toInteger();
                    }
                    if (this.type.equalsIgnoreCase("long")) {
                        return new Value(val).toLong();
                    }
                    if (this.type.equalsIgnoreCase("short")) {
                        return new Value(val).toShort();
                    }
                    if (this.type.equalsIgnoreCase("string")) {
                        return new Value(val).toString();
                    }
                }
            }
        }
        return null;
    }

    protected String toXML(String attributes, String ns) {
        ns = ns != null ? ns.trim() : "";
        String name = this.name;
        if (ns.length() > 0) {
            name = ns + ":" + name;
        }
        StringBuffer xml = new StringBuffer();
        if (this.value != null && this.value.getClass().isArray()) {
            if (this.value instanceof byte[]) {
                xml.append("<" + name + attributes + ">");
                xml.append(Base64.encodeBytes((byte[])this.value));
                xml.append("</" + name + ">");
            } else if (this.value instanceof Object[]) {
                boolean escapeXML = this.type.equalsIgnoreCase("string");
                for (Object obj : (Object[])this.value) {
                    String val = obj + "";
                    if (escapeXML) {
                        val = DOM.escapeXml(val);
                    }
                    xml.append("<" + name + attributes + ">");
                    xml.append(val);
                    xml.append("</" + name + ">");
                }
            }
        } else {
            xml.append("<" + name + attributes + ">");
            if (this.value != null) {
                if (this.value instanceof String) {
                    if (!this.isComplex()) {
                        xml.append(DOM.escapeXml((String)this.value));
                    } else {
                        xml.append((String)this.value);
                    }
                } else if (this.value instanceof java.util.Date) {
                    java.util.Date date = (java.util.Date)this.value;
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSZ");
                    String d = formatter.format(date).replace(" ", "T");
                    String d1 = d.substring(0, d.length() - 2);
                    String d2 = d.substring(d.length() - 2);
                    xml.append(d1 + ":" + d2);
                } else {
                    xml.append(this.value);
                }
            }
            xml.append("</" + name + ">");
        }
        return xml.toString();
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public boolean isRequired() {
        return this.getMinOccurs() != 0;
    }

    public boolean isComplex() {
        if (this.getChildren() != null && this.getChildren().length > 0) {
            return true;
        }
        if (this.options != null) {
            return false;
        }
        return false;
    }

    public Parameter[] getChildren() {
        return this.children;
    }

    protected Node getParentNode() {
        return this.parentNode;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public String toString() {
        if (this.isComplex()) {
            return this.name;
        }
        return this.name + "=" + this.value;
    }

    private int cint(String str) {
        return string.cint(str);
    }

    private boolean bool(String str) {
        return str.equalsIgnoreCase("true");
    }
}

