/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javaxt.http.Response;
import javaxt.io.Image;
import javaxt.utils.Base64;
import javaxt.webservices.SoapException;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SoapResponse {
    private URL url;
    private Map<String, List<String>> headers;
    private String body;
    private String message;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SoapResponse(Response response, String resultsNode) throws SoapException {
        int status = response.getStatus();
        if (status != 200 && status != 202 && status != 203) throw new SoapException(response.getMessage() + " (" + status + ")", response.getText());
        this.body = response.getText();
        if (this.body == null) throw new SoapException("Invalid SOAP Response.", this.body);
        this.url = response.getURL();
        this.headers = response.getHeaders();
        Document xml = DOM.createDocument(this.body);
        if (xml == null) throw new SoapException("Invalid SOAP Response. Response does not appear to be xml.", this.body);
        try {
            NodeList Response2 = xml.getElementsByTagName(resultsNode);
            if (Response2 == null) throw new SoapException("Failed to parse SOAP Response. Could not find the " + resultsNode + " node, " + "possibly due to a service exception.", this.body);
            if (Response2.getLength() == 0) {
                resultsNode = this.getResultsNode(this.body, resultsNode);
                Response2 = xml.getElementsByTagName(resultsNode);
            }
            this.message = DOM.getNodeValue(Response2.item(0));
            if (!DOM.hasChildren(Response2.item(0))) return;
            this.message = this.message.substring(this.message.indexOf(">") + 1);
            this.message = this.message.substring(0, this.message.lastIndexOf("</"));
            return;
        }
        catch (Exception e) {
            throw new SoapException("Failed to parse SOAP Response. " + e.getLocalizedMessage(), this.body);
        }
    }

    private String getResultsNode(String ServiceResponse, String resultsNode) {
        resultsNode = ServiceResponse.substring(0, ServiceResponse.toLowerCase().indexOf(resultsNode.toLowerCase()) + resultsNode.length());
        resultsNode = resultsNode.substring(resultsNode.lastIndexOf("<") + 1);
        return resultsNode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public URL getURL() {
        return this.url;
    }

    public String getBody() {
        return this.body;
    }

    public Document toXML() {
        return DOM.createDocument(this.message);
    }

    public byte[] toByteArray() {
        return Base64.decode(this.message.trim());
    }

    public Image toImage() {
        return new Image(this.toByteArray());
    }

    public String toString() {
        return this.message;
    }
}

