/*
 * Decompiled with CFR 0.152.
 */
package javaxt.html;

import javaxt.html.Parser;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class Element {
    private String nodeName;
    private String attributes;
    private String innerHTML;
    private String outerHTML;
    private Parser parser;
    private boolean isClosed;

    public Element(String outerHTML) throws Exception {
        int endNode;
        int gt;
        this.outerHTML = outerHTML;
        int ws = -1;
        for (int z = 0; z < outerHTML.length(); ++z) {
            char t = outerHTML.charAt(z);
            if (!Element.isWhitespace(t)) continue;
            ws = z + 1;
            break;
        }
        if ((gt = Parser.findGT(0, outerHTML + " ")) == -1) {
            throw new Exception("Invalid or unsupported html");
        }
        ++gt;
        if (ws == -1) {
            endNode = gt - 1;
            this.attributes = "";
        } else if (gt < ws) {
            endNode = gt - 1;
            this.attributes = "";
        } else {
            endNode = ws;
            this.attributes = outerHTML.substring(endNode, gt - 1).trim();
            if (this.attributes.endsWith("/")) {
                this.attributes = this.attributes.substring(0, this.attributes.length() - 1).trim();
            }
        }
        this.nodeName = outerHTML.substring(1, endNode);
        if (this.nodeName.endsWith("/")) {
            this.nodeName = this.nodeName.substring(0, this.nodeName.length() - 1);
        }
        this.nodeName = this.nodeName.trim();
        this.innerHTML = outerHTML.substring(gt);
        if (this.innerHTML.trim().length() > 0) {
            int idx = this.innerHTML.lastIndexOf("</" + this.nodeName);
            if (idx > -1) {
                this.innerHTML = this.innerHTML.substring(0, idx);
                this.isClosed = true;
            } else {
                this.isClosed = false;
            }
        } else {
            char c = outerHTML.charAt(gt - 2);
            this.isClosed = c == '/';
        }
    }

    public String getName() {
        return this.nodeName;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }

    public String getOuterHTML() {
        return this.outerHTML;
    }

    public String getInnerText() {
        return Parser.stripHTMLTags(this.innerHTML);
    }

    public String getAttribute(String attributeName) {
        return this._getAttributeValue(attributeName);
    }

    public Element getElementByID(String id) {
        return this.getElementByAttributes(null, "id", id);
    }

    public Element[] getElementsByTagName(String tagName) {
        return this.getParser().getElementsByTagName(tagName);
    }

    public Element getElementByTagName(String tagName) {
        return this.getElementByAttributes(tagName, null, null);
    }

    public Element[] getChildNodes() {
        return this.getParser().getElements();
    }

    public Element[] getElements(String tagName, String attributeName, String attributeValue) {
        return this.getParser().getElements(tagName, attributeName, attributeValue);
    }

    public Element getElementByAttributes(String tagName, String attributeName, String attributeValue) {
        return this.getParser().getElementByAttributes(tagName, attributeName, attributeValue);
    }

    public String[] getImageLinks() {
        return this.getParser().getImageLinks();
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser(this.innerHTML);
        }
        return this.parser;
    }

    public String toString() {
        return this.outerHTML;
    }

    public String stripHTMLTags() {
        return this.getInnerText();
    }

    public String getAttributeValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    private String _getAttributeValue(String attributeName) {
        String tag = (this.nodeName + " " + this.attributes).trim();
        try {
            Document XMLDoc = DOM.createDocument("<" + tag + "/>");
            NamedNodeMap attr = XMLDoc.getFirstChild().getAttributes();
            return DOM.getAttributeValue(attr, attributeName);
        }
        catch (Exception e) {
            try {
                return this._getAttributeValue2(tag, attributeName);
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    private String _getAttributeValue2(String tag, String attributeName) {
        char ch;
        int i;
        if (!(tag = tag.trim()).contains(" ")) {
            return tag;
        }
        String orgTag = tag;
        tag = tag.substring(tag.indexOf(" "), tag.length()).trim();
        String tagName = orgTag + " ";
        tagName = tagName.substring(0, tagName.indexOf(" "));
        String newTag = "";
        tag = tag + " ";
        for (i = 0; i < tag.length() - 1; ++i) {
            ch = tag.charAt(i);
            if (ch == ' ' && tag.charAt(i + 1) == ' ') continue;
            newTag = newTag + ch;
        }
        newTag = newTag.replace("= ", "=");
        newTag = newTag.replace(" =", "=");
        newTag = " " + newTag + " ";
        for (i = 0; i < newTag.length(); ++i) {
            ch = newTag.charAt(i);
            if (ch != '=') continue;
            String tmp = newTag.substring(0, i);
            String AttrName = tmp.substring(tmp.lastIndexOf(" "), tmp.length()).trim();
            String AttrValue = "";
            if (!AttrName.equalsIgnoreCase(attributeName)) continue;
            tmp = newTag.substring(i + 1, newTag.length()).trim() + " ";
            if (newTag.charAt(i + 1) == '\"') {
                tmp = tmp.substring(1, tmp.length());
                AttrValue = tmp.substring(0, tmp.indexOf("\""));
            } else if (newTag.charAt(i + 1) == '\'') {
                tmp = tmp.substring(1, tmp.length());
                AttrValue = tmp.substring(0, tmp.indexOf("'"));
            } else {
                AttrValue = tmp.substring(0, tmp.indexOf(" "));
            }
            return AttrValue;
        }
        return "";
    }

    private static boolean isWhitespace(char c) {
        if (c == ' ') {
            return true;
        }
        if (c == '\r') {
            return true;
        }
        if (c == '\n') {
            return true;
        }
        return c == '\t';
    }
}

