/*
 * Decompiled with CFR 0.152.
 */
package javaxt.html;

import java.net.URL;
import java.util.ArrayList;
import javaxt.html.Element;

public class Parser {
    private String html;

    public Parser(String html) {
        this.html = html;
    }

    public String getHTML() {
        return this.html;
    }

    public void setHTML(String html) {
        this.html = html;
    }

    public Element getElementByID(String id) {
        return this.getElementByAttributes(null, "id", id);
    }

    public Element[] getElementsByTagName(String tagName) {
        String orgHTML = this.html;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element e = this.getElementByTagName(tagName);
        while (e != null) {
            elements.add(e);
            String outerHTML = e.getOuterHTML();
            int idx = this.html.indexOf(outerHTML);
            String a = this.html.substring(0, idx);
            String b = this.html.substring(idx + outerHTML.length());
            this.html = a + b;
            e = this.getElementByTagName(tagName);
        }
        this.html = orgHTML;
        return elements.toArray(new Element[elements.size()]);
    }

    public Element[] getElements() {
        ArrayList<Element> elements = Parser.getElements(this.html);
        return elements.toArray(new Element[elements.size()]);
    }

    public Element[] getElements(String tagName, String attributeName, String attributeValue) {
        String orgHTML = this.html;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element e = this.getElementByAttributes(tagName, attributeName, attributeValue);
        while (e != null) {
            elements.add(e);
            String outerHTML = e.getOuterHTML();
            int idx = this.html.indexOf(outerHTML);
            String a = this.html.substring(0, idx);
            String b = this.html.substring(idx + outerHTML.length());
            this.html = a + b;
            e = this.getElementByAttributes(tagName, attributeName, attributeValue);
        }
        this.html = orgHTML;
        return elements.toArray(new Element[elements.size()]);
    }

    public Element getElementByTagName(String tagName) {
        return this.getElementByAttributes(tagName, null, null);
    }

    public Element getElementByAttributes(String tagName, String attributeName, String attributeValue) {
        Element[] elements;
        for (Element element : elements = this.getElements()) {
            if (!this.hasAttributes(tagName, attributeName, attributeValue, element)) continue;
            return element;
        }
        for (Element element : elements) {
            Element e;
            String n = element.getName();
            if (n == null || n.equalsIgnoreCase("script") || (e = this.getElementByAttributes(tagName, attributeName, attributeValue, element)) == null) continue;
            return e;
        }
        return null;
    }

    private Element getElementByAttributes(String tagName, String attributeName, String attributeValue, Element element) {
        Element[] elements;
        for (Element e : elements = element.getChildNodes()) {
            if (!this.hasAttributes(tagName, attributeName, attributeValue, e)) continue;
            return e;
        }
        for (Element e : elements) {
            Element el;
            String n = element.getName();
            if (n == null || n.equalsIgnoreCase("script") || (el = this.getElementByAttributes(tagName, attributeName, attributeValue, e)) == null) continue;
            return el;
        }
        return null;
    }

    private boolean hasAttributes(String tagName, String attributeName, String attributeValue, Element element) {
        String name = element.getName();
        if (name == null) {
            return false;
        }
        if (name.equalsIgnoreCase(tagName) || tagName == null) {
            if (attributeName == null) {
                return true;
            }
            String val = element.getAttribute(attributeName);
            if (val == null ? attributeValue == null : val.equals(attributeValue)) {
                return true;
            }
        }
        return false;
    }

    public String[] getImageLinks() {
        ArrayList<String> links = new ArrayList<String>();
        for (Element img : this.getElementsByTagName("img")) {
            String src = img.getAttribute("src");
            if (src.length() <= 0) continue;
            links.add(src);
        }
        return links.toArray(new String[links.size()]);
    }

    public static String stripHTMLTags(String html) {
        String s = html + " ";
        String c = "";
        boolean concat = false;
        String tag = "";
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("<")) {
                concat = true;
            }
            if (concat) {
                tag = tag + c;
            }
            if (!c.equals(">") || !concat) continue;
            concat = false;
            html = html.replace(tag, "");
            tag = "";
        }
        return html.replace("&nbsp;", " ").trim();
    }

    public static String MapPath(String relPath, URL url) {
        try {
            new URL(relPath);
            return relPath;
        }
        catch (Exception exception) {
            if (relPath.length() > 2 && relPath.substring(0, 2).equals("./")) {
                relPath = relPath.substring(2, relPath.length());
            }
            String[] arrRelPath = relPath.split("/");
            try {
                String newPath;
                String urlBase = url.getProtocol() + "://" + url.getHost();
                int port = url.getPort();
                if (port > 0 && port != 80) {
                    urlBase = urlBase + ":" + url.getPort();
                }
                String urlPath = "";
                if (relPath.substring(0, 1).equals("/")) {
                    newPath = relPath;
                } else {
                    urlPath = "/";
                    String[] arr = url.getPath().split("/");
                    for (int i = 0; i <= arr.length - arrRelPath.length; ++i) {
                        String dir = arr[i];
                        if (dir.length() <= 0) continue;
                        urlPath = urlPath + dir + "/";
                    }
                    newPath = relPath.substring(0, 1).equals("/") ? relPath.substring(1, relPath.length()) : (relPath.substring(0, 2).equals("./") ? relPath.substring(2, relPath.length()) : (relPath.substring(0, 3).equals("../") ? relPath.replace("../", "") : relPath));
                }
                return urlBase + urlPath + newPath;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String getAbsolutePath(String relPath, String url) {
        try {
            return Parser.MapPath(relPath, new URL(url));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ArrayList<Element> getElements(String s) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (s == null) {
            return elements;
        }
        boolean insideComment = false;
        boolean insideQuote = false;
        int start = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                String str;
                if (!insideComment && !insideQuote && i + 3 < len - 1 && (str = s.substring(i, i + 4)).equals("<!--")) {
                    insideComment = true;
                    i += 3;
                    continue;
                }
                if (insideComment || insideQuote) continue;
                start = i;
                continue;
            }
            if (c == '>') {
                Element el;
                String str3;
                String str2;
                if (insideComment && !insideQuote && (str2 = s.substring(i - 2, i + 1)).equals("-->")) {
                    insideComment = false;
                    continue;
                }
                if (insideComment || insideQuote) continue;
                int end = -1;
                char p = s.charAt(i - 1);
                if (p == '/') {
                    end = i + 1;
                } else {
                    try {
                        str3 = s.substring(start, i + 1);
                        el = new Element(str3);
                        end = Parser.findEndTag(el.getName(), i + 1, s);
                        end = end == -1 ? i + 1 : ++end;
                    }
                    catch (Exception str3) {
                        // empty catch block
                    }
                }
                if (end <= -1) continue;
                str3 = s.substring(start, end);
                try {
                    el = new Element(str3);
                    elements.add(el);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                start = i = end;
                continue;
            }
            if (c != '\"' || insideComment) continue;
            insideQuote = !insideQuote;
        }
        return elements;
    }

    private static int findEndTag(String tagName, int x, String s) {
        int numTags = 1;
        int start = -1;
        boolean insideComment = false;
        boolean insideQuote = false;
        boolean insideClosingTag = false;
        ArrayList<Object[]> tags = new ArrayList<Object[]>();
        int len = s.length();
        for (int i = x; i < len; ++i) {
            String str;
            char c = s.charAt(i);
            if (c == '<') {
                char n;
                if (!insideComment && !insideQuote && i + 3 < len - 1 && (str = s.substring(i, i + 4)).equals("<!--")) {
                    insideComment = true;
                    i += 3;
                    continue;
                }
                if (insideComment || insideQuote) continue;
                if (i + 1 < len - 1 && (n = s.charAt(i + 1)) == '/') {
                    insideClosingTag = true;
                }
                start = i;
                continue;
            }
            if (c == '>') {
                char p;
                if (insideComment && !insideQuote && (str = s.substring(i - 2, i + 1)).equals("-->")) {
                    insideComment = false;
                    continue;
                }
                if (insideComment || insideQuote) continue;
                String currTagName = "";
                try {
                    String str2 = insideClosingTag ? "<" + s.substring(start + 2, i + 1) : s.substring(start, i + 1);
                    Element el = new Element(str2);
                    currTagName = el.getName();
                    tags.add(new Object[]{currTagName, insideClosingTag, start, i});
                }
                catch (Exception str2) {
                    // empty catch block
                }
                if (currTagName.equals(tagName) && (p = s.charAt(i - 1)) != '/') {
                    String t = s.substring(start, i + 1);
                    numTags = insideClosingTag ? --numTags : ++numTags;
                }
                if (numTags == 0) {
                    return i;
                }
                if (!insideClosingTag) continue;
                insideClosingTag = false;
                continue;
            }
            if (c != '\"' || insideComment) continue;
            insideQuote = !insideQuote;
        }
        if (!tags.isEmpty()) {
            Object[] nextTag = (Object[])tags.get(0);
            String nextTagName = (String)nextTag[0];
            boolean isClosingTag = (Boolean)nextTag[1];
            if (nextTagName.equals(tagName) && !isClosingTag) {
                Object[] tag;
                String name;
                Object[] lastTag = null;
                for (int i = 1; i < tags.size() && (name = (String)(tag = (Object[])tags.get(i))[0]).equals(tagName); ++i) {
                    lastTag = tag;
                }
                if (lastTag != null) {
                    String lastTagName = (String)lastTag[0];
                    isClosingTag = (Boolean)lastTag[1];
                    if (lastTagName.equals(tagName) && isClosingTag) {
                        return (Integer)lastTag[3];
                    }
                }
            }
        }
        return -1;
    }

    protected static int findGT(int x, String s) {
        boolean insideComment = false;
        boolean insideQuote = false;
        int len = s.length();
        for (int i = x; i < len; ++i) {
            String str;
            char c = s.charAt(i);
            if (c == '<') {
                if (insideComment || insideQuote || i + 3 >= len - 1 || !(str = s.substring(i, i + 4)).equals("<!--")) continue;
                insideComment = true;
                i += 3;
                continue;
            }
            if (c == '>') {
                if (insideComment && !insideQuote && (str = s.substring(i - 2, i + 1)).equals("-->")) {
                    insideComment = false;
                    continue;
                }
                if (insideComment || insideQuote) continue;
                return i;
            }
            if (c != '\"' || insideComment) continue;
            insideQuote = !insideQuote;
        }
        return -1;
    }
}

