/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javaxt.io.File;
import javaxt.io.FileSystemWatcherNative;
import javaxt.io.Shell;

public class Directory
implements Comparable {
    private java.io.File file;
    private String name = "";
    private String path = "";
    private FileSystemWatcher FileSystemWatcher;
    private File.FileAttributes attr;
    private long lastAttrUpdate = 0L;
    public static final String PathSeparator = System.getProperty("file.separator");
    protected static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");

    public Directory(String Path2) {
        if (Path2 == null) {
            throw new NullPointerException();
        }
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.init(Path2);
    }

    public Directory(java.io.File File2) {
        this.init(File2);
    }

    private void init(java.io.File File2) {
        if (File2 == null) {
            throw new NullPointerException();
        }
        if (File2.exists() && !File2.isDirectory()) {
            File2 = File2.getParentFile();
        }
        this.attr = null;
        String p = File2.getAbsolutePath();
        this.init(p);
        if (p.equals(this.toString())) {
            this.file = File2;
        }
    }

    private void init(String Path2) {
        String[] arr = (Path2 = Path2.replace("\\", "/")).split("/");
        if (arr.length > 1) {
            this.name = arr[arr.length - 1];
            this.path = Path2.substring(0, Path2.lastIndexOf(this.name));
        } else {
            this.path = Path2;
        }
        this.path = this.path.isEmpty() ? PathSeparator : this.path.replace("/", PathSeparator);
        if (!this.path.endsWith(PathSeparator)) {
            this.path = this.path + PathSeparator;
        }
        if (this.path.startsWith(".")) {
            try {
                this.init(new java.io.File(this.path + this.name).getCanonicalPath());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid Path.");
            }
        }
    }

    private java.io.File getFile() {
        if (this.file == null) {
            this.file = new java.io.File(this.path + this.name);
        }
        return this.file;
    }

    /*
     * Unable to fully structure code
     */
    public static Directory[] getRootDirectories() {
        directories = new TreeSet<Directory>();
        files = java.io.File.listRoots();
        if (files == null) {
            return new Directory[0];
        }
        for (i = 0; i < files.length; ++i) {
            directories.add(new Directory(files[i]));
        }
        if (Directory.isWindows) {
            doNetUse = false;
            if (File.loadDLL()) {
                try {
                    drives = File.GetNetworkDrives();
                    if (drives == null) ** GOTO lbl28
                    for (String drive : drives.split("\n")) {
                        if (drive.trim().length() <= 0) continue;
                        arr = drive.split("\t");
                        driveName = arr[0];
                        driveType = arr[1];
                        directories.add(new Directory(driveName));
                    }
                }
                catch (Exception e) {
                    doNetUse = true;
                }
            } else {
                doNetUse = true;
            }
lbl28:
            // 4 sources

            if (doNetUse) {
                cmd = new Shell("net use");
                try {
                    cmd.run();
                }
                catch (Exception var4_6) {
                    // empty catch block
                }
                it = cmd.getOutput().iterator();
                parse = false;
                while (it.hasNext() && (line = (String)it.next()) != null) {
                    line = line.trim();
                    if (!parse && line.startsWith("----")) {
                        parse = true;
                        line = (String)it.next();
                        if (line == null) break;
                    }
                    if (!line.contains(":")) continue;
                    line = line.substring(0, line.indexOf(":") + 1);
                    line = line.substring(line.lastIndexOf(" ") + 1);
                    directories.add(new Directory(line.trim()));
                }
            }
        }
        return directories.toArray(new Directory[directories.size()]);
    }

    public boolean exists() {
        String path = this.path + this.name;
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                boolean doNetUse = false;
                if (File.loadDLL()) {
                    try {
                        File.GetSharedDrives(path.substring(2));
                        return true;
                    }
                    catch (Exception e) {
                        if (e.getMessage().trim().equals("53")) {
                            return false;
                        }
                        doNetUse = true;
                    }
                } else {
                    doNetUse = true;
                }
                if (doNetUse) {
                    Shell cmd = new Shell("net view " + path);
                    try {
                        cmd.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    List errors = cmd.getErrors();
                    errors.remove(null);
                    return errors.isEmpty();
                }
            }
        }
        if (this.file != null) {
            return this.file.isDirectory() && this.file.exists();
        }
        try {
            File.FileAttributes attr = this.getFileAttributes();
            if (attr != null) {
                return true;
            }
            this.getFile();
            return this.file.isDirectory() && this.file.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isEmpty() {
        if (!this.exists()) {
            return true;
        }
        Object[] files = this.listFiles(null);
        return files == null;
    }

    public boolean create() {
        return this.getFile().mkdirs();
    }

    public boolean delete() {
        if (this.getFile().delete()) {
            this.attr = null;
            return true;
        }
        return false;
    }

    public String[] copyTo(Directory Destination, boolean Overwrite) {
        return this.copyTo(Destination, null, Overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] copyTo(Directory Destination, Object filter, boolean Overwrite) {
        int source = this.toString().length();
        String destination = Destination.toString();
        ArrayList<String> failures = new ArrayList<String>();
        if (!Destination.exists()) {
            Destination.create();
        }
        List results = this.getChildren(true, filter, false);
        while (true) {
            List list = results;
            synchronized (list) {
                Object item;
                while (results.isEmpty()) {
                    try {
                        results.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                if ((item = results.get(0)) == null) {
                    break;
                }
                if (item instanceof File) {
                    File file = (File)item;
                    String FilePath = file.toString();
                    File out = new File(destination + FilePath.substring(source));
                    boolean success = file.copyTo(out, Overwrite);
                    if (!success) {
                        failures.add(FilePath);
                    }
                } else {
                    Directory dir = (Directory)item;
                    new Directory(destination + dir.toString().substring(source)).create();
                }
                results.remove(0);
                results.notifyAll();
            }
        }
        return failures.toArray(new String[failures.size()]);
    }

    public void moveTo(Directory Destination, boolean Overwrite) {
        if (Overwrite || !Destination.exists()) {
            java.io.File newFile = Destination.toFile();
            if (this.getFile().renameTo(newFile)) {
                this.init(newFile);
            }
        }
    }

    public void rename(String Name) {
        java.io.File newFile = new java.io.File(this.path + Name);
        if (this.getFile().renameTo(newFile)) {
            this.init(newFile);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        String path = this.path + this.name;
        if (path.endsWith(PathSeparator)) {
            return path;
        }
        return path + PathSeparator;
    }

    public Date getDate() {
        if (this.file != null) {
            return this.getFileDate();
        }
        try {
            File.FileAttributes attr = this.getFileAttributes();
            if (attr != null) {
                return attr.getLastWriteTime();
            }
            this.getFile();
            return this.getFileDate();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private Date getFileDate() {
        if (this.file.exists() && this.file.isDirectory()) {
            return new Date(this.file.lastModified());
        }
        return null;
    }

    public boolean setDate(Date lastModified) {
        java.io.File file;
        if (lastModified != null && (file = this.getFile()).exists() && file.isDirectory()) {
            long t = lastModified.getTime();
            if (this.getDate().getTime() != t) {
                this.attr = null;
                return this.getFile().setLastModified(t);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long size = 0L;
        List results = this.getChildren(true, null, false);
        while (true) {
            Object item;
            Object object = results;
            synchronized (object) {
                while (results.isEmpty()) {
                    try {
                        results.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                item = results.remove(0);
                results.notifyAll();
            }
            if (item == null) break;
            if (item instanceof File) {
                File file = (File)item;
                size += file.getSize();
                continue;
            }
            object = (Directory)item;
        }
        return size;
    }

    public boolean isHidden() {
        if (this.file != null) {
            return this.file.isDirectory() && this.file.isHidden();
        }
        try {
            File.FileAttributes attr = this.getFileAttributes();
            if (attr != null) {
                return attr.isHidden();
            }
            this.getFile();
            return this.file.isDirectory() && this.file.isHidden();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isLink() {
        return this.getLink() != null;
    }

    public java.io.File getLink() {
        try {
            return this.getFileAttributes().getLink();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getLastModifiedTime() {
        return this.getDate();
    }

    public Date getCreationTime() {
        try {
            return this.getFileAttributes().getCreationTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getLastAccessTime() {
        try {
            return this.getFileAttributes().getLastAccessTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashSet<String> getFlags() {
        try {
            return this.getFileAttributes().getFlags();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public File.FileAttributes getFileAttributes() throws FileNotFoundException {
        if (this.attr == null) {
            this.lastAttrUpdate = 0L;
        }
        if (this.attr == null || new Date().getTime() - this.lastAttrUpdate > 1000L) {
            try {
                String pathToFile = this.toString();
                this.attr = new File.FileAttributes(pathToFile);
                if (!this.attr.isDirectory()) {
                    throw new FileNotFoundException(pathToFile);
                }
                this.lastAttrUpdate = new Date().getTime();
            }
            catch (FileNotFoundException e) {
                this.attr = null;
                throw e;
            }
            catch (Exception e) {
                this.attr = null;
            }
        }
        return this.attr;
    }

    public Directory getParentDirectory() {
        if (this.name.isEmpty()) {
            return null;
        }
        return new Directory(this.path);
    }

    public java.io.File toFile() {
        return this.getFile();
    }

    public File[] getFiles(Object filter) {
        if (this.exists()) {
            FileFilter fileFilter = new FileFilter(filter);
            Object[] files = this.listFiles(fileFilter);
            if (files == null) {
                return new File[0];
            }
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                java.io.File file = null;
                file = files[i] instanceof java.io.File ? (java.io.File)files[i] : new java.io.File(files[i].toString());
                if (!file.exists() || !file.isFile()) continue;
                list.add(new File(file));
            }
            this.sort(list, this);
            return list.toArray(new File[list.size()]);
        }
        return new File[0];
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles(Object filter, boolean RecursiveSearch) {
        if (this.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, filter, false);
                ArrayList<File> files = new ArrayList<File>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof File)) continue;
                            files.add((File)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.sort(files, this);
                return files.toArray(new File[files.size()]);
            }
            return this.getFiles(filter);
        }
        return new File[0];
    }

    public File[] getFiles(boolean RecursiveSearch) {
        return this.getFiles(null, RecursiveSearch);
    }

    public Directory[] getSubDirectories() {
        return this.getSubDirectories(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory[] getSubDirectories(boolean RecursiveSearch) {
        if (this.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, null, false);
                ArrayList<Directory> directories = new ArrayList<Directory>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof Directory)) continue;
                            directories.add((Directory)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return directories.toArray(new Directory[directories.size()]);
            }
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                @Override
                public boolean accept(java.io.File file) {
                    return file.isDirectory();
                }
            };
            Object[] files = this.listFiles(new FileFilter(fileFilter));
            if (files == null) {
                return new Directory[0];
            }
            Directory[] dirs = new Directory[files.length];
            for (int i = 0; i < files.length; ++i) {
                dirs[i] = new Directory(files[i].toString());
            }
            return dirs;
        }
        return new Directory[0];
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean RecursiveSearch) {
        return this.getChildren(RecursiveSearch, null, true);
    }

    public List getChildren(boolean RecursiveSearch, Object filter) {
        return this.getChildren(RecursiveSearch, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren(boolean RecursiveSearch, Object filter, boolean wait) {
        if (this.exists()) {
            if (RecursiveSearch) {
                LinkedList items = new LinkedList();
                FileFilter fileFilter = new FileFilter(filter);
                long directoryID = Long.valueOf(Calendar.getInstance().getTimeInMillis() + "" + new Random().nextInt(100000));
                int numThreads = 20;
                DirectorySearch.deleteCache();
                DirectorySearch search = new DirectorySearch(fileFilter, items, directoryID, numThreads);
                for (int i = 0; i < numThreads; ++i) {
                    Thread t = new Thread(search);
                    t.setName("DirectorySearch_" + directoryID + "-" + i);
                    t.start();
                }
                DirectorySearch.updatePool(this);
                if (wait) {
                    LinkedList linkedList = items;
                    synchronized (linkedList) {
                        while (!items.contains(null)) {
                            try {
                                items.wait();
                            }
                            catch (InterruptedException e) {
                                DirectorySearch.stop();
                                Thread.currentThread().interrupt();
                                return items;
                            }
                        }
                        items.remove(null);
                        items.notifyAll();
                    }
                    this.sort(items, this);
                }
                return items;
            }
            LinkedList<Comparable> list = new LinkedList<Comparable>();
            Object[] files = this.listFiles(new FileFilter(filter));
            if (files == null) {
                if (!wait) {
                    list.add(null);
                }
                return list;
            }
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory = false;
                java.io.File file = null;
                if (files[i] instanceof java.io.File) {
                    file = (java.io.File)files[i];
                    isDirectory = file.isDirectory();
                } else {
                    file = new java.io.File(files[i].toString());
                    isDirectory = files[i].toString().replace("\\", "/").endsWith("/");
                }
                if (isDirectory) {
                    list.add(new Directory(file));
                    continue;
                }
                list.add(new File(file));
            }
            this.sort(list, this);
            if (!wait) {
                LinkedList<Comparable> linkedList = list;
                synchronized (linkedList) {
                    list.add(null);
                }
            }
            return list;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (!wait) {
            list.add(null);
        }
        return list;
    }

    private java.io.File[] getSharedDrives(String serverName) {
        if (isWindows) {
            if ((serverName = serverName.replace("/", "\\\\")).startsWith("\\\\")) {
                serverName = serverName.substring(2);
            }
            if (serverName.contains("\\")) {
                serverName = serverName.substring(0, serverName.indexOf("\\"));
            }
            boolean doNetView = false;
            if (File.loadDLL()) {
                try {
                    String drives = File.GetSharedDrives(serverName);
                    if (drives != null) {
                        ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                        for (String drive : drives.split("\n")) {
                            if ((drive = drive.trim()).length() <= 0) continue;
                            String[] arr = drive.split("\t");
                            files.add(new java.io.File("\\\\" + serverName + "\\" + arr[0]));
                        }
                        if (files.isEmpty()) {
                            return null;
                        }
                        return files.toArray(new java.io.File[files.size()]);
                    }
                }
                catch (Exception e) {
                    doNetView = true;
                }
            } else {
                doNetView = true;
            }
            if (doNetView) {
                Shell cmd = new Shell("net view " + serverName);
                try {
                    cmd.run();
                }
                catch (Exception files) {
                    // empty catch block
                }
                List errors = cmd.getErrors();
                errors.remove(null);
                if (errors.isEmpty()) {
                    String path = "\\\\" + serverName + "\\";
                    Vector<String> output = cmd.getOutput();
                    Vector<String> tmp = new Vector<String>();
                    for (String row : output) {
                        if (row == null || row.trim().length() == 0) continue;
                        tmp.add(row);
                    }
                    output = tmp;
                    tmp = null;
                    ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                    int x = 0;
                    int len = -1;
                    for (String row : output) {
                        if (row.startsWith("---")) {
                            String colHeader = (String)output.get(x - 1);
                            if (colHeader.startsWith("Share name") && colHeader.contains("Type")) {
                                len = colHeader.indexOf("Type");
                            }
                        } else {
                            if (row.startsWith("The command completed successfully.")) break;
                            if (len > 0 && row.length() > len) {
                                String type = row.substring(len);
                                if ((type = type.substring(0, type.indexOf(" "))).equalsIgnoreCase("Disk")) {
                                    files.add(new java.io.File(path + row.substring(0, len).trim()));
                                }
                            }
                        }
                        ++x;
                    }
                    if (files.isEmpty()) {
                        return null;
                    }
                    return files.toArray(new java.io.File[files.size()]);
                }
            }
        }
        return null;
    }

    protected Object[] listFiles() {
        return this.listFiles(null);
    }

    private Object[] listFiles(Object filter) {
        FileFilter fileFilter = filter instanceof FileFilter ? (FileFilter)filter : new FileFilter(filter);
        String path = this.path + this.name;
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                java.io.File[] sharedDrives = this.getSharedDrives(path);
                if (sharedDrives != null) {
                    ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                    for (java.io.File file : sharedDrives) {
                        if (!file.exists()) continue;
                        if (fileFilter == null) {
                            files.add(file);
                            continue;
                        }
                        if (!fileFilter.accept(file)) continue;
                        files.add(file);
                    }
                    return files.toArray(new java.io.File[files.size()]);
                }
                return null;
            }
        }
        ArrayList<Object> files = new ArrayList<Object>();
        if (isWindows) {
            path = this.getPath();
            String[] list = this.dir();
            for (int i = 0; i < list.length; ++i) {
                boolean isDirectory = list[i].endsWith("\\");
                if (fileFilter == null || isDirectory) {
                    files.add(path + list[i]);
                    continue;
                }
                if (fileFilter.usesIOFilter()) {
                    java.io.File file = new java.io.File(path + list[i]);
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                    continue;
                }
                if (!fileFilter.accept(list[i])) continue;
                files.add(path + list[i]);
            }
        } else {
            java.io.File dir = this.getFile();
            java.io.File[] list = dir.listFiles();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    java.io.File file = list[i];
                    if (fileFilter == null) {
                        files.add(file);
                        continue;
                    }
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                }
            }
        }
        if (files.size() < 1) {
            return null;
        }
        this.sort(files, null);
        return files.toArray(new Object[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String[] dir() {
        files = new ArrayList<String>();
        dir = this.getPath();
        doDir = false;
        if (File.loadDLL()) {
            try {
                list = File.GetFiles(dir + "*");
                if (list == null) ** GOTO lbl18
                for (String name : list.split("\n")) {
                    if ((name = name.trim()).length() <= 0 || name.equals(".\\") || name.equals("..\\")) continue;
                    files.add(name);
                }
            }
            catch (Exception e) {
                doDir = true;
            }
        } else {
            doDir = true;
        }
lbl18:
        // 4 sources

        if (doDir) {
            try {
                cmd = new Shell("cmd.exe /c dir /OG " + (dir.contains(" ") != false ? "\"" + dir + "\"" : dir));
                output = cmd.getOutput();
                cmd.run();
                parseFiles = false;
                colWidth = -1;
                while (true) {
                    var9_12 = output;
                    synchronized (var9_12) {
                        while (output.isEmpty()) {
                            output.wait();
                        }
                        line = (String)output.remove(0);
                    }
                    if (line != null) {
                        if (line.length() == 0 || line.startsWith(" ")) {
                            if (!parseFiles) continue;
                            parseFiles = false;
                            continue;
                        }
                        if (!parseFiles) {
                            parseFiles = true;
                        }
                        if (!parseFiles) continue;
                        if (colWidth < 0) {
                            offset = 20;
                            type = line.substring(offset);
                            if (type.trim().startsWith("<")) {
                                offset += type.indexOf(">") + 1;
                                type = type.substring(type.indexOf("<"), type.indexOf(">") + 1);
                            } else {
                                type = "";
                            }
                            isDirectory = type.contains("<DIR>");
                            isSymLink = type.contains("<SYMLINK>");
                            isJunction = type.contains("<JUNCTION>");
                            name = line.substring(offset);
                            while (name.substring(0, 1).equals(" ")) {
                                name = name.substring(1);
                                ++offset;
                            }
                            colWidth = isDirectory || isSymLink || isJunction ? offset : (name.contains(" ") ? (this.isNumeric(name.substring(0, name.indexOf(" "))) ? offset + name.indexOf(" ") + 1 : offset) : offset);
                        }
                        if (colWidth <= 0) continue;
                        name = line.substring(colWidth);
                        type = line.substring(20, colWidth);
                        isDirectory = type.contains("<DIR>");
                        isSymLink = type.contains("<SYMLINK>");
                        isJunction = type.contains("<JUNCTION>");
                        if (isDirectory) {
                            if (name.equals(".") || name.equals("..")) continue;
                            files.add(name + Directory.PathSeparator);
                            continue;
                        }
                        if (isSymLink || isJunction) {
                            file = null;
                            if (name.contains("[") && name.contains("]")) {
                                link = name.substring(name.indexOf("[") + 1, name.indexOf("]"));
                                name = name.substring(0, name.indexOf("[")).trim();
                                file = new java.io.File(link);
                            } else {
                                file = new java.io.File(dir, name);
                            }
                            if (file.isDirectory()) {
                                name = name + Directory.PathSeparator;
                            }
                            files.add(name);
                            continue;
                        }
                        files.add(name);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException var4_7) {
                // empty catch block
            }
        }
        return files.toArray(new String[files.size()]);
    }

    private boolean isNumeric(String str) {
        try {
            if (str.contains(",")) {
                str = str.replace(",", "");
            }
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Directory) {
            return this.getFile().equals(((Directory)obj).toFile());
        }
        if (obj instanceof java.io.File) {
            if (((java.io.File)obj).isDirectory()) {
                return this.getFile().equals(obj);
            }
            return false;
        }
        return false;
    }

    public Directory clone() {
        return new Directory(this.toString());
    }

    public List getEvents() throws Exception {
        if (this.FileSystemWatcher == null) {
            this.FileSystemWatcher = new FileSystemWatcher(this);
            new Thread(this.FileSystemWatcher).start();
        }
        return this.FileSystemWatcher.getEvents();
    }

    public void stop() {
        if (this.FileSystemWatcher != null) {
            this.FileSystemWatcher.stop();
        }
        try {
            DirectorySearch.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    private void sort(List files, Directory dir) {
        try {
            Collections.sort(files, new FileComparer(dir));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class FileSystemWatcher
    implements Runnable {
        private Directory directory;
        private Timer timer;
        private boolean includeSubdirectories = true;
        private boolean terminationRequested = false;
        private Long osHandle = null;
        private List events = new LinkedList();
        private Event LastEvent = null;

        public FileSystemWatcher(Directory directory2) throws IOException {
            if (!directory2.exists()) {
                throw new IOException("Directory not found.");
            }
            this.directory = directory2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            if (!File.loadDLL()) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new EventMonitor(), new Date(), 1000L);
            } else {
                try {
                    long osWaitHandle = FileSystemWatcherNative.FindFirstChangeNotification(this.directory.getPath(), this.includeSubdirectories, -1);
                    this.osHandle = new Long(osWaitHandle);
                    FileSystemWatcherNative.FindNextChangeNotification(osWaitHandle);
                    String event = null;
                    while (!this.terminationRequested && (event = FileSystemWatcherNative.ReadDirectoryChangesW()) != null) {
                        for (String e : event.split("\n")) {
                            this.addEvent(e.trim());
                        }
                    }
                    if (FileSystemWatcherNative.WaitForSingleObject(osWaitHandle, -1) != 0) {
                        throw new Exception("Wait failed while waiting for OS to signal file system event.");
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (this.osHandle != null) {
                        System.out.println("Shutting down...");
                        try {
                            FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
                        }
                        catch (Exception exception) {}
                        this.osHandle = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addEvent(String str) {
            Event event = new Event(str);
            String action = event.getAction();
            String path = event.getFile();
            Date date = event.getDate();
            boolean exists = true;
            boolean isDirectory = false;
            try {
                isDirectory = new File.FileAttributes(path).isDirectory();
            }
            catch (Exception e) {
                exists = false;
            }
            boolean updateEvents = true;
            if (action.equalsIgnoreCase("modify")) {
                if (isDirectory || !exists) {
                    updateEvents = false;
                } else if (this.LastEvent != null) {
                    if (this.LastEvent.getFile().equals(path) && this.LastEvent.getDate().equals(date)) {
                        updateEvents = false;
                    }
                    this.LastEvent = null;
                } else {
                    this.LastEvent = event;
                }
            }
            if (action.equalsIgnoreCase("rename")) {
                updateEvents = false;
                this.LastEvent = event;
            } else if (action.equalsIgnoreCase("renam2") && this.LastEvent != null) {
                event.setOrgFile(this.LastEvent.getFile());
                event.setAction("Rename");
                this.LastEvent = null;
            }
            if (updateEvents) {
                List list = this.events;
                synchronized (list) {
                    this.events.add(event);
                    this.events.notifyAll();
                }
            }
        }

        public List getEvents() {
            return this.events;
        }

        public void stop() {
            this.terminationRequested = true;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        protected void finalize() throws Throwable {
            if (this.osHandle != null) {
                FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
            }
        }

        private class EventMonitor
        extends TimerTask {
            private List index = this.createIndex();
            private long lastUpdate = 0L;
            private long interval = 0L;

            @Override
            public final void run() {
                long startTime = Calendar.getInstance().getTimeInMillis();
                if (this.interval == 0L) {
                    this.interval = 100L;
                }
                if (startTime - this.lastUpdate > this.interval * 2L) {
                    Item item;
                    int i;
                    List orgIndex = this.index;
                    List newIndex = this.createIndex();
                    for (i = 0; i < newIndex.size(); ++i) {
                        item = (Item)newIndex.get(i);
                        if (orgIndex.contains(item)) {
                            int x = orgIndex.indexOf(item);
                            Item orgItem = (Item)orgIndex.get(x);
                            orgIndex.remove(x);
                            if (item.isDirectory() || item.getSize() == orgItem.getSize() && item.getDate() == orgItem.getDate()) continue;
                            this.addEvent("Modify", item.getPath());
                            continue;
                        }
                        this.addEvent("Create", item.getPath());
                    }
                    if (orgIndex.size() > 0) {
                        for (i = 0; i < orgIndex.size(); ++i) {
                            item = (Item)orgIndex.get(i);
                            this.addEvent("Delete", item.getPath());
                        }
                        orgIndex.clear();
                    }
                    this.index = newIndex;
                    long endTime = Calendar.getInstance().getTimeInMillis();
                    this.interval = endTime - startTime;
                    this.lastUpdate = endTime;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addEvent(String action, String file) {
                Event event = new Event(action, file);
                List list = FileSystemWatcher.this.events;
                synchronized (list) {
                    FileSystemWatcher.this.events.add(event);
                    FileSystemWatcher.this.events.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private List createIndex() {
                LinkedList<Item> index = new LinkedList<Item>();
                List files = FileSystemWatcher.this.directory.getChildren(true, null, false);
                while (true) {
                    Object obj;
                    List list = files;
                    synchronized (list) {
                        while (files.isEmpty()) {
                            try {
                                files.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        obj = files.remove(0);
                        files.notifyAll();
                    }
                    if (obj == null) break;
                    index.add(new Item(obj));
                }
                return index;
            }

            private class Item {
                private String path;
                private long size;
                private long date;
                private boolean isDirectory;

                public Item(Object obj) {
                    java.io.File file = null;
                    if (obj instanceof File) {
                        file = ((File)obj).toFile();
                    } else if (obj instanceof Directory) {
                        file = ((Directory)obj).toFile();
                    } else if (obj instanceof java.io.File) {
                        file = (java.io.File)obj;
                    }
                    if (file != null) {
                        this.path = file.getPath();
                        this.size = file.length();
                        this.date = file.lastModified();
                        this.isDirectory = file.isDirectory();
                    }
                }

                public String getPath() {
                    return this.path;
                }

                public long getSize() {
                    return this.size;
                }

                public long getDate() {
                    return this.date;
                }

                public boolean isDirectory() {
                    return this.isDirectory;
                }

                public String toString() {
                    return this.path;
                }

                public boolean equals(Object obj) {
                    if (obj instanceof Item) {
                        Item item = (Item)obj;
                        return item.getPath().equals(this.getPath());
                    }
                    return false;
                }
            }
        }
    }

    private static class DirectorySearch
    implements Runnable {
        private static ConcurrentHashMap map;
        private static ConcurrentHashMap lut;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectorySearch(FileFilter filter, List items, long directoryID, int numThreads) {
            String parentThread = Thread.currentThread().getName();
            if (map == null) {
                map = new ConcurrentHashMap();
            }
            if (DirectorySearch.getVars() == null) {
                DirectorySearch.createVars(filter, items, directoryID, numThreads);
            }
            if (lut == null) {
                lut = new ConcurrentHashMap();
            }
            ConcurrentHashMap concurrentHashMap = lut;
            synchronized (concurrentHashMap) {
                if (lut.get(parentThread) == null) {
                    lut.put(parentThread, directoryID);
                } else {
                    while (!lut.isEmpty()) {
                        try {
                            lut.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    DirectorySearch.createVars(filter, items, directoryID, numThreads);
                    lut.put(parentThread, directoryID);
                    lut.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createVars(FileFilter filter, List items, long directoryID, int numThreads) {
            ConcurrentHashMap concurrentHashMap = map;
            synchronized (concurrentHashMap) {
                ConcurrentHashMap<String, Object> vars = new ConcurrentHashMap<String, Object>();
                vars.put("items", items);
                vars.put("filter", filter);
                vars.put("pool", new LinkedList());
                vars.put("path", new LinkedList());
                vars.put("status", new LinkedList());
                vars.put("threads", new LinkedList());
                vars.put("activatedThreads", new ConcurrentHashMap());
                vars.put("numThreads", numThreads);
                map.put(directoryID, vars);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ConcurrentHashMap getVars() {
            String currentThread = Thread.currentThread().getName();
            if (currentThread.startsWith("DirectorySearch_")) {
                Long directoryID = DirectorySearch.getDirectoryID();
                return (ConcurrentHashMap)map.get(directoryID);
            }
            if (lut == null) {
                return null;
            }
            Long directoryID = null;
            ConcurrentHashMap concurrentHashMap = lut;
            synchronized (concurrentHashMap) {
                directoryID = (Long)lut.get(currentThread);
            }
            if (directoryID == null) {
                return null;
            }
            return (ConcurrentHashMap)map.get(directoryID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void deleteCache() {
            ConcurrentHashMap vars;
            if (map != null && (vars = DirectorySearch.getVars()) != null) {
                ConcurrentHashMap concurrentHashMap = vars;
                synchronized (concurrentHashMap) {
                    List path = (List)vars.get("path");
                    List items = (List)vars.get("items");
                    List status = (List)vars.get("status");
                    List list = path;
                    synchronized (list) {
                        path.clear();
                    }
                    list = items;
                    synchronized (list) {
                        items.clear();
                    }
                    list = status;
                    synchronized (list) {
                        status.clear();
                    }
                    vars.remove("startTime");
                    vars.remove("root");
                }
            }
        }

        private static Long getDirectoryID() {
            try {
                String id = Thread.currentThread().getName();
                id = id.substring(id.indexOf("_") + 1);
                id = id.substring(0, id.indexOf("-"));
                return (long)Long.valueOf(id);
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public static void stop() {
            DirectorySearch.updatePool(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updatePool(Directory directory) {
            ConcurrentHashMap vars = DirectorySearch.getVars();
            Long startTime = null;
            if (vars.get("startTime") != null) {
                startTime = (Long)vars.get("startTime");
            }
            if (startTime == null) {
                ConcurrentHashMap concurrentHashMap = vars;
                synchronized (concurrentHashMap) {
                    vars.put("startTime", DirectorySearch.getStartTime());
                    vars.put("root", directory);
                    vars.notifyAll();
                }
            }
            boolean updatePool = true;
            if (directory == null && Thread.currentThread().getName().equalsIgnoreCase("Finalizer")) {
                updatePool = false;
            }
            if (updatePool) {
                List pool;
                List list = pool = (List)vars.get("pool");
                synchronized (list) {
                    pool.add(directory);
                    pool.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addFile(File file) {
            List items;
            ConcurrentHashMap vars = DirectorySearch.getVars();
            List list = items = (List)vars.get("items");
            synchronized (list) {
                items.add(file);
                items.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addDirectory(Directory directory) {
            ConcurrentHashMap vars = DirectorySearch.getVars();
            List items = (List)vars.get("items");
            Directory root = (Directory)vars.get("root");
            List list = items;
            synchronized (list) {
                if (!directory.equals(root)) {
                    items.add(directory);
                    items.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addPath(Directory directory) {
            List path;
            List list = path = (List)DirectorySearch.getVars().get("path");
            synchronized (list) {
                path.add(directory.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removePath(Directory directory) {
            List path;
            List list = path = (List)DirectorySearch.getVars().get("path");
            synchronized (list) {
                path.remove(directory.toString());
            }
        }

        public static List getStatus() {
            ConcurrentHashMap vars = DirectorySearch.getVars();
            List status = (List)vars.get("status");
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void updateStatus() {
            ConcurrentHashMap vars = DirectorySearch.getVars();
            List status = (List)vars.get("status");
            List items = (List)vars.get("items");
            Long startTime = (Long)vars.get("startTime");
            Object object = status;
            synchronized (object) {
                status.add("ellapsedTime = " + DirectorySearch.getEllapsedTime(startTime) + " ms");
                status.notifyAll();
            }
            object = items;
            synchronized (object) {
                items.add(null);
                items.notifyAll();
            }
            ((List)vars.get("pool")).clear();
            ((List)vars.get("path")).clear();
            ((List)vars.get("threads")).clear();
            ((ConcurrentHashMap)vars.get("activatedThreads")).clear();
            object = lut;
            synchronized (object) {
                long directoryID = DirectorySearch.getDirectoryID();
                for (String parentThread : lut.keySet()) {
                    if ((Long)lut.get(parentThread) != directoryID) continue;
                    lut.remove(parentThread);
                    lut.notifyAll();
                    break;
                }
            }
        }

        public static List getItems() {
            return (List)DirectorySearch.getVars().get("items");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap vars = DirectorySearch.getVars();
            if (vars == null) {
                return;
            }
            List threads = (List)vars.get("threads");
            ConcurrentHashMap activatedThreads = (ConcurrentHashMap)vars.get("activatedThreads");
            List path = (List)vars.get("path");
            List pool = (List)vars.get("pool");
            FileFilter filter = (FileFilter)vars.get("filter");
            int numThreads = (Integer)vars.get("numThreads");
            String threadID = Thread.currentThread().getName();
            while (true) {
                Directory dir;
                Object object;
                List list = pool;
                synchronized (list) {
                    while (pool.isEmpty()) {
                        try {
                            pool.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    Object e = threads;
                    synchronized (e) {
                        threads.add(threadID);
                    }
                    e = activatedThreads;
                    synchronized (e) {
                        if (activatedThreads.get(threadID) == null) {
                            activatedThreads.put(threadID, true);
                        }
                    }
                    Object obj = pool.get(0);
                    if (obj == null) {
                        object = threads;
                        synchronized (object) {
                            threads.remove(threadID);
                        }
                        object = activatedThreads;
                        synchronized (object) {
                            activatedThreads.replace(threadID, false);
                            if (activatedThreads.size() == numThreads && !activatedThreads.containsValue(true)) {
                                DirectorySearch.updateStatus();
                            }
                        }
                        return;
                    }
                    dir = (Directory)obj;
                    pool.remove(obj);
                    pool.notifyAll();
                }
                if (dir == null) continue;
                DirectorySearch.addPath(dir);
                Object[] items = dir.listFiles();
                if (items != null) {
                    for (int i = 0; i < items.length; ++i) {
                        Object obj = items[i];
                        boolean isDirectory = false;
                        boolean accept = false;
                        if (obj instanceof String) {
                            String s = (String)obj;
                            accept = filter.accept(s);
                            isDirectory = s.replace("\\", "/").endsWith("/");
                        } else if (obj instanceof java.io.File) {
                            java.io.File f = (java.io.File)obj;
                            accept = filter.accept(f);
                            isDirectory = f.isDirectory();
                        }
                        if (!accept) continue;
                        if (isDirectory) {
                            Directory d = null;
                            if (obj instanceof String) {
                                d = new Directory((String)obj);
                            } else if (obj instanceof java.io.File) {
                                d = new Directory((java.io.File)obj);
                            }
                            if (d == null) continue;
                            DirectorySearch.addDirectory(d);
                            DirectorySearch.updatePool(d);
                            continue;
                        }
                        if (obj instanceof String) {
                            DirectorySearch.addFile(new File((String)obj));
                            continue;
                        }
                        if (!(obj instanceof java.io.File)) continue;
                        DirectorySearch.addFile(new File((java.io.File)obj));
                    }
                }
                DirectorySearch.removePath(dir);
                List list2 = threads;
                synchronized (list2) {
                    threads.remove(threadID);
                }
                list2 = path;
                synchronized (list2) {
                    if (path.isEmpty()) {
                        object = pool;
                        synchronized (object) {
                            if (pool.isEmpty()) {
                                List list3 = threads;
                                synchronized (list3) {
                                    if (threads.isEmpty()) {
                                        ConcurrentHashMap concurrentHashMap = activatedThreads;
                                        synchronized (concurrentHashMap) {
                                            activatedThreads.replace(threadID, false);
                                        }
                                        DirectorySearch.updatePool(null);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        private static long getStartTime() {
            return Calendar.getInstance().getTimeInMillis();
        }

        private static long getEllapsedTime(long StartTime) {
            try {
                long endTime = Calendar.getInstance().getTimeInMillis();
                return endTime - StartTime;
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    private class FileFilter {
        private java.io.FileFilter fileFilter = null;
        private List<Pattern> regex = null;

        public FileFilter(Object filter) {
            if (filter == null) {
                filter = "*";
            }
            if (filter instanceof java.io.FileFilter) {
                this.fileFilter = (java.io.FileFilter)filter;
            }
            if (filter instanceof String) {
                filter = new String[]{(String)filter};
            }
            if (filter instanceof String[]) {
                this.regex = new ArrayList<Pattern>();
                String[] filters = filter;
                for (int i = 0; i < filters.length; ++i) {
                    this.regex.add(Pattern.compile(this.getRegEx(filters[i]), 2));
                }
            }
        }

        public boolean accept(String file) {
            if (this.fileFilter != null) {
                return this.accept(new java.io.File(file));
            }
            if ((file = file.replace("\\", "/")).endsWith("/")) {
                return true;
            }
            file = file.substring(file.lastIndexOf("/") + 1);
            for (int i = 0; i < this.regex.size(); ++i) {
                Matcher matcher = this.regex.get(i).matcher(file);
                if (!matcher.find()) continue;
                return true;
            }
            return false;
        }

        public boolean accept(java.io.File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (this.fileFilter != null) {
                return this.fileFilter.accept(file);
            }
            return this.accept(file.toString());
        }

        public boolean usesIOFilter() {
            return this.fileFilter != null;
        }

        private String getRegEx(String wildcardSearch) {
            String regex = wildcardSearch.trim();
            if (!regex.endsWith("*")) {
                regex = regex + "$";
            }
            if (regex.endsWith("*")) {
                regex = (regex = regex.substring(0, regex.length() - 1) + ")").contains("*") ? regex.substring(0, regex.lastIndexOf("*") + 1) + "(" + regex.substring(regex.lastIndexOf("*") + 1) : "(" + regex;
            }
            regex = regex.replace(".", "\\.");
            regex = regex.replace("*", ".*");
            return regex;
        }
    }

    private class FileComparer
    implements Comparator {
        private int z;

        public FileComparer(Directory dir) {
            this.z = dir == null ? 0 : dir.toString().replace("\\", "/").length();
        }

        public final int compare(Object a, Object b) {
            String dir2;
            String x = a.toString().toUpperCase();
            String y = b.toString().toUpperCase();
            x = x.replace("\\", "/").substring(this.z);
            y = y.replace("\\", "/").substring(this.z);
            if (!x.contains("/") || !y.contains("/")) {
                if (!x.contains("/") && !y.contains("/")) {
                    return x.compareTo(y) * 10000;
                }
                return 100000;
            }
            String dir1 = x.substring(0, x.lastIndexOf("/"));
            if (!dir1.equals(dir2 = y.substring(0, y.lastIndexOf("/")))) {
                return dir1.compareTo(dir2);
            }
            return x.compareTo(y);
        }
    }

    public static class Event {
        private String file;
        private String orgFile;
        private Date date;
        private String action;
        public static final int DELETE = 0;
        public static final int CREATE = 1;
        public static final int RENAME = 2;
        public static final int MODIFY = 3;

        protected Event(String event) {
            if (event != null && (event = event.trim()).length() == 0) {
                event = null;
            }
            if (event != null) {
                try {
                    String date = event.substring(1, event.indexOf("]")).trim();
                    String text = event.substring(event.indexOf("]") + 1).trim();
                    String path = text.substring(text.indexOf(" ")).trim();
                    String action = text.substring(0, text.indexOf(" ")).trim();
                    this.date = this.parseDate(date);
                    this.file = path;
                    this.action = action;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected Event(String action, String file) {
            this.date = new Date();
            this.action = action;
            this.file = file;
        }

        private Date parseDate(String date) {
            try {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getAction() {
            return this.action;
        }

        protected void setAction(String action) {
            this.action = action;
        }

        public String getFile() {
            return this.file;
        }

        public String getOriginalFile() {
            return this.orgFile;
        }

        protected void setOrgFile(String orgFile) {
            this.orgFile = orgFile;
        }

        public final int getEventID() {
            if (this.action.equalsIgnoreCase("create")) {
                return 1;
            }
            if (this.action.equalsIgnoreCase("delete")) {
                return 0;
            }
            if (this.action.equalsIgnoreCase("modify")) {
                return 3;
            }
            if (this.action.equalsIgnoreCase("rename")) {
                return 2;
            }
            return -1;
        }

        public Date getDate() {
            return this.date;
        }

        public String toString() {
            if (this.action.equalsIgnoreCase("rename")) {
                return "[" + this.date.toString() + "] " + this.action + " " + this.orgFile + " To " + this.file;
            }
            return "[" + this.date.toString() + "] " + this.action + " " + this.file;
        }

        public boolean equals(Object obj) {
            Event event;
            return obj instanceof Event && (event = (Event)obj).getFile().equals(this.file) && event.getDate().equals(this.date) && event.getAction().equals(this.action);
        }
    }
}

