/*
 * Decompiled with CFR 0.152.
 */
package javaxt.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javaxt.json.JSONException;
import javaxt.json.JSONObject;
import javaxt.json.JSONValue;
import javaxt.utils.Value;

public class JSONArray
implements Iterable<JSONValue> {
    private final ArrayList<JSONValue> arr = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(String source) throws JSONException {
        this(new JSONObject.JSONTokener(source));
    }

    protected JSONArray(JSONObject.JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        char nextChar = x.nextClean();
        if (nextChar == '\u0000') {
            throw x.syntaxError("Expected a ',' or ']'");
        }
        if (nextChar != ']') {
            x.back();
            block5: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                } else {
                    x.back();
                    this.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case '\u0000': {
                        throw x.syntaxError("Expected a ',' or ']'");
                    }
                    case ',': {
                        nextChar = x.nextClean();
                        if (nextChar == '\u0000') {
                            throw x.syntaxError("Expected a ',' or ']'");
                        }
                        if (nextChar == ']') {
                            return;
                        }
                        x.back();
                        continue block5;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }

    @Override
    public Iterator<JSONValue> iterator() {
        return this.arr.iterator();
    }

    public int length() {
        return this.arr.size();
    }

    public boolean isEmpty() {
        return this.arr.isEmpty();
    }

    public JSONValue get(int index) {
        return index < 0 || index >= this.length() ? new JSONValue(null) : this.arr.get(index);
    }

    public void add(Object object) throws JSONException {
        Object o;
        JSONValue v;
        if (object instanceof JSONValue) {
            v = (JSONValue)object;
            o = v.toObject();
        } else if (object instanceof Value) {
            o = ((Value)object).toObject();
            v = new JSONValue(object);
        } else {
            o = object;
            v = new JSONValue(object);
        }
        JSONObject.testValidity(o);
        this.arr.add(v);
    }

    public JSONValue set(int index, Object object) {
        Object o;
        JSONValue v;
        if (object instanceof JSONValue) {
            v = (JSONValue)object;
            o = v.toObject();
        } else if (object instanceof Value) {
            o = ((Value)object).toObject();
            v = new JSONValue(object);
        } else {
            o = object;
            v = new JSONValue(object);
        }
        JSONObject.testValidity(o);
        JSONValue obj = this.arr.set(index, v);
        return new JSONValue(obj);
    }

    public JSONValue remove(int index) {
        return index >= 0 && index < this.length() ? new JSONValue(this.arr.remove(index)) : new JSONValue(null);
    }

    public boolean equals(Object obj) {
        JSONArray arr;
        if (obj instanceof JSONArray && (arr = (JSONArray)obj).length() == this.length()) {
            for (int i = 0; i < this.arr.size(); ++i) {
                JSONValue val = this.arr.get(i);
                Object val2 = arr.get(i).toObject();
                if (!(val == null ? val2 != null : !((Object)val).equals(val2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) {
        try {
            StringWriter sw = new StringWriter();
            StringBuffer stringBuffer = sw.getBuffer();
            synchronized (stringBuffer) {
                return this.write(sw, indentFactor, 0).toString();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            writer.write(91);
            if (length == 1) {
                try {
                    JSONObject.writeValue(writer, this.arr.get(0).toObject(), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONArray value at index: 0", e);
                }
            }
            if (length != 0) {
                int newindent = indent + indentFactor;
                for (int i = 0; i < length; ++i) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    try {
                        JSONObject.writeValue(writer, this.arr.get(i).toObject(), indentFactor, newindent);
                    }
                    catch (Exception e) {
                        throw new JSONException("Unable to write JSONArray value at index: " + i, e);
                    }
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }
}

