/*
 * Decompiled with CFR 0.152.
 */
package javaxt.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Map;
import javaxt.json.JSONArray;
import javaxt.json.JSONException;
import javaxt.json.JSONValue;
import javaxt.sql.Model;
import javaxt.sql.Value;
import javaxt.utils.Date;
import javaxt.utils.Record;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSONObject
extends Record {
    public JSONObject() {
    }

    public JSONObject(String source) throws JSONException {
        if (source != null) {
            this.init(new JSONTokener(source));
        }
    }

    protected JSONObject(JSONTokener source) throws JSONException {
        if (source != null) {
            this.init(source);
        }
    }

    private void init(JSONTokener x) throws JSONException {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (key != null) {
                Object value;
                if (this.get(key).toObject() != null) {
                    // empty if block
                }
                if ((value = x.nextValue()) != null) {
                    this.set(key, value);
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Record record) throws JSONException {
        for (String key : record.keySet()) {
            this.set(key, record.get(key));
        }
    }

    public JSONObject(Document xml) throws JSONException {
        this(DOM.getOuterNode(xml));
    }

    public JSONObject(Node node) throws JSONException {
        JSONObject json = new JSONObject();
        if (DOM.hasChildren(node)) {
            this.traverse(node, json);
        } else {
            json.set(node.getNodeName(), node.getTextContent());
        }
        for (String key : json.keySet()) {
            this.set(key, json.get(key));
        }
    }

    private void traverse(Node node, JSONObject json) {
        if (node.getNodeType() == 1) {
            if (DOM.hasChildren(node)) {
                JSONObject _json = new JSONObject();
                NodeList xmlNodeList = node.getChildNodes();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    this.traverse(xmlNodeList.item(i), _json);
                }
                json.set(node.getNodeName(), _json);
            } else {
                json.set(node.getNodeName(), node.getTextContent());
            }
        }
    }

    @Override
    public JSONValue get(String key) {
        return new JSONValue(super.get(key).toObject());
    }

    public JSONValue get(String ... path) {
        JSONValue val = null;
        if (path != null) {
            for (String key : path) {
                if ((val = val == null ? this.get(key) : val.get(key)).isNull()) break;
            }
        }
        if (val == null) {
            val = new JSONValue(null);
        }
        return val;
    }

    @Override
    public void set(String key, Object value) throws JSONException {
        if (value instanceof javaxt.utils.Value) {
            value = ((javaxt.utils.Value)value).toObject();
        }
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                str = null;
            }
            value = str;
        }
        if (value != null) {
            JSONObject.testValidity(value);
            super.set(key, value);
        } else {
            super.remove(key);
        }
    }

    @Override
    public JSONValue remove(String key) {
        return new JSONValue(super.remove(key).toObject());
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) {
        try {
            StringWriter w = new StringWriter();
            StringBuffer stringBuffer = w.getBuffer();
            synchronized (stringBuffer) {
                return this.write(w, indentFactor, 0).toString();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof Number) {
            String numberAsString = JSONObject.numberToString((Number)value);
            try {
                BigDecimal testNum = new BigDecimal(numberAsString);
                writer.write(numberAsString);
            }
            catch (NumberFormatException ex) {
                JSONObject.quote(numberAsString, writer);
            }
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof Date) {
            writer.write(JSONObject.quote(((Date)value).toISOString()));
        } else if (value instanceof java.util.Date) {
            writer.write(JSONObject.quote(new Date((java.util.Date)value).toISOString()));
        } else if (value instanceof Calendar) {
            writer.write(JSONObject.quote(new Date((Calendar)value).toISOString()));
        } else if (value instanceof Clob) {
            writer.write(JSONObject.quote(new Value(value).toString()));
        } else if (value instanceof Enum) {
            writer.write(JSONObject.quote(((Enum)value).name()));
        } else if (value instanceof Model) {
            JSONObject json = ((Model)value).toJson();
            json.write(writer, indentFactor, indent);
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else {
            JSONObject.quote(value.toString(), writer);
        }
        return writer;
    }

    private Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            writer.write(123);
            if (length == 1) {
                Map.Entry<String, Object> entry = super.entrySet().iterator().next();
                String key = entry.getKey();
                writer.write(JSONObject.quote(key));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                try {
                    JSONObject.writeValue(writer, entry.getValue(), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONObject value for key: " + key, e);
                }
            }
            if (length != 0) {
                int newindent = indent + indentFactor;
                for (Map.Entry<String, Object> entry : this.entrySet()) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    String key = entry.getKey();
                    writer.write(JSONObject.quote(key));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    try {
                        JSONObject.writeValue(writer, entry.getValue(), indentFactor, newindent);
                    }
                    catch (Exception e) {
                        throw new JSONException("Unable to write JSONObject value for key: " + key, e);
                    }
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    protected static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    protected static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    private static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    private static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    protected static class JSONTokener {
        private long character;
        private boolean eof;
        private long index;
        private long line;
        private char previous;
        private final Reader reader;
        private boolean usePrevious;
        private long characterPreviousLine;

        protected JSONTokener(String s) {
            StringReader reader = new StringReader(s);
            this.reader = ((Reader)reader).markSupported() ? reader : new BufferedReader(reader);
            this.eof = false;
            this.usePrevious = false;
            this.previous = '\u0000';
            this.index = 0L;
            this.character = 1L;
            this.characterPreviousLine = 0L;
            this.line = 1L;
        }

        protected void back() throws JSONException {
            if (this.usePrevious || this.index <= 0L) {
                throw new JSONException("Stepping back two steps is not supported");
            }
            this.decrementIndexes();
            this.usePrevious = true;
            this.eof = false;
        }

        private void decrementIndexes() {
            --this.index;
            if (this.previous == '\r' || this.previous == '\n') {
                --this.line;
                this.character = this.characterPreviousLine;
            } else if (this.character > 0L) {
                --this.character;
            }
        }

        private static int dehexchar(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 55;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 87;
            }
            return -1;
        }

        private boolean end() {
            return this.eof && !this.usePrevious;
        }

        private boolean more() throws JSONException {
            if (this.usePrevious) {
                return true;
            }
            try {
                this.reader.mark(1);
            }
            catch (IOException e) {
                throw new JSONException("Unable to preserve stream position", e);
            }
            try {
                if (this.reader.read() <= 0) {
                    this.eof = true;
                    return false;
                }
                this.reader.reset();
            }
            catch (IOException e) {
                throw new JSONException("Unable to read the next character from the stream", e);
            }
            return true;
        }

        private char next() throws JSONException {
            int c;
            if (this.usePrevious) {
                this.usePrevious = false;
                c = this.previous;
            } else {
                try {
                    c = this.reader.read();
                }
                catch (IOException exception) {
                    throw new JSONException(exception);
                }
            }
            if (c <= 0) {
                this.eof = true;
                return '\u0000';
            }
            this.incrementIndexes(c);
            this.previous = (char)c;
            return this.previous;
        }

        private void incrementIndexes(int c) {
            if (c > 0) {
                ++this.index;
                if (c == 13) {
                    ++this.line;
                    this.characterPreviousLine = this.character;
                    this.character = 0L;
                } else if (c == 10) {
                    if (this.previous != '\r') {
                        ++this.line;
                        this.characterPreviousLine = this.character;
                    }
                    this.character = 0L;
                } else {
                    ++this.character;
                }
            }
        }

        private char next(char c) throws JSONException {
            char n = this.next();
            if (n != c) {
                if (n > '\u0000') {
                    throw this.syntaxError("Expected '" + c + "' and instead saw '" + n + "'");
                }
                throw this.syntaxError("Expected '" + c + "' and instead saw ''");
            }
            return n;
        }

        private String next(int n) throws JSONException {
            if (n == 0) {
                return "";
            }
            char[] chars = new char[n];
            for (int pos = 0; pos < n; ++pos) {
                chars[pos] = this.next();
                if (!this.end()) continue;
                throw this.syntaxError("Substring bounds error");
            }
            return new String(chars);
        }

        protected char nextClean() throws JSONException {
            char c;
            while ((c = this.next()) != '\u0000' && c <= ' ') {
            }
            return c;
        }

        private String nextString(char quote) throws JSONException {
            StringBuilder sb = new StringBuilder();
            block15: while (true) {
                char c = this.next();
                switch (c) {
                    case '\u0000': 
                    case '\n': 
                    case '\r': {
                        throw this.syntaxError("Unterminated string");
                    }
                    case '\\': {
                        c = this.next();
                        switch (c) {
                            case 'b': {
                                sb.append('\b');
                                continue block15;
                            }
                            case 't': {
                                sb.append('\t');
                                continue block15;
                            }
                            case 'n': {
                                sb.append('\n');
                                continue block15;
                            }
                            case 'f': {
                                sb.append('\f');
                                continue block15;
                            }
                            case 'r': {
                                sb.append('\r');
                                continue block15;
                            }
                            case 'u': {
                                try {
                                    sb.append((char)Integer.parseInt(this.next(4), 16));
                                    continue block15;
                                }
                                catch (NumberFormatException e) {
                                    throw this.syntaxError("Illegal escape.", e);
                                }
                            }
                            case '\"': 
                            case '\'': 
                            case '/': 
                            case '\\': {
                                sb.append(c);
                                continue block15;
                            }
                        }
                        throw this.syntaxError("Illegal escape.");
                    }
                }
                if (c == quote) {
                    return sb.toString();
                }
                sb.append(c);
            }
        }

        private String nextTo(char delimiter) throws JSONException {
            StringBuilder sb = new StringBuilder();
            while (true) {
                char c;
                if ((c = this.next()) == delimiter || c == '\u0000' || c == '\n' || c == '\r') {
                    if (c != '\u0000') {
                        this.back();
                    }
                    return sb.toString().trim();
                }
                sb.append(c);
            }
        }

        private String nextTo(String delimiters) throws JSONException {
            StringBuilder sb = new StringBuilder();
            while (true) {
                char c;
                if (delimiters.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                    if (c != '\u0000') {
                        this.back();
                    }
                    return sb.toString().trim();
                }
                sb.append(c);
            }
        }

        protected Object nextValue() throws JSONException {
            char c = this.nextClean();
            switch (c) {
                case '\"': 
                case '\'': {
                    return this.nextString(c);
                }
                case '{': {
                    this.back();
                    return new JSONObject(this);
                }
                case '[': {
                    this.back();
                    return new JSONArray(this);
                }
            }
            StringBuilder sb = new StringBuilder();
            while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                sb.append(c);
                c = this.next();
            }
            this.back();
            String string = sb.toString().trim();
            if ("".equals(string)) {
                throw this.syntaxError("Missing value");
            }
            return JSONTokener.stringToValue(string);
        }

        private char skipTo(char to) throws JSONException {
            char c;
            try {
                long startIndex = this.index;
                long startCharacter = this.character;
                long startLine = this.line;
                this.reader.mark(1000000);
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    this.reader.reset();
                    this.index = startIndex;
                    this.character = startCharacter;
                    this.line = startLine;
                    return '\u0000';
                } while (c != to);
                this.reader.mark(1);
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
            this.back();
            return c;
        }

        protected JSONException syntaxError(String message) {
            return new JSONException(message + this.toString());
        }

        private JSONException syntaxError(String message, Throwable causedBy) {
            return new JSONException(message + this.toString(), causedBy);
        }

        public String toString() {
            return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
        }

        private static Object stringToValue(String string) {
            if (string.equals("")) {
                return string;
            }
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (string.equalsIgnoreCase("null")) {
                return null;
            }
            char initial = string.charAt(0);
            if (initial >= '0' && initial <= '9' || initial == '-') {
                try {
                    if (JSONTokener.isDecimalNotation(string)) {
                        Double d = Double.valueOf(string);
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                    } else {
                        Long myLong = Long.valueOf(string);
                        if (string.equals(myLong.toString())) {
                            if (myLong == (long)myLong.intValue()) {
                                return myLong.intValue();
                            }
                            return myLong;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string;
        }

        private static boolean isDecimalNotation(String val) {
            return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
        }
    }
}

