/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javaxt.sql.ConnectionPool;
import javaxt.sql.Database;
import javaxt.sql.Record;
import javaxt.sql.Recordset;
import javaxt.sql.Value;
import javaxt.utils.Generator;

public class Connection
implements AutoCloseable {
    private java.sql.Connection Conn = null;
    private long Speed;
    private Database database;

    public Connection() {
    }

    public Connection(java.sql.Connection conn) {
        this.open(conn);
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        try {
            return this.Conn.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public long getConnectionSpeed() {
        return this.Speed;
    }

    public java.sql.Connection getConnection() {
        return this.Conn;
    }

    public boolean open(String ConnectionString) throws SQLException {
        return this.open(new Database(ConnectionString));
    }

    public boolean open(Database database) throws SQLException {
        long startTime = System.currentTimeMillis();
        this.database = database;
        ConnectionPool connectionPool = database.getConnectionPool();
        if (connectionPool == null) {
            Driver Driver2 = database.getDriver().load();
            String url = database.getURL();
            String username = database.getUserName();
            String password = database.getPassword();
            Properties properties = database.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            if (username != null) {
                properties.put("user", username);
                properties.put("password", password);
            }
            this.Conn = Driver2.connect(url, properties);
        } else {
            this.Conn = connectionPool.getConnection().getConnection();
        }
        boolean isClosed = this.Conn.isClosed();
        this.Speed = System.currentTimeMillis() - startTime;
        return isClosed;
    }

    public boolean open(java.sql.Connection conn) {
        boolean isClosed;
        try {
            this.database = new Database(conn);
            this.Conn = conn;
            isClosed = this.Conn.isClosed();
        }
        catch (Exception e) {
            isClosed = true;
        }
        this.Speed = 0L;
        return isClosed;
    }

    @Override
    public void close() {
        try {
            this.Conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Generator<Record> getRecords(String sql) throws SQLException {
        boolean readOnly = true;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("readOnly", readOnly);
        if (readOnly) {
            props.put("fetchSize", 1000);
        }
        return this.getRecords(sql, props);
    }

    public Generator<Record> getRecords(final String sql, Map<String, Object> props) throws SQLException {
        Integer batchSize;
        Integer fetchSize;
        Boolean readOnly;
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        if (props.isEmpty()) {
            props.put("readOnly", true);
            props.put("fetchSize", 1000);
        }
        if ((readOnly = new Value(props.get("readOnly")).toBoolean()) == null) {
            readOnly = true;
        }
        if ((fetchSize = new Value(props.get("fetchSize")).toInteger()) == null) {
            fetchSize = 1000;
        }
        if ((batchSize = new Value(props.get("batchSize")).toInteger()) == null) {
            batchSize = 0;
        }
        final boolean _readOnly = readOnly;
        final int _fetchSize = fetchSize;
        final int _batchSize = batchSize;
        final Connection conn = this;
        try (Generator<Record> g = new Generator<Record>(){
            private Recordset rs;

            @Override
            public void run() throws InterruptedException {
                this.rs = new Recordset();
                if (_readOnly) {
                    this.rs.setFetchSize(_fetchSize);
                }
                try {
                    this.rs.open(sql, conn, _readOnly);
                    if (!_readOnly) {
                        this.rs.setBatchSize(_batchSize);
                    }
                    while (this.rs.next()) {
                        this.yield(this.rs.getRecord());
                    }
                }
                catch (Exception e) {
                    RuntimeException ex = new RuntimeException(e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
            }

            @Override
            public void close() {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
        };){
            Generator<Record> generator = g;
            return generator;
        }
    }

    public Record getRecord(String sql) throws SQLException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("readOnly", true);
        props.put("fetchSize", 1);
        Record record = null;
        try (Recordset rs = this.getRecordset(sql, props);){
            if (rs.hasNext()) {
                record = rs.getRecord();
            }
        }
        return record;
    }

    public Recordset getRecordset(String sql, Map<String, Object> props) throws SQLException {
        Integer batchSize;
        Integer fetchSize;
        Boolean readOnly;
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        if (props.isEmpty()) {
            props.put("readOnly", true);
            props.put("fetchSize", 1000);
        }
        if ((readOnly = new Value(props.get("readOnly")).toBoolean()) == null) {
            readOnly = true;
        }
        if ((fetchSize = new Value(props.get("fetchSize")).toInteger()) == null) {
            fetchSize = 1000;
        }
        if ((batchSize = new Value(props.get("batchSize")).toInteger()) == null) {
            batchSize = 0;
        }
        Recordset rs = new Recordset();
        if (readOnly.booleanValue()) {
            rs.setFetchSize(fetchSize);
        }
        rs.open(sql, this, readOnly);
        if (!readOnly.booleanValue()) {
            rs.setBatchSize(batchSize);
        }
        return rs;
    }

    public Recordset getRecordset(String sql, boolean readOnly) throws SQLException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("readOnly", readOnly);
        if (readOnly) {
            props.put("fetchSize", 1000);
        }
        return this.getRecordset(sql, props);
    }

    public Recordset getRecordset(String sql) throws SQLException {
        return this.getRecordset(sql, true);
    }

    public void execute(String sql) throws SQLException {
        try (PreparedStatement stmt = null;){
            stmt = this.Conn.prepareStatement(sql);
            stmt.execute();
        }
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public Database getDatabase() {
        return this.database;
    }
}

