/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.sql.ConnectionPoolDataSource;
import javaxt.sql.Connection;
import javaxt.sql.ConnectionPool;
import javaxt.sql.Driver;
import javaxt.sql.Model;
import javaxt.sql.Record;
import javaxt.sql.Table;
import javaxt.utils.Generator;
import javaxt.utils.URL;

public class Database
implements Cloneable {
    private String name;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private Driver driver;
    private Properties properties;
    private String querystring;
    private ConnectionPoolDataSource ConnectionPoolDataSource;
    private static final Class<?>[] stringType = new Class[]{String.class};
    private static final Class<?>[] integerType = new Class[]{Integer.TYPE};
    private ConnectionPool connectionPool;
    private int maxConnections = 15;
    private Table[] tables = null;
    private String[] catalogs = null;
    private boolean cacheMetadata = false;
    private static final String[] fbKeywords = new String[]{"ADD", "ADMIN", "ALL", "ALTER", "AND", "ANY", "AS", "AT", "AVG", "BEGIN", "BETWEEN", "BIGINT", "BIT_LENGTH", "BLOB", "BOTH", "BY", "CASE", "CAST", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COLLATE", "COLUMN", "COMMIT", "CONNECT", "CONSTRAINT", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_CONNECTION", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSACTION", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "ESCAPE", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FETCH", "FILTER", "FLOAT", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GDSCODE", "GLOBAL", "GRANT", "GROUP", "HAVING", "HOUR", "IN", "INDEX", "INNER", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTO", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "LONG", "LOWER", "MAX", "MAXIMUM_SEGMENT", "MERGE", "MIN", "MINUTE", "MONTH", "NATIONAL", "NATURAL", "NCHAR", "NO", "NOT", "NULL", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "PARAMETER", "PLAN", "POSITION", "POST_EVENT", "PRECISION", "PRIMARY", "PROCEDURE", "RDB$DB_KEY", "REAL", "RECORD_VERSION", "RECREATE", "RECURSIVE", "REFERENCES", "RELEASE", "RETURNING_VALUES", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROW_COUNT", "ROWS", "SAVEPOINT", "SECOND", "SELECT", "SENSITIVE", "SET", "SIMILAR", "SMALLINT", "SOME", "SQLCODE", "SQLSTATE", "START", "SUM", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRIGGER", "TRIM", "UNION", "UNIQUE", "UPDATE", "UPPER", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHERE", "WHILE", "WITH", "YEAR"};
    private static final String[] msKeywords = new String[]{"ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "MERGE", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PIVOT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVERT", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SECURITYAUDIT", "SELECT", "SEMANTICKEYPHRASETABLE", "SEMANTICSIMILARITYDETAILSTABLE", "SEMANTICSIMILARITYTABLE", "SESSION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TRY_CONVERT", "TSEQUAL", "UNION", "UNIQUE", "UNPIVOT", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WITHIN GROUP", "WRITETEXT"};
    private static final String[] h2Keywords = new String[]{"ALL", "AND", "ARRAY", "AS", "BETWEEN", "BOTH", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FILTER", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "GROUPS", "HAVING", "IF", "ILIKE", "IN", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "OR", "ORDER", "OVER", "PARTITION", "PRIMARY", "QUALIFY", "RANGE", "REGEXP", "RIGHT", "ROW", "_ROWID_", "ROWNUM", "ROWS", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TABLE", "TODAY", "TOP", "TRAILING", "TRUE", "UNION", "UNIQUE", "VALUES", "WHERE", "WINDOW", "WITH"};
    private static String[] pgKeywords = null;
    private static String[] ansiKeywords = new String[]{"ABSOLUTE", "ACTION", "ADD", "AFTER", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASYMMETRIC", "AT", "ATOMIC", "AUTHORIZATION", "AVG", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BIT_LENGTH", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOB", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "ELSEIF", "END", "EQUALS", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HANDLER", "HAVING", "HOLD", "HOUR", "IDENTITY", "IF", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAVE", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOOP", "LOWER", "MAP", "MATCH", "MAX", "MEMBER", "MERGE", "METHOD", "MIN", "MINUTE", "MODIFIES", "MODULE", "MONTH", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OBJECT", "OCTET_LENGTH", "OF", "OLD", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARAMETER", "PARTIAL", "PARTITION", "PATH", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "RANGE", "READ", "READS", "REAL", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "RELEASE", "REPEAT", "RESIGNAL", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SENSITIVE", "SESSION", "SESSION_USER", "SET", "SETS", "SIGNAL", "SIMILAR", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLCODE", "SQLERROR", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATIC", "SUBMULTISET", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "UNDER", "UNDO", "UNION", "UNIQUE", "UNKNOWN", "UNNEST", "UNTIL", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};

    public Database() {
    }

    public Database(String name, String host, int port, String username, String password, Driver driver) {
        this.name = name;
        this.host = host;
        this.port = port > 0 ? Integer.valueOf(port) : null;
        this.username = username;
        this.password = password;
        this.driver = driver;
    }

    public Database(java.sql.Connection conn) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.name = conn.getCatalog();
            this.username = dbmd.getUserName();
            this.parseURL(dbmd.getURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Database(String connStr) {
        this.parseURL(connStr);
    }

    private void parseURL(String connStr) {
        String[] arrConnStr = connStr.split(";");
        String jdbcURL = arrConnStr[0];
        if (!jdbcURL.contains("//")) {
            String protocol = jdbcURL.substring(jdbcURL.indexOf(":") + 1);
            protocol = "jdbc:" + protocol.substring(0, protocol.indexOf(":")) + ":";
            String path = jdbcURL.substring(protocol.length());
            jdbcURL = protocol + "//" + path;
        }
        URL url = new URL(jdbcURL);
        this.host = url.getHost();
        this.port = url.getPort();
        this.driver = Driver.findDriver(url.getProtocol());
        if (this.name == null) {
            this.name = url.getPath();
            if (this.name != null && this.name.startsWith("/")) {
                this.name = this.name.substring(1);
            }
        }
        this.querystring = url.getQueryString();
        if (this.querystring.length() == 0) {
            this.querystring = null;
        }
        for (int i = 1; i < arrConnStr.length; ++i) {
            String[] arrParams = arrConnStr[i].split("=");
            String paramName = arrParams[0].toLowerCase();
            String paramValue = arrParams[1];
            if (paramName.equals("database")) {
                this.name = paramValue;
                continue;
            }
            if (paramName.equals("user")) {
                this.username = paramValue;
                continue;
            }
            if (paramName.equals("password")) {
                this.password = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase("derby.system.home")) {
                System.setProperty("derby.system.home", paramValue);
                continue;
            }
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(arrParams[0], arrParams[1]);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHost(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setHost(String host) {
        if (host == null) {
            this.host = null;
        } else if ((host = host.trim()).contains(":")) {
            try {
                this.host = host.substring(0, host.indexOf(":"));
                this.port = Integer.valueOf(host.substring(host.indexOf(":") + 1));
            }
            catch (Exception e) {
                this.host = host;
            }
        } else {
            this.host = host;
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public void setDriver(String driver) {
        this.driver = Driver.findDriver(driver);
    }

    public void setDriver(java.sql.Driver driver) {
        this.driver = new Driver(driver);
    }

    public void setDriver(Class driver) {
        this.driver = Driver.findDriver(driver.getCanonicalName());
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectionString() {
        String path = this.getURL();
        if (this.username != null) {
            path = path + ";user=" + this.username;
        }
        if (this.password != null) {
            path = path + ";password=" + this.password;
        }
        return path;
    }

    protected String getURL() {
        String vendor;
        String server = this.host;
        if (this.port != null && this.port > 0) {
            server = server + ":" + this.port;
        }
        if ((vendor = this.driver.getVendor()) == null) {
            vendor = "";
        }
        if (vendor.equals("Derby") || vendor.equals("SQLite")) {
            server = ":" + server;
        }
        String database = "";
        if (this.name != null && this.name.trim().length() > 0) {
            database = vendor.equals("SQLServer") ? ";databaseName=" + this.name : (vendor.equals("Oracle") ? ":" + this.name : (vendor.equals("Derby") ? ";databaseName=" + this.name : "/" + this.name));
        }
        if (this.querystring != null) {
            database = database + "?" + this.querystring;
        }
        String path = "";
        path = this.driver.getProtocol() + "://";
        if (vendor.equals("Sybase")) {
            if (!path.toLowerCase().contains("tds:")) {
                path = this.driver.getProtocol() + "Tds:";
            }
        } else if (vendor.equals("Oracle")) {
            path = this.driver.getProtocol() + ":thin:@";
        } else if (vendor.equals("Derby") || vendor.equals("SQLite")) {
            path = this.driver.getProtocol();
        }
        StringBuilder props = new StringBuilder();
        if (this.properties != null) {
            for (Object key : this.properties.keySet()) {
                Object val = this.properties.get(key);
                props.append(";" + key + "=" + val);
            }
        }
        return path + server + database;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = new Connection();
        connection.open(this);
        return connection;
    }

    public void initConnectionPool() throws SQLException {
        if (this.connectionPool != null) {
            return;
        }
        this.initConnectionPool(new ConnectionPool(this, this.maxConnections));
    }

    public void initConnectionPool(ConnectionPool cp) throws SQLException {
        if (this.connectionPool != null) {
            return;
        }
        this.connectionPool = cp;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Database.this.connectionPool != null) {
                    try {
                        Database.this.connectionPool.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void terminateConnectionPool() throws SQLException {
        if (this.connectionPool != null) {
            this.connectionPool.close();
            this.connectionPool = null;
        }
    }

    public void setConnectionPoolSize(int maxConnections) {
        if (this.connectionPool != null) {
            return;
        }
        this.maxConnections = maxConnections;
    }

    public int getConnectionPoolSize() {
        return this.maxConnections;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource dataSource) {
        this.ConnectionPoolDataSource = dataSource;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() throws SQLException {
        if (this.ConnectionPoolDataSource != null) {
            return this.ConnectionPoolDataSource;
        }
        if (this.driver == null) {
            throw new SQLException("Failed to create a ConnectionPoolDataSource. Please specify a driver.");
        }
        String className = null;
        HashMap<String, Object> methods = new HashMap<String, Object>();
        if (this.driver.equals("sqlite")) {
            className = "org.sqlite.SQLiteConnectionPoolDataSource";
            methods.put("setUrl", "jdbc:sqlite:" + this.host);
        } else if (this.driver.equals("derby")) {
            className = "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource";
            methods.put("setDatabaseName", this.host);
            methods.put("setCreateDatabase", "create");
        } else if (this.driver.equals("h2")) {
            className = "org.h2.jdbcx.JdbcDataSource";
            methods.put("setURL", "jdbc:h2:file:" + this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("sqlserver")) {
            className = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("postgresql")) {
            className = "org.postgresql.ds.PGConnectionPoolDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("mysql")) {
            className = "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("oracle")) {
            String connDriver = "thin";
            String connService = "";
            className = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
            methods.put("setDriverType", connDriver);
            methods.put("setServerName", this.host);
            methods.put("setPortNumber", this.port);
            methods.put("setServiceName", connService);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        } else if (this.driver.equals("jtds")) {
            className = "net.sourceforge.jtds.jdbcx.JtdsDataSource";
            methods.put("setDatabaseName", this.name);
            methods.put("setServerName", this.host);
            methods.put("setUser", this.username);
            methods.put("setPassword", this.password);
        }
        if (className != null) {
            try {
                Class<?> classToLoad = Class.forName(className);
                Object instance = classToLoad.newInstance();
                for (String methodName : methods.keySet()) {
                    Object parameter = methods.get(methodName);
                    if (parameter == null) continue;
                    Method method = null;
                    if (parameter instanceof String) {
                        method = classToLoad.getMethod(methodName, stringType);
                    } else if (parameter instanceof Integer) {
                        method = classToLoad.getMethod(methodName, integerType);
                    }
                    if (method == null) continue;
                    method.invoke(instance, parameter);
                }
                this.ConnectionPoolDataSource = (ConnectionPoolDataSource)instance;
                return this.ConnectionPoolDataSource;
            }
            catch (Exception e) {
                throw new SQLException("Failed to instantiate the ConnectionPoolDataSource.", e);
            }
        }
        throw new SQLException("Failed to find a suitable ConnectionPoolDataSource.");
    }

    public Record getRecord(String sql) throws SQLException {
        try (Connection conn = this.getConnection();){
            Record record = conn.getRecord(sql);
            return record;
        }
    }

    public Generator<Record> getRecords(final String sql) throws SQLException {
        return new Generator<Record>(){

            @Override
            public void run() throws InterruptedException {
                try (Connection conn = Database.this.getConnection();){
                    for (Record record : conn.getRecords(sql)) {
                        try {
                            this.yield(record);
                        }
                        catch (InterruptedException e) {
                            if (conn != null) {
                                if (var2_3 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable throwable) {
                                        var2_3.addSuppressed(throwable);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    RuntimeException ex = new RuntimeException(e.getMessage());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
            }
        };
    }

    public Table[] getTables() throws SQLException {
        try (Connection conn = this.getConnection();){
            Table[] tableArray = Database.getTables(conn);
            return tableArray;
        }
    }

    public static Table[] getTables(Connection conn) {
        Database database = conn.getDatabase();
        if (database != null && database.tables != null) {
            return database.tables;
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            DatabaseMetaData dbmd = conn.getConnection().getMetaData();
            try (ResultSet rs = dbmd.getTables(null, null, null, new String[]{"TABLE"});){
                while (rs.next()) {
                    tables.add(new Table(rs, dbmd));
                }
            }
        }
        catch (Exception dbmd) {
            // empty catch block
        }
        Table[] arr = tables.toArray(new Table[tables.size()]);
        if (database != null && database.cacheMetadata) {
            database.tables = arr;
        }
        return arr;
    }

    public String[] getCatalogs() throws SQLException {
        try (Connection conn = this.getConnection();){
            String[] stringArray = Database.getCatalogs(conn);
            return stringArray;
        }
    }

    public static String[] getCatalogs(Connection conn) {
        Database database = conn.getDatabase();
        if (database != null && database.catalogs != null) {
            return database.catalogs;
        }
        TreeSet<String> catalogs = new TreeSet<String>();
        try {
            DatabaseMetaData dbmd = conn.getConnection().getMetaData();
            ResultSet rs = dbmd.getCatalogs();
            while (rs.next()) {
                catalogs.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception e) {
            return null;
        }
        String[] arr = catalogs.toArray(new String[catalogs.size()]);
        if (database != null && database.cacheMetadata) {
            database.catalogs = arr;
        }
        return arr;
    }

    public static String[] getReservedKeywords(Connection conn) {
        Driver driver = conn.getDatabase().getDriver();
        if (driver == null) {
            driver = new Driver("", "", "");
        }
        if (driver.equals("Firebird")) {
            return fbKeywords;
        }
        if (driver.equals("SQLServer")) {
            return msKeywords;
        }
        if (driver.equals("H2")) {
            return h2Keywords;
        }
        if (driver.equals("PostgreSQL")) {
            if (pgKeywords == null) {
                HashSet<String> arr;
                block15: {
                    arr = new HashSet<String>();
                    ResultSet rs = null;
                    Statement stmt = null;
                    try {
                        stmt = conn.getConnection().createStatement(1003, 1007, 1000);
                        rs = stmt.executeQuery("select word from pg_get_keywords() where catcode='R'");
                        while (rs.next()) {
                            arr.add(rs.getString(1));
                        }
                        rs.close();
                        stmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (stmt == null) break block15;
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                String[] keywords = new String[arr.size()];
                int i = 0;
                Iterator it = arr.iterator();
                while (it.hasNext()) {
                    keywords[i] = (String)it.next();
                    ++i;
                }
                pgKeywords = keywords;
            }
            return pgKeywords;
        }
        return ansiKeywords;
    }

    public void enableMetadataCache(boolean b) {
        this.cacheMetadata = b;
        if (!b) {
            this.tables = null;
            this.catalogs = null;
        }
    }

    public void addModel(Class c) throws SQLException {
        if (!Model.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException();
        }
        if (this.connectionPool == null) {
            this.initConnectionPool();
        }
        if (this.connectionPool == null) {
            throw new SQLException("Connection pool has not been initialized");
        }
        Model.init(c, this.connectionPool);
    }

    public static void displayDbProperties(Connection conn) {
        DatabaseMetaData dm = null;
        ResultSet rs = null;
        try {
            if (conn != null) {
                dm = conn.getConnection().getMetaData();
                System.out.println("Driver Information");
                System.out.println("\tDriver Name: " + dm.getDriverName());
                System.out.println("\tDriver Version: " + dm.getDriverVersion());
                System.out.println("\nDatabase Information ");
                System.out.println("\tDatabase Name: " + dm.getDatabaseProductName());
                System.out.println("\tDatabase Version: " + dm.getDatabaseProductVersion());
                System.out.println("Avalilable Catalogs ");
                rs = dm.getCatalogs();
                while (rs.next()) {
                    System.out.println("\tcatalog: " + rs.getString(1));
                }
                rs.close();
                rs = null;
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dm = null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name: " + this.name + "\r\n");
        str.append("Host: " + this.host + "\r\n");
        str.append("Port: " + this.port + "\r\n");
        str.append("UserName: " + this.username + "\r\n");
        str.append("Driver: " + this.driver + "\r\n");
        str.append("URL: " + this.getURL() + "\r\n");
        str.append("ConnStr: " + this.getConnectionString());
        return str.toString();
    }

    public Database clone() {
        Database db = new Database(this.name, this.host, this.port == null ? -1 : this.port, this.username, this.password, this.driver);
        if (this.properties != null) {
            db.properties = (Properties)this.properties.clone();
        }
        db.querystring = this.querystring;
        return db;
    }
}

