/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.io.Jar;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Connection;
import javaxt.sql.ConnectionPool;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Function;
import javaxt.sql.Record;
import javaxt.sql.Recordset;
import javaxt.sql.Value;

public abstract class Model {
    protected Long id;
    private String tableName;
    private final String modelName;
    private final HashMap<String, String> fieldMap;
    private String[] keywords;
    private static ConcurrentHashMap<String, PreparedStatement> sqlCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, PreparedStatement> insertStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConnectionPool> connPool = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String[]> reservedKeywords = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Field[]> fields = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String[]> tables = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model(String tableName, Map<String, String> fieldMap) {
        Class<?> c = this.getClass();
        String className = c.getName();
        this.modelName = c.getSimpleName();
        ConcurrentHashMap<String, String[]> concurrentHashMap = reservedKeywords;
        synchronized (concurrentHashMap) {
            this.keywords = reservedKeywords.get(className);
        }
        concurrentHashMap = tables;
        synchronized (concurrentHashMap) {
            String[] tableInfo = tables.get(className);
            if (tableInfo == null) {
                tableInfo = this.getTableInfo(tableName);
                tables.put(className, tableInfo);
            }
            this.tableName = tableInfo[0];
        }
        this.fieldMap = new HashMap();
        for (String key : fieldMap.keySet()) {
            String val = fieldMap.get(key);
            this.fieldMap.put(key, val);
        }
    }

    public Long getID() {
        return this.id;
    }

    public void setID(Long id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(long id) throws SQLException {
        Object rs22;
        Connection conn;
        Object fieldName;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (java.lang.reflect.Field f : this.getClass().getDeclaredFields()) {
            Class<?> c;
            fieldName = f.getName();
            String columnName = this.fieldMap.get(fieldName);
            if (columnName == null || ArrayList.class.isAssignableFrom(c = f.getType())) continue;
            String className = c.getSimpleName();
            if (className.equals("Geometry")) {
                fieldNames.add("ST_AsText(" + columnName + ") as " + columnName);
                continue;
            }
            fieldNames.add(columnName);
        }
        StringBuilder sql = new StringBuilder("select ");
        boolean addID = true;
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName2;
            if (i > 0) {
                sql.append(", ");
            }
            if ((fieldName2 = (String)fieldNames.get(i)).equalsIgnoreCase("id")) {
                addID = false;
            }
            sql.append(this.escape(fieldName2));
        }
        if (addID) {
            sql.append(", id");
        }
        sql.append(" from ");
        sql.append(this.tableName);
        sql.append(" where id=");
        Statement stmt = null;
        String query = sql.toString() + "?";
        try {
            fieldName = sqlCache;
            synchronized (fieldName) {
                stmt = sqlCache.get(query);
                if (stmt == null) {
                    conn = Model.getConnection(this.getClass());
                    stmt = conn.getConnection().prepareStatement(query);
                    sqlCache.put(query, (PreparedStatement)stmt);
                    sqlCache.notify();
                }
                stmt.setLong(1, id);
                rs22 = stmt.executeQuery();
                if (!rs22.next()) {
                    rs22.close();
                    throw new IllegalArgumentException();
                }
                this.update(rs22);
                this.id = id;
                rs22.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(this.modelName + " not found");
        }
        catch (Exception e) {
            if (stmt != null && stmt.getConnection().isClosed()) {
                rs22 = sqlCache;
                synchronized (rs22) {
                    sqlCache.remove(query);
                    sqlCache.notifyAll();
                }
                try {
                    stmt.close();
                }
                catch (Exception rs22) {
                    // empty catch block
                }
                this.init(id);
                return;
            }
            conn = Model.getConnection(this.getClass());
            Throwable throwable = null;
            try {
                query = sql.toString() + id;
                try (Recordset rs = conn.getRecordset(query);){
                    rs.open(query, conn);
                    if (rs.EOF) {
                        throw new SQLException(this.modelName + " not found");
                    }
                    this.update(rs);
                    this.id = id;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    protected abstract void update(Object var1) throws SQLException;

    protected abstract void update(JSONObject var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void save() throws SQLException {
        void var5_8;
        String className = this.getClass().getName();
        LinkedHashMap<java.lang.reflect.Field, Object> fields = this.getFields();
        ArrayList<java.lang.reflect.Field> arr = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : fields.keySet()) {
            String fieldName = field.getName();
            Class<?> clazz = field.getType();
            if (clazz.equals(ArrayList.class)) {
                arr.add(field);
            }
            if (!fieldName.equalsIgnoreCase("id")) continue;
            arr.add(field);
        }
        for (Object f : arr) {
            fields.remove(f);
        }
        boolean bl = false;
        for (Map.Entry entry : fields.entrySet()) {
            Object v = entry.getValue();
            if (v != null) {
                JSONObject json;
                if (v instanceof Model) {
                    Model model = (Model)v;
                    model.save();
                    entry.setValue(model.getID());
                } else if (v instanceof JSONObject && (json = (JSONObject)v).isEmpty()) {
                    entry.setValue(null);
                }
            }
            if (entry.getValue() != null) continue;
            ++var5_8;
        }
        if (var5_8 == fields.size()) {
            return;
        }
        if (this.id == null) {
            String columnName;
            Field[] dbFields;
            ConcurrentHashMap<String, Field[]> concurrentHashMap = Model.fields;
            synchronized (concurrentHashMap) {
                dbFields = Model.fields.get(className);
            }
            if (dbFields == null) {
                throw new SQLException("Failed to retrieve metadata for " + className + ". The model may not have been initialized. See Model.init()");
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (java.lang.reflect.Field field : fields.keySet()) {
                Field[] obj;
                Class<?> fieldType = field.getType();
                String packageName = fieldType.getPackage() == null ? "" : fieldType.getPackage().getName();
                Object val = fields.get(field);
                if (packageName.startsWith("javaxt.geospatial.geometry") || packageName.startsWith("com.vividsolutions.jts.geom") || packageName.startsWith("org.locationtech.jts.geom")) {
                    int srid = 4326;
                    try {
                        Method method = fieldType.getMethod("getSRID", new Class[0]);
                        if (method != null && (obj = method.invoke(val, null)) != null && (srid = ((Integer)obj).intValue()) == 0) {
                            srid = 4326;
                        }
                    }
                    catch (Exception method) {
                        // empty catch block
                    }
                    val = new Function(null, new Object[]{val == null ? null : val.toString(), srid});
                } else if (packageName.startsWith("javaxt.json") || packageName.startsWith("org.json")) {
                    val = new Function(null, new Object[]{val == null ? null : val.toString()});
                }
                boolean foundField = false;
                columnName = this.fieldMap.get(field.getName());
                obj = dbFields;
                int n = obj.length;
                for (int i = 0; i < n; ++i) {
                    Field field2 = obj[i];
                    if (!field2.getName().equalsIgnoreCase(columnName)) continue;
                    field2 = field2.clone();
                    field2.Value = new Value(val);
                    arrayList.add(field2);
                    foundField = true;
                    break;
                }
                if (foundField) continue;
                throw new SQLException("Model/Schema mismatch. Failed to find " + columnName + " in the database.");
            }
            ConcurrentHashMap<String, PreparedStatement> concurrentHashMap2 = insertStatements;
            synchronized (concurrentHashMap2) {
                Serializable sql;
                PreparedStatement stmt = insertStatements.get(className);
                if (stmt == null) {
                    Connection conn = Model.getConnection(this.getClass());
                    sql = new StringBuilder();
                    ((StringBuilder)sql).append("INSERT INTO " + this.tableName + " (");
                    Iterator<java.lang.reflect.Field> it = fields.keySet().iterator();
                    while (it.hasNext()) {
                        java.lang.reflect.Field f3 = it.next();
                        columnName = this.fieldMap.get(f3.getName());
                        ((StringBuilder)sql).append(this.escape(columnName));
                        if (!it.hasNext()) continue;
                        ((StringBuilder)sql).append(",");
                    }
                    ((StringBuilder)sql).append(") VALUES (");
                    it = fields.keySet().iterator();
                    while (it.hasNext()) {
                        java.lang.reflect.Field f4 = it.next();
                        Class<?> fieldType = f4.getType();
                        String packageName = fieldType.getPackage() == null ? "" : fieldType.getPackage().getName();
                        String q = "?";
                        if (packageName.startsWith("javaxt.json") || packageName.startsWith("org.json")) {
                            Driver driver = conn.getDatabase().getDriver();
                            if (driver.equals("PostgreSQL")) {
                                q = "?::jsonb";
                            }
                        } else if (packageName.startsWith("javaxt.geospatial.geometry") || packageName.startsWith("com.vividsolutions.jts.geom") || packageName.startsWith("org.locationtech.jts.geom")) {
                            String columnName2 = this.fieldMap.get(f4.getName());
                            String STGeomFromText = null;
                            for (Field field : dbFields) {
                                if (!field.getName().equals(columnName2)) continue;
                                STGeomFromText = Recordset.getSTGeomFromText(field, conn);
                                break;
                            }
                            q = STGeomFromText + "(?,?)";
                        }
                        ((StringBuilder)sql).append(q);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)sql).append(",");
                    }
                    ((StringBuilder)sql).append(")");
                    stmt = conn.getConnection().prepareStatement(((StringBuilder)sql).toString(), 1);
                    insertStatements.put(className, stmt);
                    insertStatements.notify();
                }
                try {
                    Recordset.update(stmt, arrayList);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (stmt != null && stmt.getConnection().isClosed()) {
                        sql = insertStatements;
                        synchronized (sql) {
                            insertStatements.remove(className);
                            insertStatements.notifyAll();
                        }
                        this.save();
                    }
                    throw this.Exception("Failed to save " + className + ". " + e.getMessage(), e);
                }
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                if (generatedKeys.next()) {
                    this.id = new Value(generatedKeys.getString(1)).toLong();
                }
            }
        }
        try {
            Throwable throwable = null;
            try (Connection conn = Model.getConnection(this.getClass());){
                Driver driver = conn.getDatabase().getDriver();
                if (driver == null) {
                    Driver driver2 = new Driver("", "", "");
                }
                Recordset rs = conn.getRecordset("select * from " + this.tableName + " where id=" + this.id, false);
                if (rs.EOF) {
                    rs.addNew();
                    rs.setValue("id", this.id);
                }
                for (java.lang.reflect.Field f : fields.keySet()) {
                    String columnName = this.fieldMap.get(f.getName());
                    Object val = fields.get(f);
                    if (val instanceof JSONObject || val instanceof JSONArray) {
                        void var8_24;
                        if (var8_24.equals("PostgreSQL")) {
                            rs.setValue(columnName, new Function("?::jsonb", new Object[]{val.toString()}));
                            continue;
                        }
                        rs.setValue(columnName, val.toString());
                        continue;
                    }
                    rs.setValue(columnName, val);
                }
                rs.update();
                rs.close();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException e) {
            throw this.Exception("Failed to update " + className + "#" + this.id + ". " + e.getMessage(), e);
        }
    }

    public void delete() throws SQLException {
        if (this.id == null) {
            return;
        }
        try (Connection conn = Model.getConnection(this.getClass());){
            conn.execute("delete from " + this.tableName + " where id=" + this.id);
        }
        catch (SQLException e) {
            String className = this.getClass().getName();
            throw this.Exception("Failed to delete " + className + "#" + this.id + ". " + e.getMessage(), e);
        }
    }

    private SQLException Exception(String err, SQLException e) {
        SQLException ex = new SQLException(err);
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        boolean addElement = false;
        StackTraceElement[] arr = ex.getStackTrace();
        for (int i = 2; i < arr.length; ++i) {
            StackTraceElement el = arr[i];
            if (!el.getClassName().contains("reflect")) {
                addElement = true;
            }
            if (!addElement) continue;
            stackTrace.add(el);
        }
        ex.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        ex.setNextException(e);
        return ex;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        if (this.id != null) {
            json.set("id", this.id);
        }
        LinkedHashMap<java.lang.reflect.Field, Object> fields = this.getFields();
        for (java.lang.reflect.Field f : fields.keySet()) {
            String fieldName = f.getName();
            Object val = fields.get(f);
            if (val == null) continue;
            if (val instanceof ArrayList) {
                Class<?> c;
                ArrayList list = (ArrayList)val;
                if (!list.isEmpty() && Model.class.isAssignableFrom(c = list.get(0).getClass())) {
                    JSONArray arr = new JSONArray();
                    for (Object obj : list) {
                        arr.add(((Model)obj).toJson());
                    }
                    val = arr;
                }
            } else if (val instanceof Model) {
                val = ((Model)val).toJson();
            }
            json.set(fieldName, val);
        }
        return json;
    }

    public boolean equals(Object obj) {
        if (this.id != null && this.getClass().isAssignableFrom(obj.getClass())) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? -1 : (int)(this.id ^ this.id >>> 32);
    }

    protected static Object _get(Class c, Object ... args) throws SQLException {
        if (args.length == 1) {
            if (args[0] instanceof Long || args[0] instanceof Integer) {
                try {
                    long id = args[0] instanceof Long ? ((Long)args[0]).longValue() : new Long(((Integer)args[0]).intValue()).longValue();
                    return c.getConstructor(Long.TYPE).newInstance(id);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }
        String sql = Model.getSQL(c, args);
        Long id = null;
        try (Connection conn = Model.getConnection(c);){
            Record record = conn.getRecord(sql);
            if (record != null) {
                id = record.get(0).toLong();
            }
        }
        if (id != null) {
            try {
                return c.getConstructor(Long.TYPE).newInstance(id);
            }
            catch (Exception e) {
                throw new SQLException("Failed to instantiate model for " + id);
            }
        }
        return null;
    }

    protected static Object[] _find(Class c, Object ... args) throws SQLException {
        String sql = Model.getSQL(c, args);
        ArrayList<Long> ids = new ArrayList<Long>();
        Connection conn = Model.getConnection(c);
        Object object = null;
        try {
            for (Record record : conn.getRecords(sql)) {
                ids.add(record.get(0).toLong());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (object != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        if (!ids.isEmpty()) {
            ArrayList arr = new ArrayList(ids.size());
            object = ids.iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                try {
                    arr.add(c.getConstructor(Long.TYPE).newInstance(id));
                }
                catch (Exception e) {
                    throw new SQLException("Failed to instantiate model for " + id);
                }
            }
            return arr.toArray();
        }
        return new Object[0];
    }

    private static String getSQL(Class c, Object ... args) {
        String tableName = null;
        try {
            tableName = ((Model)c.newInstance()).tableName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder str = new StringBuilder("select ");
        str.append(tableName);
        str.append(".id from ");
        str.append(tableName);
        if (args.length > 1) {
            str.append(" where ");
            for (int i = 0; i < args.length - 1; ++i) {
                str.append(args[i]);
                Object val = args[++i];
                if (val instanceof String) {
                    str.append("'");
                    str.append(val.toString().replace("'", "''"));
                    str.append("'");
                } else {
                    str.append(val);
                }
                if (i >= args.length - 2) continue;
                str.append(" and ");
            }
        }
        return str.toString();
    }

    protected Value getValue(Object rs, String key) throws SQLException {
        if (rs instanceof ResultSet) {
            return new Value(((ResultSet)rs).getObject(key));
        }
        return ((Recordset)rs).getValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Connection getConnection(Class c) throws SQLException {
        ConnectionPool connectionPool = null;
        ConcurrentHashMap<String, ConnectionPool> concurrentHashMap = connPool;
        synchronized (concurrentHashMap) {
            connectionPool = connPool.get(c.getName());
        }
        if (connectionPool != null) {
            return connectionPool.getConnection();
        }
        throw new SQLException("Failed to find connection for " + c.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class c, ConnectionPool connectionPool) throws SQLException {
        if (!Model.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException();
        }
        String className = c.getName();
        try (Connection conn = connectionPool.getConnection();){
            ConcurrentHashMap<String, ConnectionPool> concurrentHashMap = connPool;
            synchronized (concurrentHashMap) {
                connPool.put(className, connectionPool);
                connPool.notifyAll();
            }
            String[] keywords = Database.getReservedKeywords(conn);
            ConcurrentHashMap<String, String[]> concurrentHashMap2 = reservedKeywords;
            synchronized (concurrentHashMap2) {
                reservedKeywords.put(className, keywords);
                reservedKeywords.notifyAll();
            }
            Model model = (Model)c.newInstance();
            String sql = "select * from " + model.tableName + " where id is null";
            try (Recordset rs = conn.getRecordset(sql);){
                ConcurrentHashMap<String, Field[]> concurrentHashMap3 = fields;
                synchronized (concurrentHashMap3) {
                    fields.put(className, rs.getFields());
                    fields.notifyAll();
                }
            }
        }
        catch (Exception e) {
            SQLException ex = new SQLException("Failed to initialize Model: " + className);
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public static void init(Jar jar, ConnectionPool connectionPool) throws SQLException {
        for (Class c : jar.getClasses()) {
            if (!Model.class.isAssignableFrom(c)) continue;
            Model.init(c, connectionPool);
        }
    }

    public static String getTableName(Model model) {
        return model.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSchemaName(String schemaName, Class c) {
        if (!Model.class.isAssignableFrom(c)) {
            return;
        }
        String className = c.getName();
        try {
            Model model = (Model)c.newInstance();
            ConcurrentHashMap<String, String[]> concurrentHashMap = tables;
            synchronized (concurrentHashMap) {
                String[] tableInfo = tables.get(className);
                String tableName = tableInfo[1];
                if (schemaName != null) {
                    tableName = schemaName + "." + tableName;
                }
                tableInfo = model.getTableInfo(tableName);
                tables.put(className, tableInfo);
            }
        }
        catch (Exception e) {
            Exception ex = new Exception("Failed to update schema for Model: " + className);
            ex.setStackTrace(e.getStackTrace());
            throw new RuntimeException(ex);
        }
    }

    private String[] getTableInfo(String tableName) {
        String escapedTableName;
        String schemaName;
        int idx = tableName.indexOf(".");
        if (idx > -1) {
            schemaName = tableName.substring(0, idx);
            tableName = tableName.substring(idx + 1);
            escapedTableName = this.escape(schemaName) + "." + tableName;
        } else {
            schemaName = null;
            escapedTableName = this.escape(tableName);
        }
        return new String[]{escapedTableName, tableName, schemaName};
    }

    protected String escape(String colName) {
        if (this.keywords == null) {
            return colName;
        }
        for (String keyWord : this.keywords) {
            if (!colName.equalsIgnoreCase(keyWord)) continue;
            colName = "\"" + colName + "\"";
            break;
        }
        return colName;
    }

    private LinkedHashMap<java.lang.reflect.Field, Object> getFields() {
        LinkedHashMap<java.lang.reflect.Field, Object> fields = new LinkedHashMap<java.lang.reflect.Field, Object>();
        for (java.lang.reflect.Field f : this.getClass().getDeclaredFields()) {
            String fieldName = f.getName();
            if (!this.fieldMap.containsKey(fieldName)) continue;
            Object val = null;
            try {
                f.setAccessible(true);
                val = f.get(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fields.put(f, val);
        }
        return fields;
    }
}

