/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.ResultSet;
import javaxt.json.JSONObject;
import javaxt.sql.Field;
import javaxt.sql.Value;

public class Record {
    protected Field[] fields;

    protected Record(Field[] fields) {
        if (fields == null) {
            fields = new Field[]{};
        }
        this.fields = fields;
    }

    protected void update(ResultSet rs) {
        try {
            for (int i = 1; i <= this.fields.length; ++i) {
                Field Field2 = this.fields[i - 1];
                Field2.Value = rs == null ? null : new Value(rs.getObject(i));
                Field2.RequiresUpdate = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Field[] getFields() {
        Field[] arr = new Field[this.fields.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.fields[i].clone();
            arr[i].Value = this.fields[i].Value;
        }
        return arr;
    }

    public Field getField(String FieldName) {
        if (this.fields.length == 0) {
            return null;
        }
        if (FieldName == null) {
            return null;
        }
        if ((FieldName = FieldName.trim()).length() == 0) {
            return null;
        }
        String[] arr = FieldName.split("\\.");
        for (Field field : this.fields) {
            String schemaName;
            String fieldName = field.getName();
            if (fieldName == null) continue;
            String tableName = field.getTable() == null ? "" : field.getTable();
            String string = schemaName = field.getSchema() == null ? "" : field.getSchema();
            if (!(arr.length == 3 ? fieldName.equalsIgnoreCase(arr[2]) && tableName.equalsIgnoreCase(arr[1]) && schemaName.equalsIgnoreCase(arr[0]) : (arr.length == 2 ? fieldName.equalsIgnoreCase(arr[1]) && tableName.equalsIgnoreCase(arr[0]) : arr.length == 1 && fieldName.equalsIgnoreCase(arr[0])))) continue;
            return field;
        }
        return null;
    }

    public Field getField(int i) {
        if (i > -1 && i < this.fields.length) {
            return this.fields[i];
        }
        return null;
    }

    public Value get(String fieldName) {
        Field field = this.getField(fieldName);
        if (field != null) {
            return field.getValue();
        }
        return new Value(null);
    }

    public Value get(int i) {
        if (this.fields != null && i < this.fields.length) {
            return this.fields[i].getValue();
        }
        return new Value(null);
    }

    public void set(String FieldName, Value FieldValue) {
        for (Field field : this.fields) {
            String name = field.getName();
            if (name == null || !name.equalsIgnoreCase(FieldName)) continue;
            if (FieldValue == null) {
                FieldValue = new Value(null);
            }
            if (field.getValue().equals(FieldValue)) break;
            field.Value = FieldValue;
            field.RequiresUpdate = true;
            break;
        }
    }

    public boolean isDirty() {
        for (Field field : this.fields) {
            if (!field.isDirty()) continue;
            return true;
        }
        return false;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        for (Field field : this.fields) {
            json.set(field.getName(), field.getValue());
        }
        return json;
    }
}

