/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Function;
import javaxt.sql.Key;
import javaxt.sql.Parser;
import javaxt.sql.Record;
import javaxt.sql.Table;
import javaxt.sql.Value;
import javaxt.utils.Java;

public class Recordset
implements AutoCloseable {
    private ResultSet rs = null;
    private Statement stmt = null;
    private int x;
    private int n;
    private boolean isReadOnly = true;
    private String sqlString = null;
    private Connection connection = null;
    private Driver driver = null;
    private boolean autoCommit = true;
    private Value GeneratedKey;
    private ArrayList keys = new ArrayList();
    private int State = 0;
    public boolean EOF = false;
    private Record record;
    private Table[] Tables = null;
    private Integer maxRecords = null;
    private Integer fetchSize = null;
    private int numBatches = 0;
    private int batchSize = 1;
    private HashMap<String, PreparedStatement> batchedStatements;
    private long queryResponseTime;
    private long ellapsedTime;
    private long metadataQueryTime;
    private long startTime;
    private long endTime;
    private String queryID;
    private static AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private static final Thread shutdownHook = Recordset.getShutdownHook();
    private static final ConcurrentHashMap<String, Recordset> queries = new ConcurrentHashMap();
    private boolean InsertOnUpdate = false;

    public Recordset() {
        if (shuttingDown.get()) {
            throw new IllegalStateException("JVM shutting down");
        }
    }

    private static Thread getShutdownHook() {
        Thread shutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                shuttingDown.set(true);
                ConcurrentHashMap concurrentHashMap = queries;
                synchronized (concurrentHashMap) {
                    Iterator it = ((ConcurrentHashMap.KeySetView)queries.keySet()).iterator();
                    while (it.hasNext()) {
                        Recordset rs = (Recordset)queries.get(it.next());
                        Statement stmt = rs.stmt;
                        if (stmt == null) continue;
                        try {
                            stmt.cancel();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    queries.clear();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return shutdownHook;
    }

    public boolean isOpen() {
        if (this.State != 0) {
            int javaVersion = Java.getVersion();
            if (javaVersion < 6) {
                return false;
            }
            try {
                return (Boolean)this.rs.getClass().getMethod("isClosed", new Class[0]).invoke((Object)this.rs, null) == false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ResultSet open(String sql, Connection conn) throws SQLException {
        return this.open(sql, conn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet open(String sqlString, Connection connection, boolean ReadOnly) throws SQLException {
        block44: {
            if (shuttingDown.get()) {
                throw new IllegalStateException("JVM shutting down");
            }
            if (connection == null) {
                throw new SQLException("Connection is null.");
            }
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed.");
            }
            this.rs = null;
            this.stmt = null;
            this.State = 0;
            this.EOF = true;
            this.Tables = null;
            this.sqlString = sqlString;
            this.connection = connection;
            this.isReadOnly = ReadOnly;
            this.driver = connection.getDatabase().getDriver();
            if (this.driver == null) {
                this.driver = new Driver("", "", "");
            }
            this.startTime = System.currentTimeMillis();
            this.endTime = 0L;
            this.metadataQueryTime = 0L;
            this.ellapsedTime = 0L;
            this.queryResponseTime = 0L;
            java.sql.Connection Conn = connection.getConnection();
            this.autoCommit = Conn.getAutoCommit();
            this.queryID = UUID.randomUUID().toString();
            ConcurrentHashMap<String, Recordset> concurrentHashMap = queries;
            synchronized (concurrentHashMap) {
                queries.put(this.queryID, this);
            }
            if (ReadOnly) {
                try {
                    if (this.fetchSize != null) {
                        Conn.setAutoCommit(false);
                    }
                    if (this.driver.equals("DB2") || this.driver.equals("SQLite")) {
                        this.stmt = Conn.createStatement(1003, 1007);
                    } else if (this.driver.equals("PostgreSQL")) {
                        this.stmt = this.fetchSize != null ? Conn.createStatement(1003, 1007, 1000) : Conn.createStatement(1004, 1007);
                    } else {
                        try {
                            this.stmt = Conn.createStatement(1004, 1007);
                        }
                        catch (SQLException e) {
                            this.stmt = Conn.createStatement();
                        }
                    }
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                }
                catch (SQLException e) {
                    ConcurrentHashMap<String, Recordset> concurrentHashMap2 = queries;
                    synchronized (concurrentHashMap2) {
                        queries.remove(this.queryID);
                    }
                    throw e;
                }
            }
            try {
                if (this.driver.equals("SYBASE")) {
                    if (this.fetchSize != null) {
                        Conn.setAutoCommit(false);
                    }
                    this.stmt = Conn.createStatement(1003, 1008);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                    break block44;
                }
                if (this.driver.equals("SQLite")) {
                    if (this.fetchSize != null) {
                        Conn.setAutoCommit(false);
                    }
                    this.stmt = Conn.createStatement(1003, 1007);
                    if (this.fetchSize != null) {
                        this.stmt.setFetchSize(this.fetchSize);
                    }
                    this.rs = this.stmt.executeQuery(sqlString);
                    this.State = 1;
                    break block44;
                }
                if (this.driver.equals("DB2")) {
                    try {
                        if (this.fetchSize != null) {
                            Conn.setAutoCommit(false);
                        }
                        this.stmt = Conn.createStatement(1005, 1008);
                        if (this.fetchSize != null) {
                            this.stmt.setFetchSize(this.fetchSize);
                        }
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        this.rs = null;
                    }
                    if (this.rs == null) {
                        try {
                            if (this.fetchSize != null) {
                                Conn.setAutoCommit(false);
                            }
                            this.stmt = Conn.createStatement(1003, 1008);
                            if (this.fetchSize != null) {
                                this.stmt.setFetchSize(this.fetchSize);
                            }
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                        }
                        catch (Exception e) {}
                    }
                    break block44;
                }
                if (this.fetchSize != null) {
                    Conn.setAutoCommit(false);
                }
                this.stmt = Conn.createStatement(1005, 1008);
                if (this.fetchSize != null) {
                    this.stmt.setFetchSize(this.fetchSize);
                }
                this.rs = this.stmt.executeQuery(sqlString);
                this.State = 1;
            }
            catch (SQLException e) {
                ConcurrentHashMap<String, Recordset> concurrentHashMap3 = queries;
                synchronized (concurrentHashMap3) {
                    queries.remove(this.queryID);
                }
                throw e;
            }
        }
        this.endTime = System.currentTimeMillis();
        this.queryResponseTime = this.endTime - this.startTime;
        this.init();
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(ResultSet resultSet) {
        if (shuttingDown.get()) {
            throw new IllegalStateException("JVM shutting down");
        }
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.metadataQueryTime = 0L;
        this.ellapsedTime = 0L;
        this.queryResponseTime = 0L;
        this.EOF = true;
        this.rs = resultSet;
        this.queryID = UUID.randomUUID().toString();
        ConcurrentHashMap<String, Recordset> concurrentHashMap = queries;
        synchronized (concurrentHashMap) {
            queries.put(this.queryID, this);
        }
        this.init();
    }

    private void init() {
        this.n = 0;
        try {
            int i;
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            Field[] fields = new Field[cols];
            for (i = 1; i <= cols; ++i) {
                fields[i - 1] = new Field(i, rsmd);
            }
            this.record = new Record(fields);
            rsmd = null;
            this.x = -1;
            if (this.rs != null) {
                if (this.rs.next()) {
                    this.EOF = false;
                    for (i = 1; i <= cols; ++i) {
                        fields[i - 1].Value = new Value(this.rs.getObject(i));
                    }
                    ++this.x;
                }
                this.metadataQueryTime = 0L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block15: {
            try {
                if (this.State == 1) {
                    this.executeBatch();
                }
                if (!this.isReadOnly) {
                    this.commit();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.stmt == null) break block15;
                if (this.driver.equals("PostgreSQL")) {
                    try {
                        this.stmt.cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException e) {
                e.printStackTrace();
                SQLException ex = e.getNextException();
                if (ex == null) break block15;
                ex.printStackTrace();
            }
        }
        ConcurrentHashMap<String, Recordset> concurrentHashMap = queries;
        synchronized (concurrentHashMap) {
            queries.remove(this.queryID);
        }
        try {
            this.connection.getConnection().setAutoCommit(this.autoCommit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.State = 0;
        this.rs = null;
        this.stmt = null;
        this.driver = null;
        this.sqlString = null;
        this.keys.clear();
        this.record = null;
        this.endTime = System.currentTimeMillis();
        this.ellapsedTime = this.endTime - this.startTime;
    }

    public Database getDatabase() {
        return this.connection.getDatabase();
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRecords(int maxRecords) {
        if (maxRecords > 0) {
            this.maxRecords = maxRecords;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() {
        try {
            this.connection.getConnection().commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNew() {
        if (this.State == 1) {
            this.InsertOnUpdate = true;
            this.record.update(null);
        }
    }

    public void update() throws SQLException {
        PreparedStatement stmt;
        if (this.isReadOnly) {
            throw new SQLException("Read only!");
        }
        if (this.State != 1) {
            throw new SQLException("Recordset is closed!");
        }
        if (!this.isDirty()) {
            return;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.record.fields) {
            if (field.getName() == null || !field.RequiresUpdate) continue;
            fields.add(field);
        }
        int numUpdates = fields.size();
        Field f = this.record.getField(0);
        String tableName = f.getTable();
        String schemaName = f.getSchema();
        if (tableName == null) {
            this.updateFields();
            tableName = f.getTable();
            schemaName = f.getSchema();
        } else if (schemaName == null) {
            this.updateFields();
            schemaName = f.getSchema();
        }
        tableName = this.escape(tableName);
        schemaName = this.escape(schemaName);
        if (schemaName != null) {
            tableName = schemaName + "." + tableName;
        }
        StringBuilder sql = new StringBuilder();
        if (this.InsertOnUpdate) {
            int i;
            sql.append("INSERT INTO " + tableName + " (");
            for (i = 0; i < numUpdates; ++i) {
                String colName = this.escape(((Field)fields.get(i)).getName());
                sql.append(colName);
                if (numUpdates <= 1 || i >= numUpdates - 1) continue;
                sql.append(",");
            }
            sql.append(") VALUES (");
            for (i = 0; i < numUpdates; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append(this.getQ((Field)fields.get(i)));
            }
            sql.append(")");
        } else {
            ResultSet r2;
            sql.append("UPDATE " + tableName + " SET ");
            for (int i = 0; i < numUpdates; ++i) {
                String colName = this.escape(((Field)fields.get(i)).getName());
                sql.append(colName);
                sql.append("=");
                sql.append(this.getQ((Field)fields.get(i)));
                if (numUpdates <= 1 || i >= numUpdates - 1) continue;
                sql.append(", ");
            }
            if (this.keys.isEmpty()) {
                try {
                    Table table;
                    Key[] arr;
                    java.sql.Connection conn = this.connection.getConnection();
                    DatabaseMetaData dbmd = conn.getMetaData();
                    r2 = dbmd.getTables(null, null, f.getTable(), new String[]{"TABLE"});
                    if (r2.next() && (arr = (table = new Table(r2, dbmd)).getPrimaryKeys()) != null) {
                        for (int i = 0; i < arr.length; ++i) {
                            Key key = arr[i];
                            Field field = this.getField(key.getColumn());
                            if (field == null) continue;
                            this.keys.add(field);
                        }
                    }
                    r2.close();
                }
                catch (Exception conn) {
                    // empty catch block
                }
            }
            if (!this.keys.isEmpty()) {
                sql.append(" WHERE ");
                for (int i = 0; i < this.keys.size(); ++i) {
                    Field field;
                    Object key = this.keys.get(i);
                    if (key instanceof String) {
                        field = this.getField((String)key);
                        this.keys.set(i, field);
                    } else {
                        field = (Field)key;
                    }
                    fields.add(field);
                    if (i > 0) {
                        sql.append(" AND ");
                    }
                    String colName = this.escape(field.getName());
                    sql.append(colName);
                    sql.append("=?");
                }
            } else {
                int numRecords;
                String where = new Parser(this.sqlString).getWhereString();
                if (where != null) {
                    sql.append(" WHERE ");
                    sql.append(where);
                }
                r2 = this.stmt.executeQuery("SELECT COUNT(*) FROM " + tableName + (where == null ? "" : " WHERE " + where));
                try {
                    numRecords = r2.getInt(1);
                }
                catch (Exception e) {
                    try {
                        r2.first();
                        numRecords = r2.getInt(1);
                    }
                    catch (Exception ex) {
                        numRecords = Integer.MAX_VALUE;
                    }
                }
                r2.close();
                if (numRecords > 1) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("WARNING: Updating " + tableName + " table without a unique key.\r\n");
                    msg.append("Multiple rows may be affected with this update.\r\n");
                    try {
                        int ex = 1 / 0;
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream bas = new ByteArrayOutputStream();
                        PrintStream s = new PrintStream(bas, true);
                        e.printStackTrace(s);
                        s.close();
                        boolean append = false;
                        for (String line : bas.toString().split("\n")) {
                            if (append) {
                                msg.append("\t");
                                msg.append(line.trim());
                                msg.append("\r\n");
                            }
                            if (append || !line.contains(this.getClass().getCanonicalName())) continue;
                            append = true;
                        }
                        System.err.println(msg);
                    }
                }
            }
        }
        java.sql.Connection conn = this.connection.getConnection();
        if (this.batchSize > 1) {
            if (this.batchedStatements == null) {
                this.batchedStatements = new HashMap();
            }
            if ((stmt = this.batchedStatements.get(sql.toString())) == null) {
                stmt = conn.prepareStatement(sql.toString());
                this.batchedStatements.put(sql.toString(), stmt);
                conn.setAutoCommit(false);
            }
        } else {
            try {
                stmt = conn.prepareStatement(sql.toString(), 1);
            }
            catch (Exception e) {
                stmt = conn.prepareStatement(sql.toString());
            }
        }
        Recordset.update(stmt, fields);
        if (this.batchSize == 1) {
            try {
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                StringBuilder err = new StringBuilder();
                err.append("Error executing update:\n");
                err.append(sql.toString());
                err.append("\n");
                for (int i = 0; i < fields.size(); ++i) {
                    if (i > 0) {
                        err.append("\n");
                    }
                    Field field = fields.get(i);
                    err.append("  - " + field.getName() + ": ");
                    String val = field.getValue().toString();
                    if (val != null && val.length() > 100) {
                        val = val.substring(0, 100) + "...";
                    }
                    err.append(val);
                }
                e.setNextException(new SQLException(err.toString()));
                throw e;
            }
            if (this.InsertOnUpdate) {
                try {
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    if (generatedKeys.next()) {
                        this.GeneratedKey = new Value(generatedKeys.getString(1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.InsertOnUpdate = false;
            }
        } else {
            stmt.addBatch();
            ++this.numBatches;
            if (this.numBatches == this.batchSize) {
                this.executeBatch();
            }
        }
    }

    protected static void update(PreparedStatement stmt, ArrayList<Field> fields) throws SQLException {
        try {
            stmt.clearParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int id = 1;
        for (int i = 0; i < fields.size(); ++i) {
            Constable val;
            Value FieldValue;
            Field field = fields.get(i);
            String FieldType = field.Class.toLowerCase();
            if (FieldType.contains(".")) {
                FieldType = FieldType.substring(FieldType.lastIndexOf(".") + 1);
            }
            if ((FieldValue = field.getValue()).toObject() instanceof Function) {
                Function function = (Function)FieldValue.toObject();
                if (!function.hasValues()) continue;
                for (Object obj : function.getValues()) {
                    stmt.setObject(id, obj);
                    ++id;
                }
                continue;
            }
            if (FieldType.indexOf("string") >= 0) {
                stmt.setString(id, FieldValue.toString());
            } else if (FieldType.indexOf("int") >= 0) {
                val = FieldValue.toInteger();
                if (val == null) {
                    stmt.setNull(id, 4);
                } else {
                    stmt.setInt(id, (Integer)val);
                }
            } else if (FieldType.indexOf("short") >= 0) {
                val = FieldValue.toShort();
                if (val == null) {
                    stmt.setNull(id, 5);
                } else {
                    stmt.setShort(id, (Short)val);
                }
            } else if (FieldType.indexOf("long") >= 0) {
                val = FieldValue.toLong();
                if (val == null) {
                    stmt.setNull(id, -5);
                } else {
                    stmt.setLong(id, (Long)val);
                }
            } else if (FieldType.indexOf("double") >= 0) {
                val = FieldValue.toDouble();
                if (val == null) {
                    stmt.setNull(id, 8);
                } else {
                    stmt.setDouble(id, (Double)val);
                }
            } else if (FieldType.indexOf("float") >= 0) {
                val = FieldValue.toFloat();
                if (val == null) {
                    stmt.setNull(id, 6);
                } else {
                    stmt.setFloat(id, ((Float)val).floatValue());
                }
            } else if (FieldType.indexOf("bool") >= 0) {
                val = FieldValue.toBoolean();
                if (val == null) {
                    stmt.setNull(id, -7);
                } else {
                    stmt.setBoolean(id, (Boolean)val);
                }
            } else if (FieldType.indexOf("decimal") >= 0) {
                stmt.setBigDecimal(id, FieldValue.toBigDecimal());
            } else if (FieldType.indexOf("timestamp") >= 0) {
                stmt.setTimestamp(id, FieldValue.toTimeStamp());
            } else if (FieldType.indexOf("date") >= 0) {
                stmt.setDate(id, new Date(FieldValue.toDate().getTime()));
            } else if (FieldType.indexOf("object") >= 0) {
                stmt.setObject(id, FieldValue.toObject());
            } else if (FieldType.indexOf("map") >= 0) {
                stmt.setObject(id, (Object)FieldValue.toString(), 1111);
            } else {
                stmt.setObject(id, FieldValue.toObject());
            }
            ++id;
        }
    }

    private String escape(String colName) {
        if (colName == null) {
            return null;
        }
        String[] keywords = Database.getReservedKeywords(this.connection);
        if ((colName = colName.trim()).contains(" ") && !colName.startsWith("[")) {
            colName = "[" + colName + "]";
        }
        for (String keyWord : keywords) {
            if (!colName.equalsIgnoreCase(keyWord)) continue;
            colName = "\"" + colName + "\"";
            break;
        }
        return colName;
    }

    private String getQ(Field field) {
        String packageName;
        if (field == null || field.getValue().isNull()) {
            return "?";
        }
        Object value = field.getValue().toObject();
        if (value instanceof Function) {
            Function function = (Function)value;
            return function.getFunction();
        }
        Package _package = value.getClass().getPackage();
        String string = packageName = _package == null ? "" : _package.getName();
        if (packageName.startsWith("javaxt.geospatial.geometry")) {
            String STGeomFromText = Recordset.getSTGeomFromText(field, this.connection);
            field.Value = new Value(value.toString());
            field.Class = "java.lang.String";
            return STGeomFromText + "(?,4326)";
        }
        if (packageName.startsWith("com.vividsolutions.jts.geom") || packageName.startsWith("org.locationtech.jts.geom")) {
            String STGeomFromText = Recordset.getSTGeomFromText(field, this.connection);
            field.Value = new Value(value.toString());
            field.Class = "java.lang.String";
            int srid = 4326;
            try {
                Object obj;
                Method method = value.getClass().getMethod("getSRID", new Class[0]);
                if (method != null && (obj = method.invoke(value, null)) != null && (srid = ((Integer)obj).intValue()) == 0) {
                    srid = 4326;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return STGeomFromText + "(?," + srid + ")";
        }
        return "?";
    }

    protected static String getSTGeomFromText(Field field, Connection conn) {
        Driver driver = conn.getDatabase().getDriver();
        if (driver.equals("SQLServer")) {
            String geo = field.Class.toLowerCase();
            if (!geo.equals("geometry") && !geo.equals("geography")) {
                geo = null;
                try {
                    Recordset rs = new Recordset();
                    rs.open("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='" + field.getTable() + "' AND COLUMN_NAME='" + field.getName() + "'", conn);
                    geo = rs.getValue(0).toString();
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                geo = geo == null ? "geometry" : geo.toLowerCase();
            }
            return geo + "::STGeomFromText";
        }
        if (driver.equals("DB2")) {
            return "db2GSE.ST_GeomFromText";
        }
        return "ST_GeomFromText";
    }

    public void setBatchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setUpdateKeys(Object ... keys) {
        for (Object key : keys) {
            if (key instanceof String) {
                if (this.isOpen()) {
                    this.keys.add(this.getField((String)key));
                    continue;
                }
                this.keys.add(key);
                continue;
            }
            if (key instanceof Field) {
                this.keys.add(key);
                continue;
            }
            throw new IllegalArgumentException("Unsupported key type: " + key.getClass());
        }
    }

    public void setUpdateKey(Object key) {
        this.setUpdateKeys(key);
    }

    private int executeBatch() throws SQLException {
        if (this.batchedStatements == null) {
            return 0;
        }
        int ttl = 0;
        Iterator<String> it = this.batchedStatements.keySet().iterator();
        while (it.hasNext()) {
            java.sql.Connection Conn;
            PreparedStatement stmt = this.batchedStatements.get(it.next());
            int[] rowsUpdated = stmt.executeBatch();
            if (rowsUpdated.length > 0) {
                ttl += rowsUpdated.length;
            }
            if ((Conn = this.connection.getConnection()).getAutoCommit()) continue;
            Conn.commit();
        }
        this.batchedStatements.clear();
        this.numBatches = 0;
        return ttl;
    }

    public Value getGeneratedKey() {
        return this.GeneratedKey;
    }

    public Record getRecord() {
        return this.record;
    }

    public Field[] getFields() {
        if (this.record == null) {
            return new Field[0];
        }
        return this.record.getFields();
    }

    public Field getField(String FieldName) {
        if (this.record == null) {
            return null;
        }
        return this.record.getField(FieldName);
    }

    public Field getField(int i) {
        if (this.record == null) {
            return null;
        }
        return this.record.getField(i);
    }

    public Value getValue(String FieldName) {
        if (this.record == null) {
            return new Value(null);
        }
        return this.record.get(FieldName);
    }

    public Value getValue(int i) {
        if (this.record == null) {
            return new Value(null);
        }
        return this.record.get(i);
    }

    public boolean isDirty() {
        if (this.record == null) {
            return false;
        }
        return this.record.isDirty();
    }

    public void setValue(String FieldName, Value FieldValue) {
        if (this.record == null) {
            return;
        }
        if (this.State == 1) {
            this.record.set(FieldName, FieldValue);
        }
    }

    public void setValue(String FieldName, Object FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, boolean FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, long FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, int FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, double FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public void setValue(String FieldName, short FieldValue) {
        this.setValue(FieldName, new Value(FieldValue));
    }

    public boolean hasNext() {
        return !this.EOF;
    }

    public boolean next() {
        ++this.n;
        if (this.x == 0 && this.n == 1) {
            return true;
        }
        return this.moveNext();
    }

    public boolean moveNext() {
        if (this.EOF) {
            return false;
        }
        if (this.maxRecords != null && this.x >= this.maxRecords - 1) {
            this.EOF = true;
            return false;
        }
        try {
            if (this.rs.next()) {
                this.record.update(this.rs);
                ++this.x;
                return true;
            }
            this.EOF = true;
            return false;
        }
        catch (Exception e) {
            this.EOF = true;
            return false;
        }
    }

    public void move(int numRecords) {
        block6: {
            boolean tryAgain = false;
            try {
                this.rs.absolute(numRecords);
                this.x += numRecords;
            }
            catch (Exception e) {
                tryAgain = true;
            }
            try {
                if (!tryAgain) break block6;
                int rowPosition = this.rs.getRow();
                while (this.rs.getRow() < numRecords + rowPosition) {
                    if (this.rs.next()) {
                        ++this.x;
                        continue;
                    }
                    this.EOF = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.record.update(this.rs);
    }

    /*
     * WARNING - void declaration
     */
    private void updateFields() throws SQLException {
        void var6_21;
        void var5_10;
        if (this.record == null) {
            return;
        }
        boolean updateFields = false;
        for (Field field : this.record.fields) {
            String string = field.getName();
            if (string == null) continue;
            if (field.getTable() == null) {
                updateFields = true;
                break;
            }
            if (field.getSchema() != null) continue;
            updateFields = true;
            break;
        }
        if (!updateFields) {
            return;
        }
        ArrayList selectedTables = new ArrayList();
        String[] stringArray = new Parser(this.sqlString).getTables();
        int n = stringArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            Table[] schemaName;
            String tableName;
            String string = stringArray[var5_10];
            int idx = string.indexOf(".");
            if (idx > -1) {
                tableName = string.substring(idx + 1);
                schemaName = string.substring(0, idx);
            } else {
                tableName = string;
                schemaName = null;
            }
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("selectedTable", string);
            props.put("tableName", tableName);
            props.put("schemaName", schemaName);
            selectedTables.add(props);
            ++var5_10;
        }
        if (selectedTables.size() == 1) {
            HashMap props = (HashMap)selectedTables.get(0);
            String tableName = (String)props.get("tableName");
            String string = (String)props.get("schemaName");
            if (tableName != null && string != null) {
                for (Field field : this.record.fields) {
                    if (field.getTable() == null) {
                        field.setTableName(tableName);
                    }
                    if (field.getSchema() != null) continue;
                    field.setSchemaName(string);
                }
                return;
            }
        }
        if (this.Tables == null) {
            Database database = this.connection.getDatabase();
            this.Tables = database == null ? Database.getTables(this.connection) : database.getTables();
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        block3: for (HashMap hashMap : selectedTables) {
            String string = (String)hashMap.get("tableName");
            String schemaName = (String)hashMap.get("schemaName");
            for (Table table : this.Tables) {
                if (!string.equalsIgnoreCase(table.getName())) continue;
                if (schemaName == null) {
                    tables.add(table);
                    continue;
                }
                if (!schemaName.equalsIgnoreCase(table.getSchema())) continue;
                tables.add(table);
                continue block3;
            }
        }
        Field[] fieldArray = this.record.fields;
        int n2 = fieldArray.length;
        boolean bl2 = false;
        while (var6_21 < n2) {
            Field field = fieldArray[var6_21];
            ArrayList<Column> columns = null;
            if (field.getTable() == null && (columns = this.getColumns(field, tables)) != null && columns.size() == 1) {
                Column column = columns.get(0);
                field.setTableName(column.getTable().getName());
                field.setSchemaName(column.getTable().getSchema());
            }
            if (field.getSchema() == null) {
                ArrayList<Table> matches = new ArrayList<Table>();
                for (Table table : tables) {
                    if (!table.getName().equalsIgnoreCase(field.getTable())) continue;
                    matches.add(table);
                }
                if (matches.size() == 1) {
                    Table table = (Table)matches.get(0);
                    field.setSchemaName(table.getSchema());
                } else {
                    if (columns == null) {
                        columns = this.getColumns(field, tables);
                    }
                    if (columns != null && columns.size() == 1) {
                        Column column = columns.get(0);
                        field.setSchemaName(column.getTable().getSchema());
                    }
                }
            }
            ++var6_21;
        }
    }

    private ArrayList<Column> getColumns(Field field, ArrayList<Table> tables) {
        ArrayList<Column> matches = new ArrayList<Column>();
        for (Table table : tables) {
            for (Column column : table.getColumns()) {
                if (!column.getName().equalsIgnoreCase(field.getName())) continue;
                matches.add(column);
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches;
        }
        if (matches.size() > 1) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Column column : matches) {
                if (!column.getType().equalsIgnoreCase(field.Type)) continue;
                columns.add(column);
            }
            if (columns.isEmpty()) {
                return null;
            }
            return columns;
        }
        return null;
    }

    public long getRecordCount() {
        try {
            int currRow = this.rs.getRow();
            this.rs.last();
            int size = this.rs.getRow();
            this.rs.absolute(currRow);
            return size;
        }
        catch (Exception e) {
            Long numRecords = null;
            String sql = new Parser(this.sqlString).setSelect("count(*)");
            Recordset rs = new Recordset();
            try {
                rs.open(sql, this.connection);
                numRecords = rs.getValue(0).toLong();
                rs.close();
            }
            catch (SQLException ex) {
                rs.close();
            }
            if (numRecords != null) {
                return numRecords;
            }
            return -1L;
        }
    }
}

