/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadPool {
    private int numThreads;
    private Integer maxPoolSize;
    private ArrayList<Thread> threads;
    private List pool;
    private ConcurrentHashMap<Long, HashMap<String, Object>> params;

    public ThreadPool(int numThreads, Integer maxPoolSize) {
        this.numThreads = numThreads;
        this.threads = new ArrayList();
        this.pool = new LinkedList();
        if (maxPoolSize != null && maxPoolSize < 1) {
            maxPoolSize = null;
        }
        this.maxPoolSize = maxPoolSize;
        this.params = new ConcurrentHashMap();
    }

    public ThreadPool(int numThreads) {
        this(numThreads, null);
    }

    public ThreadPool start() {
        for (int i = 0; i < this.numThreads; ++i) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Object obj = null;
                        List list = ThreadPool.this.pool;
                        synchronized (list) {
                            while (ThreadPool.this.pool.isEmpty()) {
                                try {
                                    ThreadPool.this.pool.wait();
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                            }
                            obj = ThreadPool.this.pool.remove(0);
                            ThreadPool.this.pool.notifyAll();
                        }
                        if (obj instanceof Return) {
                            ThreadPool.this.add(obj);
                            ThreadPool.this.exit();
                            return;
                        }
                        ThreadPool.this.process(obj);
                    }
                }
            };
            t.start();
            this.threads.add(t);
        }
        return this;
    }

    public void process(Object obj) {
    }

    public void exit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        long id = Thread.currentThread().getId();
        Object val = null;
        ConcurrentHashMap<Long, HashMap<String, Object>> concurrentHashMap = this.params;
        synchronized (concurrentHashMap) {
            HashMap<String, Object> map = this.params.get(id);
            if (map != null) {
                val = map.get(key);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object value) {
        long id = Thread.currentThread().getId();
        ConcurrentHashMap<Long, HashMap<String, Object>> concurrentHashMap = this.params;
        synchronized (concurrentHashMap) {
            HashMap<String, Object> map = this.params.get(id);
            if (map == null) {
                map = new HashMap();
                this.params.put(id, map);
            }
            map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Object object) {
        int idx;
        List list = this.pool;
        synchronized (list) {
            if (this.maxPoolSize != null) {
                while (this.pool.size() > this.maxPoolSize) {
                    try {
                        this.pool.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            idx = this.pool.size();
            this.pool.add(object);
            this.pool.notify();
        }
        return idx;
    }

    public List getQueue() {
        return this.pool;
    }

    public void done() {
        this.add(new Return());
    }

    public void join() throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    private class Return {
        private Return() {
        }
    }
}

