/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class URL {
    private HashMap<String, List<String>> parameters;
    private HashMap<String, List<String>> extendedParameters;
    private String protocol;
    private String host;
    private Integer port;
    private String path;

    public URL(java.net.URL url) {
        this(url.toString());
    }

    public URL(String url) {
        url = url.trim();
        this.parameters = new HashMap();
        this.extendedParameters = new HashMap();
        if (url.contains("://")) {
            this.protocol = url.substring(0, url.indexOf("://"));
            url = url.substring(url.indexOf("://") + 3);
        } else if (url.startsWith("jdbc")) {
            this.protocol = url.substring(0, url.indexOf(";"));
            url = url.substring(url.indexOf(";") + 1);
        }
        if (url.contains("?")) {
            String query = url.substring(url.indexOf("?") + 1);
            url = url.substring(0, url.indexOf("?"));
            this.parameters = URL.parseQueryString(query);
        } else {
            int idx = url.indexOf(";");
            if (idx > -1) {
                this.extendedParameters = URL.parseJDBCParams(url.substring(idx + 1));
                url = url.substring(0, idx);
            }
        }
        if (url.contains("/")) {
            this.path = url.substring(url.indexOf("/"));
            url = url.substring(0, url.indexOf("/"));
        }
        if (url.contains(":")) {
            try {
                this.port = Integer.valueOf(url.substring(url.indexOf(":") + 1));
                url = url.substring(0, url.indexOf(":"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.host = url;
    }

    public boolean exists() {
        try {
            URLConnection conn = new java.net.URL(this.toString()).openConnection();
            conn.setConnectTimeout(5000);
            conn.getInputStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static HashMap<String, List<String>> parseQueryString(String query) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (query == null) {
            return parameters;
        }
        if ((query = query.trim()).length() == 0) {
            return parameters;
        }
        if (query.startsWith("&")) {
            query = query.substring(1);
        }
        query = query + "&";
        StringBuffer word = new StringBuffer();
        for (int i = 0; i < query.length(); ++i) {
            String c = query.substring(i, i + 1);
            if (c.equals("&")) {
                if (i + 5 < query.length() && query.substring(i, i + 5).equals("&amp;")) {
                    word.append(c);
                    continue;
                }
                int x = word.indexOf("=");
                if (x >= 0) {
                    String key = word.substring(0, x);
                    String value = URL.decode(word.substring(x + 1));
                    List<String> values = URL.getParameter(key, parameters);
                    if (values == null) {
                        values = new LinkedList<String>();
                    }
                    values.add(value);
                    URL.setParameter(key, values, parameters);
                } else {
                    URL.setParameter(word.toString(), null, parameters);
                }
                word = new StringBuffer();
                continue;
            }
            word.append(c);
        }
        return parameters;
    }

    public static HashMap<String, List<String>> parseJDBCParams(String params) {
        String[] pairs;
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (String pair : pairs = params.split(";")) {
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URL.decode(pair.substring(0, idx)) : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URL.decode(pair.substring(idx + 1)) : null;
            if (!parameters.containsKey(key)) {
                parameters.put(key, new LinkedList());
            }
            parameters.get(key).add(value);
        }
        return parameters;
    }

    private static String decode(String str) {
        try {
            if (str.contains("+")) {
                StringBuilder out = new StringBuilder();
                while (str.contains("+")) {
                    int idx = str.indexOf("+");
                    if (idx == 0) {
                        out.append("+");
                        str = str.substring(1);
                        continue;
                    }
                    out.append(URLDecoder.decode(str.substring(0, idx), "UTF-8"));
                    str = str.substring(idx);
                }
                out.append(URLDecoder.decode(str, "UTF-8"));
                return out.toString();
            }
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    private static String encode(String str) {
        try {
            if (str.contains(" ")) {
                StringBuilder out = new StringBuilder();
                while (str.contains(" ")) {
                    int idx = str.indexOf(" ");
                    if (idx == 0) {
                        out.append("%20");
                        str = str.substring(1);
                        continue;
                    }
                    out.append(URLEncoder.encode(str.substring(0, idx), "UTF-8"));
                    str = str.substring(idx);
                }
                out.append(URLEncoder.encode(str, "UTF-8"));
                return out.toString();
            }
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public void setParameter(String key, String value, boolean append) {
        if (value != null) {
            value = URL.decode(value);
        }
        key = key.toLowerCase();
        if (append) {
            List<String> values = URL.getParameter(key, this.parameters);
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                if (!it.next().equalsIgnoreCase(value)) continue;
                append = false;
                break;
            }
            if (append) {
                values.add(value);
                URL.setParameter(key, values, this.parameters);
            }
        } else if (value != null) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            URL.setParameter(key, values, this.parameters);
        }
    }

    public void setParameter(String key, String value) {
        this.setParameter(key, value, false);
    }

    public String getParameter(String key) {
        StringBuilder str = new StringBuilder();
        List<String> values = URL.getParameter(key, this.parameters);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public String getParameter(String[] keys) {
        StringBuilder str = new StringBuilder();
        for (String key : keys) {
            List<String> values = URL.getParameter(key.toLowerCase(), this.parameters);
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i) + ",");
            }
        }
        String value = str.toString();
        if (value.endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public HashMap<String, List<String>> getParameters() {
        return this.parameters;
    }

    public HashMap<String, List<String>> getExtendedParameters() {
        return this.extendedParameters;
    }

    public String removeParameter(String key) {
        StringBuilder str = new StringBuilder();
        List<String> values = URL.removeParameter(key, this.parameters);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public static List<String> getParameter(String key, HashMap<String, List<String>> parameters) {
        List<String> values = parameters.get(key);
        if (values == null) {
            for (String s : parameters.keySet()) {
                if (!s.equalsIgnoreCase(key)) continue;
                return parameters.get(s);
            }
        }
        return values;
    }

    public static void setParameter(String key, List<String> values, HashMap<String, List<String>> parameters) {
        for (String s : parameters.keySet()) {
            if (!s.equalsIgnoreCase(key)) continue;
            parameters.put(key, values);
            return;
        }
        parameters.put(key, values);
    }

    public static List<String> removeParameter(String key, HashMap<String, List<String>> parameters) {
        List<String> values = parameters.remove(key);
        if (values == null) {
            for (String s : parameters.keySet()) {
                if (!s.equalsIgnoreCase(key)) continue;
                return parameters.remove(s);
            }
        }
        return values;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host.contains(":")) {
            this.port = Integer.valueOf(host.substring(host.indexOf(":") + 1));
            host = host.substring(0, host.indexOf(":"));
        }
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        StringBuilder str = new StringBuilder();
        HashSet<String> keys = this.getKeys();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            List<String> values = URL.getParameter(key, this.parameters);
            if (values == null || values.isEmpty()) {
                str.append(URL.encode(key));
            } else {
                int x = 0;
                for (String value : values) {
                    if (x > 0) {
                        str.append("&");
                    }
                    str.append(URL.encode(key));
                    if (value != null && value.trim().length() > 0) {
                        str.append("=");
                        boolean isEncoded = !URL.decode(value).equals(value);
                        str.append(isEncoded ? value : URL.encode(value));
                    }
                    ++x;
                }
            }
            if (!it.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void setQueryString(String query) {
        if (query == null) {
            this.parameters = new HashMap();
        } else {
            if ((query = query.trim()).startsWith("?")) {
                query = query.substring(1).trim();
            }
            if (query.length() > 0) {
                this.parameters = URL.parseQueryString(query);
            }
        }
    }

    public HashSet<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null) {
            path = "";
        } else {
            if ((path = path.trim()).contains("?")) {
                String query = path.substring(path.indexOf("?") + 1);
                path = path.substring(0, path.indexOf("?"));
                this.parameters = URL.parseQueryString(query);
            }
            if (path.contains(";")) {
                path = path.substring(0, path.indexOf(";"));
            }
            if (!path.startsWith("/")) {
                if (path.startsWith("./") || path.startsWith("../")) {
                    String RelPath = path;
                    if (RelPath.length() > 2 && RelPath.substring(0, 2).equals("./")) {
                        RelPath = RelPath.substring(2, RelPath.length());
                    }
                    String urlPath = "";
                    String newPath = "";
                    if (RelPath.substring(0, 1).equals("/")) {
                        newPath = RelPath;
                    } else {
                        urlPath = "/";
                        String dir = "";
                        String orgPath = this.getPath();
                        if (orgPath == null) {
                            orgPath = "";
                        }
                        if (orgPath.length() > 1 && !orgPath.endsWith("/")) {
                            orgPath = orgPath.substring(0, orgPath.lastIndexOf("/"));
                        }
                        String[] arr = orgPath.split("/");
                        String[] arrRelPath = RelPath.split("/");
                        for (int i = 0; i <= arr.length - arrRelPath.length; ++i) {
                            dir = arr[i];
                            if (dir.length() <= 0) continue;
                            urlPath = urlPath + dir + "/";
                        }
                        newPath = RelPath.substring(0, 1).equals("/") ? RelPath.substring(1, RelPath.length()) : (RelPath.substring(0, 2).equals("./") ? RelPath.substring(2, RelPath.length()) : (RelPath.substring(0, 3).equals("../") ? RelPath.replace("../", "") : RelPath));
                    }
                    path = urlPath + newPath;
                } else {
                    path = "/" + path;
                }
            }
        }
        this.path = path;
    }

    public String toString() {
        String query;
        String host = this.host;
        if (this.port != null && this.port > 0) {
            host = host + ":" + this.port;
        }
        String path = "";
        if (this.getPath() != null) {
            path = this.getPath();
        }
        if ((query = this.getQueryString()).length() > 0) {
            query = "?" + query;
        }
        return this.protocol + "://" + host + path + query;
    }

    public java.net.URL toURL() {
        java.net.URL url = null;
        try {
            Integer port = this.port;
            if (port == null) {
                if (this.protocol.equalsIgnoreCase("http")) {
                    port = 80;
                } else if (this.protocol.equalsIgnoreCase("https")) {
                    port = 443;
                } else if (this.protocol.equalsIgnoreCase("ftp")) {
                    port = 23;
                } else {
                    try {
                        port = new java.net.URL(this.protocol + "://" + this.host).getPort();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            url = new URI(this.protocol, null, this.host, port, this.path, null, null).toURL();
            String query = this.getQueryString();
            if (query.length() > 0) {
                url = new java.net.URL(url.toString() + "?" + query);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }
}

