/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javaxt.json.JSONObject;
import javaxt.json.JSONValue;
import javaxt.sql.Database;

public class Config {
    private List<JSONObject> config = new LinkedList<JSONObject>();

    public Config() {
        this.config.add(new JSONObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(JSONObject json) {
        List<JSONObject> list = this.config;
        synchronized (list) {
            this.config.set(0, json);
            this.config.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONValue get(String key) {
        List<JSONObject> list = this.config;
        synchronized (list) {
            return this.config.get(0).get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONValue get(String ... path) {
        List<JSONObject> list = this.config;
        synchronized (list) {
            return this.config.get(0).get(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, Object value) {
        List<JSONObject> list = this.config;
        synchronized (list) {
            this.config.get(0).set(key, value);
            this.config.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(String key) {
        List<JSONObject> list = this.config;
        synchronized (list) {
            return this.config.get(0).has(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        List<JSONObject> list = this.config;
        synchronized (list) {
            Iterator it = this.config.get(0).keys();
            while (it.hasNext()) {
                keys.add((String)it.next());
            }
        }
        return keys;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    public Database getDatabase() {
        JSONValue val = this.get("database");
        if (val == null) {
            return null;
        }
        if (val.toObject() instanceof Database) {
            return (Database)val.toObject();
        }
        Database database = this.getDatabase(val);
        if (database != null) {
            this.setDatabase(database);
        }
        return database;
    }

    public Database getDatabase(JSONValue val) {
        return this.getDatabase(val.toJSONObject());
    }

    public Database getDatabase(JSONObject json) {
        if (json == null) {
            return null;
        }
        Database database = new Database();
        database.setDriver(json.get("driver").toString());
        database.setHost(json.get("host").toString());
        database.setName(json.get("name").toString());
        database.setUserName(json.get("username").toString());
        database.setPassword(json.get("password").toString());
        if (json.has("maxConnections")) {
            database.setConnectionPoolSize(json.get("maxConnections").toInteger().intValue());
        }
        this.setDatabase(database);
        return database;
    }

    public void setDatabase(Database database) {
        this.set("database", database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        List<JSONObject> list = this.config;
        synchronized (list) {
            JSONObject currConfig = this.config.get(0);
            Iterator it = currConfig.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONValue val = currConfig.get(key);
                Object obj = val.toObject();
                if (obj instanceof Database) {
                    Database database = (Database)obj;
                    JSONObject db = new JSONObject();
                    String host = database.getHost();
                    Integer port = database.getPort();
                    if (port != null && port > 0) {
                        host = host + ":" + port;
                    }
                    db.set("driver", (Object)database.getDriver().getVendor());
                    db.set("host", (Object)host);
                    db.set("name", (Object)database.getName());
                    db.set("username", (Object)database.getUserName());
                    db.set("password", (Object)database.getPassword());
                    db.set("maxConnections", (Object)database.getConnectionPoolSize());
                    json.set(key, (Object)db);
                    continue;
                }
                json.set(key, obj);
            }
        }
        return json;
    }
}

