/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.security.InvalidKeyException;
import javaxt.encryption.AES256;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.json.JSONObject;
import javaxt.utils.Base64;

public class ConfigFile {
    private File file;

    public ConfigFile(File file) {
        this.file = file;
    }

    public ConfigFile(String path) {
        this(new File(path));
    }

    public boolean exists() {
        return this.file.exists();
    }

    public Directory getDirectory() {
        return this.file.getDirectory();
    }

    public void delete() {
        this.file.delete();
    }

    public JSONObject getConfig(String username, String password) throws InvalidKeyException, Exception {
        return new JSONObject(AES256.decrypt((byte[])this.file.getBytes().toByteArray(), (String)ConfigFile.generatePassword(username, password)));
    }

    public void save(JSONObject config, String username, String password) throws InvalidKeyException, Exception {
        this.file.write(AES256.encrypt((String)config.toString(), (String)ConfigFile.generatePassword(username, password)));
    }

    private static String generatePassword(String username, String password) throws Exception {
        return Base64.encode((byte[])(username + "/" + password).getBytes("UTF-8"));
    }
}

