/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.utils.Console;
import javaxt.utils.Date;
import javaxt.xml.DOM;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Deploy {
    private static Directory input;
    private static Directory output;
    private HashSet<File> minifiedFiles = new HashSet();

    public static void main(String[] arr) {
        HashMap args = Console.parseArgs((String[])arr);
        input = new Directory((String)args.get("-deploy"));
        output = new Directory((String)args.get("-target"));
        System.out.print("\r\n------------------------------------------\r\n Please select from the following options:\r\n------------------------------------------\r\n  1. Deploy Web App\r\n  2. Deploy Web Services\r\n  3. Both\r\n");
        while (true) {
            System.out.print("\r\n> ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                int x = Integer.parseInt(br.readLine());
                if (x < 1 || x > 3) {
                    throw new IllegalArgumentException();
                }
                new Deploy(input, output, x);
            }
            catch (IllegalArgumentException e) {
                System.out.println("  ERROR: Invalid Entry!");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public Deploy(Directory input, Directory output, int options) {
        long buildNumber = new Date().toLong();
        if (options == 1 || options == 3) {
            System.out.println("\r\nDeploying Web App...");
            HashSet<File> filters = new HashSet<File>();
            Directory inputWeb = new Directory(input + "web");
            Directory outputWeb = new Directory(output + "web");
            for (String fileName : new String[]{"index.html", "login.html", "sites.html", "main.html"}) {
                File inputFile = new File(inputWeb + fileName);
                File outputFile = new File(outputWeb + fileName);
                if (!inputFile.exists()) continue;
                HashSet<File> filter = this.updateHtml(inputFile, outputFile);
                Iterator<File> it = filter.iterator();
                while (it.hasNext()) {
                    filters.add(it.next());
                }
            }
            this.copyFiles(inputWeb, outputWeb, filters);
            HashSet<File> filter = this.updateApps(input, output);
            Directory inputAppDir = new Directory(input + "dist/apps");
            Directory outputAppDir = new Directory(output + "apps");
            this.copyApps(inputAppDir, outputAppDir, filter);
            new File(outputWeb, "build.txt").write(buildNumber + "");
        }
        if (options == 2 || options == 3) {
            System.out.println("\r\nDeploying Web Services...");
            this.copyJars(input, output);
            new File(output, "build.txt").write(buildNumber + "");
        }
        System.out.println("\r\nDone!");
    }

    private HashSet<File> updateHtml(File inputFile, File outputFile) {
        File js;
        Directory inputDir = inputFile.getDirectory();
        Directory outputDir = outputFile.getDirectory();
        Document xhtml = inputFile.getXML();
        Node head = DOM.getElementsByTagName((String)"head", (Document)xhtml)[0];
        HashSet<File> filter = new HashSet<File>();
        int x = inputDir.toString().length();
        LinkedHashMap<String, Script> scripts = new LinkedHashMap<String, Script>();
        for (Node node : DOM.getElementsByTagName((String)"script", (Document)xhtml)) {
            String src = DOM.getAttributeValue((NamedNodeMap)node.getAttributes(), (String)"src").trim();
            if (src.length() <= 0) continue;
            js = new File(inputFile.MapPath(src));
            if (js.exists()) {
                String path = js.getPath().substring(x);
                path = path.length() == 0 ? js.getName() : path.substring(0, path.length() - 1) + ".js";
                Script script = (Script)scripts.get(path);
                if (script == null) {
                    script = new Script();
                    scripts.put(path, script);
                }
                StringBuffer str = script.src;
                str.append(js.getText());
                str.append("\r\n");
                java.util.Date lastModified2 = script.lastModified;
                if (lastModified2 == null || js.getLastModifiedTime().after(lastModified2)) {
                    script.lastModified = js.getLastModifiedTime();
                }
                script.minified = js.getName().endsWith(".min.js");
                filter.add(js);
            }
            node.getParentNode().removeChild(node);
        }
        for (String path : scripts.keySet()) {
            Script script = (Script)scripts.get(path);
            String src = script.src.toString();
            java.util.Date lastModified = script.lastModified;
            js = new File(outputDir + path);
            if (!script.minified) {
                System.out.println("Compressing " + path + "...");
                StringReader in = new StringReader(src);
                StringWriter out = new StringWriter();
                try {
                    JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, (ErrorReporter)new YuiCompressorErrorReporter());
                    ((Reader)in).close();
                    compressor.compress((Writer)out, -1, true, false, false, false);
                    src = ((Object)out).toString();
                    ((Writer)out).close();
                    this.minifiedFiles.add(js);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        ((Reader)in).close();
                    }
                    catch (Exception lastModified2) {
                        // empty catch block
                    }
                    try {
                        ((Writer)out).close();
                    }
                    catch (Exception lastModified2) {
                        // empty catch block
                    }
                }
            }
            System.out.println(path + " --> " + js);
            if (!js.exists() || lastModified.after(js.getLastModifiedTime()) || !js.getText().equals(src)) {
                js.write(src);
                js.setLastModifiedTime(lastModified);
            }
            Element node = xhtml.createElement("script");
            NamedNodeMap attr = node.getAttributes();
            Attr att = xhtml.createAttribute("type");
            att.setValue("text/javascript");
            attr.setNamedItem(att);
            att = xhtml.createAttribute("src");
            att.setValue(path.replace("\\", "/"));
            attr.setNamedItem(att);
            head.appendChild(node);
        }
        NodeList nodes = head.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node;
            node = nodes.item(i);
            if (node.getNodeType() != 8) continue;
            node.getParentNode().removeChild(node);
        }
        String text = DOM.getText((Document)xhtml);
        while (text.contains("\r\n\r\n")) {
            text = text.replace("\r\n\r\n", "\r\n");
        }
        while (text.contains("/><")) {
            text = text.replace("/><", "/>\r\n<");
        }
        if (text.startsWith("<?xml")) {
            text = text.substring(text.indexOf(">") + 1);
        }
        StringBuffer html = new StringBuffer();
        for (String str : text.split("<script ")) {
            if (html.length() == 0) {
                html.append(str);
                continue;
            }
            String a = str.substring(0, str.indexOf(">") + 1);
            String b = str.substring(str.indexOf(">") + 1);
            if (a.substring(a.length() - 2).equals("/>")) {
                a = a.substring(0, a.length() - 2) + "></script>";
            }
            str = "<script " + a + b;
            html.append(str);
        }
        text = html.toString();
        outputFile.write(text);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<File> updateApps(Directory input, Directory output) {
        Directory dir = new Directory(input + "dist/apps");
        HashSet<File> filter = new HashSet<File>();
        LinkedHashMap<String, Script> scripts = new LinkedHashMap<String, Script>();
        List files = dir.getChildren(true, (Object)"*.xml", false);
        while (true) {
            File js;
            Node[] includes;
            File file;
            Directory parentDir;
            Object obj;
            List list = files;
            synchronized (list) {
                while (files.isEmpty()) {
                    try {
                        files.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                obj = files.remove(0);
                files.notifyAll();
            }
            if (obj == null) break;
            if (!(obj instanceof File) || !(parentDir = (file = (File)obj).getDirectory()).getName().equalsIgnoreCase("web")) continue;
            Directory appDir = parentDir.getParentDirectory();
            String appName = appDir.getName();
            Directory webDir = parentDir;
            int x = webDir.toString().length();
            System.out.println(appName);
            String relPath = "apps" + Directory.PathSeparator + parentDir.toString().substring(dir.toString().length());
            System.out.println(relPath);
            Directory outputDir = new Directory(output + relPath);
            Document xml = file.getXML();
            Node outerNode = DOM.getOuterNode((Document)xml);
            if (!outerNode.getNodeName().equals("application") || (includes = DOM.getElementsByTagName((String)"includes", (Node)outerNode)).length <= 0) continue;
            Node include = includes[0];
            for (Node node : DOM.getElementsByTagName((String)"script", (Node)include)) {
                String src = DOM.getAttributeValue((Node)node, (String)"src");
                if (src.length() <= 0) continue;
                if (src.toLowerCase().startsWith(appName.toLowerCase() + "/")) {
                    src = src.substring(appName.length() + 1);
                }
                System.out.println(src);
                js = new File(webDir + src);
                if (js.exists()) {
                    String path = js.getPath().substring(x);
                    path = path.length() == 0 ? appName + ".js" : path.substring(0, path.length() - 1) + ".js";
                    System.out.println(js.getName() + " --> " + path);
                    Script script = (Script)scripts.get(path);
                    if (script == null) {
                        script = new Script();
                        scripts.put(path, script);
                    }
                    StringBuffer str = script.src;
                    str.append(js.getText());
                    str.append("\r\n");
                    java.util.Date lastModified = script.lastModified;
                    if (lastModified == null || js.getLastModifiedTime().after(lastModified)) {
                        script.lastModified = js.getLastModifiedTime();
                    }
                    script.minified = js.getName().endsWith(".min.js");
                    filter.add(js);
                }
                node.getParentNode().removeChild(node);
            }
            for (String path : scripts.keySet()) {
                Script script = (Script)scripts.get(path);
                String src = script.src.toString();
                java.util.Date lastModified = script.lastModified;
                js = new File(outputDir + path);
                if (!script.minified) {
                    System.out.println("Compressing " + path + "...");
                    StringReader in = new StringReader(src);
                    StringWriter out = new StringWriter();
                    try {
                        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)in, (ErrorReporter)new YuiCompressorErrorReporter());
                        ((Reader)in).close();
                        compressor.compress((Writer)out, -1, true, false, false, false);
                        src = ((Object)out).toString();
                        ((Writer)out).close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            ((Reader)in).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            ((Writer)out).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                System.out.println(path + " --> " + js);
                if (!js.exists() || lastModified.after(js.getLastModifiedTime()) || !js.getText().equals(src)) {
                    js.write(src);
                    js.setLastModifiedTime(lastModified);
                }
                Element node = xml.createElement("script");
                NamedNodeMap attr = node.getAttributes();
                Attr att = xml.createAttribute("type");
                att.setValue("text/javascript");
                attr.setNamedItem(att);
                att = xml.createAttribute("src");
                att.setValue(appName.toLowerCase() + "/" + path.replace("\\", "/"));
                attr.setNamedItem(att);
                include.appendChild(node);
            }
            File outputFile = new File(outputDir, file.getName());
            System.out.println(outputFile);
            outputFile.write(xml);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles(Directory input, Directory output, HashSet<File> filter) {
        int x = input.toString().length();
        List files = input.getChildren(true, null, false);
        while (true) {
            File copyTo;
            Object obj;
            List list = files;
            synchronized (list) {
                while (files.isEmpty()) {
                    try {
                        files.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                obj = files.remove(0);
                files.notifyAll();
            }
            if (obj == null) break;
            if (!(obj instanceof File)) continue;
            File file = (File)obj;
            String path = file.getPath();
            String ext = file.getExtension().toLowerCase();
            String parentDir = path.substring(0, path.length() - 1);
            parentDir = parentDir.substring(parentDir.lastIndexOf(file.PathSeparator) + 1);
            System.out.println(filter.contains(file) + "\t" + file);
            if (filter.contains(file) || parentDir.equalsIgnoreCase("test") || parentDir.equalsIgnoreCase("src") || parentDir.equalsIgnoreCase(".svn") || ext.equals("org") || ext.equals("svn-base") || (copyTo = new File(output + path.substring(x) + file.getName())).exists() && !file.getLastModifiedTime().after(copyTo.getLastModifiedTime())) continue;
            file.copyTo(copyTo, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyApps(Directory input, Directory output, HashSet<File> filter) {
        int x = input.toString().length();
        block5: for (Directory appDir : input.getSubDirectories()) {
            Directory webDir = new Directory(appDir + "web");
            List files = webDir.getChildren(true, null, false);
            while (true) {
                File copyTo;
                Object obj;
                List list = files;
                synchronized (list) {
                    while (files.isEmpty()) {
                        try {
                            files.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    obj = files.remove(0);
                    files.notifyAll();
                }
                if (obj == null) continue block5;
                if (!(obj instanceof File)) continue;
                File file = (File)obj;
                String path = file.getPath();
                String ext = file.getExtension().toLowerCase();
                String parentDir = path.substring(0, path.length() - 1);
                parentDir = parentDir.substring(parentDir.lastIndexOf(file.PathSeparator) + 1);
                System.out.println(filter.contains(file) + "\t" + file);
                if (filter.contains(file) || parentDir.equalsIgnoreCase("test") || parentDir.equalsIgnoreCase("src") || parentDir.equalsIgnoreCase(".svn") || ext.equals("org") || ext.equals("svn-base") || (copyTo = new File(output + path.substring(x) + file.getName())).exists() && !file.getLastModifiedTime().after(copyTo.getLastModifiedTime())) continue;
                file.copyTo(copyTo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJars(Directory input, Directory output) {
        File copyTo;
        String path;
        System.out.println(input);
        for (File file : input.getFiles((Object)"*.jks")) {
            File[] copyTo2 = new File(output + file.getName());
            if (copyTo2.exists() && !file.getLastModifiedTime().after(copyTo2.getLastModifiedTime())) continue;
            System.out.println(copyTo2);
            file.copyTo((File)copyTo2, true);
        }
        Directory dist = new Directory(input + "dist");
        int x = dist.toString().length();
        HashMap<String, File> libs = new HashMap<String, File>();
        Directory lib = new Directory(dist + "lib");
        for (File file : lib.getFiles((Object)"*.jar")) {
            String fileName = file.getName();
            libs.put(fileName, file);
            path = file.toString();
            copyTo = new File(output + path.substring(x));
            if (copyTo.exists() && !file.getLastModifiedTime().after(copyTo.getLastModifiedTime())) continue;
            System.out.println(copyTo);
            file.copyTo(copyTo, true);
        }
        List files = dist.getChildren(true, null, false);
        while (true) {
            Object obj;
            List list = files;
            synchronized (list) {
                while (files.isEmpty()) {
                    try {
                        files.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                obj = files.remove(0);
                files.notifyAll();
            }
            if (obj == null) break;
            if (!(obj instanceof File)) continue;
            File file = (File)obj;
            String fileName = file.getName();
            String fileExt = file.getExtension().toLowerCase();
            if (!fileExt.equals("jar") || libs.containsKey(fileName)) continue;
            path = file.getPath();
            copyTo = new File(output + path.substring(x) + file.getName());
            if (copyTo.exists() && !file.getLastModifiedTime().after(copyTo.getLastModifiedTime())) continue;
            System.out.println(copyTo);
            file.copyTo(copyTo, true);
        }
    }

    private static class YuiCompressorErrorReporter
    implements ErrorReporter {
        private YuiCompressorErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                YuiCompressorErrorReporter.log(Level.WARNING, message);
            } else {
                YuiCompressorErrorReporter.log(Level.WARNING, line + 58 + lineOffset + 58 + message);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                YuiCompressorErrorReporter.log(Level.SEVERE, message);
            } else {
                YuiCompressorErrorReporter.log(Level.SEVERE, line + 58 + lineOffset + 58 + message);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }

        private static void log(Level l, String msg) {
            System.out.println(l + " " + msg);
        }
    }

    private class Script {
        private java.util.Date lastModified;
        private StringBuffer src = new StringBuffer();
        private boolean minified = false;

        private Script() {
        }
    }
}

