/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.html.Element;
import javaxt.html.Parser;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.io.Directory;
import javaxt.utils.Date;
import javaxt.utils.ThreadPool;
import javaxt.utils.URL;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileManager {
    private Directory web;
    private String[] welcomeFiles = new String[]{"index.html", "index.htm", "default.htm"};
    private static final String z = "GMT";
    private static final TimeZone tz = TimeZone.getTimeZone("GMT");

    public FileManager(Directory web) {
        this.web = web;
    }

    public void sendFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getPathInfo();
        if (path != null) {
            path = path.substring(1);
        }
        this.sendFile(path, request, response);
    }

    public void sendFile(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (path == null) {
            path = "";
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.web + path);
        if (path.length() > 0 && !path.endsWith("/")) {
            path = path + "/";
        }
        for (String welcomeFile : this.welcomeFiles) {
            files.add(this.web + path + welcomeFile);
        }
        for (String str : files) {
            File file;
            if ((str = str.replace("\\", "/")).contains("..") || str.contains("/.") || str.toLowerCase().contains("/keystore") || !(file = new File(str)).exists() || !file.isFile() || file.isHidden()) continue;
            this._sendFile(file, request, response);
            return;
        }
        response.setStatus(404);
    }

    public void sendFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (file.exists() && file.isFile() && !file.isHidden()) {
            this._sendFile(file, request, response);
        } else {
            response.setStatus(404);
        }
    }

    public void sendFile(javaxt.io.File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.sendFile(file.toFile(), request, response);
    }

    private void _sendFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String name = file.getName();
        int idx = name.lastIndexOf(".");
        if (idx > -1) {
            String ext = name.substring(idx + 1).toLowerCase();
            if (ext.equals("js") || ext.equals("css")) {
                URL url = new URL(request.getURL());
                long currVersion = new Date(file.lastModified()).toLong();
                long requestedVersion = 0L;
                try {
                    requestedVersion = Long.parseLong(url.getParameter("v"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (requestedVersion < currVersion) {
                    url.setParameter("v", currVersion + "");
                    response.sendRedirect(url.toString(), true);
                    return;
                }
                if (requestedVersion == currVersion) {
                    response.setHeader("Cache-Control", "public, max-age=31536000, immutable");
                }
            } else {
                javaxt.io.File xmlFile;
                Document xml;
                String outerNode;
                if (ext.equals("htm") || ext.equals("html")) {
                    long lastUpdate;
                    javaxt.io.File htmlFile = new javaxt.io.File(file);
                    String html = htmlFile.getText();
                    Parser parser = new Parser(html);
                    Element head = parser.getElementByTagName("head");
                    String header = head.getOuterHTML();
                    ArrayList<String> headerNodes = new ArrayList<String>();
                    HashMap<Integer, Integer> updates = new HashMap<Integer, Integer>();
                    StringBuilder str = new StringBuilder();
                    str.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
                    str.append("<links>\r\n");
                    for (Element el : head.getChildNodes()) {
                        String tagName = el.getName();
                        if (tagName == null) continue;
                        tagName = tagName.toLowerCase();
                        String url = null;
                        if (tagName.equals("script")) {
                            url = el.getAttribute("src");
                        } else if (tagName.equals("link")) {
                            url = el.getAttribute("href");
                        }
                        if (url != null && !url.isBlank()) {
                            str.append(el.toString());
                            updates.put(updates.size(), headerNodes.size());
                        }
                        headerNodes.add(el.toString());
                    }
                    str.append("</links>");
                    Document xml2 = DOM.createDocument((String)str.toString());
                    try {
                        lastUpdate = this.updateLinks(htmlFile, xml2);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    Node outerNode2 = DOM.getOuterNode((Document)xml2);
                    Node[] nodes = DOM.getNodes((NodeList)outerNode2.getChildNodes());
                    for (int i = 0; i < nodes.length; ++i) {
                        Node node = nodes[i];
                        String nodeName = node.getNodeName().toLowerCase();
                        String txt = DOM.getText((Node)node);
                        if (txt.endsWith("/>") && nodeName.equals("script")) {
                            txt = txt.substring(0, txt.length() - 2);
                            txt = txt + "></" + nodeName + ">";
                        }
                        int x = (Integer)updates.get(i);
                        headerNodes.set(x, txt);
                    }
                    str = new StringBuilder("<head>");
                    for (String s : headerNodes) {
                        str.append("\r\n");
                        str.append(s);
                    }
                    str.append("\r\n</head>");
                    html = html.replace(header, str.toString());
                    response.setContentType("text/html");
                    this.sendResponse(html, lastUpdate, request, response);
                    return;
                }
                if (ext.equals("xml") && ((outerNode = DOM.getOuterNode((Document)(xml = (xmlFile = new javaxt.io.File(file)).getXML())).getNodeName()).equals("application") || outerNode.equals("includes"))) {
                    long lastUpdate;
                    try {
                        lastUpdate = this.updateLinks(xmlFile, xml);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    response.setContentType("application/xml");
                    this.sendResponse(DOM.getText((Document)xml), lastUpdate, request, response);
                    return;
                }
            }
        }
        response.write(file, javaxt.io.File.getContentType((String)file.getName()), true);
    }

    public void sendResponse(String html, long date, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long size = html.length();
        String eTag = "W/\"" + size + "-" + date + "\"";
        response.setHeader("ETag", eTag);
        response.setHeader("Last-Modified", this.getDate(date));
        String matchTag = request.getHeader("if-none-match");
        String cacheControl = request.getHeader("cache-control");
        if (matchTag == null) {
            matchTag = "";
        }
        if (cacheControl == null) {
            cacheControl = "";
        }
        if (!cacheControl.equalsIgnoreCase("no-cache")) {
            if (eTag.equalsIgnoreCase(matchTag)) {
                response.setStatus(304);
                return;
            }
            matchTag = request.getHeader("if-modified-since");
            if (matchTag != null) {
                for (String tag : matchTag.split(";")) {
                    if (!tag.trim().equalsIgnoreCase(response.getHeader("Last-Modified"))) continue;
                    response.setStatus(304);
                    return;
                }
            }
        }
        response.write(html);
    }

    public long updateLinks(javaxt.io.File xmlFile, Document xml) throws Exception {
        ArrayList<Node> includes = new ArrayList<Node>();
        for (Node node : DOM.getElementsByTagName((String)"script", (Document)xml)) {
            includes.add(node);
        }
        for (Node node : DOM.getElementsByTagName((String)"link", (Document)xml)) {
            includes.add(node);
        }
        return this.updateLinks(xmlFile, includes);
    }

    public long updateLinks(final javaxt.io.File xmlFile, ArrayList<Node> nodes) throws Exception {
        final ConcurrentHashMap<Long, Boolean> uniqueDates = new ConcurrentHashMap<Long, Boolean>();
        if (xmlFile.exists()) {
            uniqueDates.put(xmlFile.getDate().getTime(), true);
        }
        ThreadPool pool = new ThreadPool(4){

            public void process(Object obj) {
                Node node = (Node)obj;
                String nodeName = node.getNodeName().toLowerCase();
                if (nodeName.equals("script")) {
                    String src = DOM.getAttributeValue((Node)node, (String)"src");
                    if (src.length() > 0) {
                        try {
                            javaxt.io.File jsFile = new javaxt.io.File(xmlFile.MapPath(src));
                            if (jsFile.exists()) {
                                long lastModified = jsFile.getLastModifiedTime().getTime();
                                long currVersion = new Date(lastModified).toLong();
                                DOM.setAttributeValue((Node)node, (String)"src", (String)(src + "?v=" + currVersion));
                                this.addDate(lastModified);
                            }
                        }
                        catch (Exception jsFile) {}
                    }
                } else if (nodeName.equals("link")) {
                    String href = DOM.getAttributeValue((Node)node, (String)"href");
                    String type = DOM.getAttributeValue((Node)node, (String)"type");
                    String rel = DOM.getAttributeValue((Node)node, (String)"rel");
                    boolean isStyleSheet = type.equalsIgnoreCase("text/css");
                    if (!isStyleSheet) {
                        isStyleSheet = rel.equalsIgnoreCase("stylesheet");
                    }
                    if (href.length() > 0 && isStyleSheet) {
                        try {
                            javaxt.io.File cssFile = new javaxt.io.File(xmlFile.MapPath(href));
                            if (cssFile.exists()) {
                                long lastModified = cssFile.getLastModifiedTime().getTime();
                                long currVersion = new Date(lastModified).toLong();
                                DOM.setAttributeValue((Node)node, (String)"href", (String)(href + "?v=" + currVersion));
                                this.addDate(lastModified);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }

            private void addDate(long lastModified) throws Exception {
                HashSet<Long> dates = (HashSet<Long>)this.get("dates");
                if (dates == null) {
                    dates = new HashSet<Long>();
                    this.set("dates", dates);
                }
                dates.add(lastModified);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exit() {
                HashSet dates = (HashSet)this.get("dates");
                if (dates == null || dates.isEmpty()) {
                    return;
                }
                ConcurrentHashMap concurrentHashMap = uniqueDates;
                synchronized (concurrentHashMap) {
                    Iterator it = dates.iterator();
                    while (it.hasNext()) {
                        uniqueDates.put((Long)it.next(), true);
                    }
                    uniqueDates.notify();
                }
            }
        }.start();
        for (Node node : nodes) {
            pool.add((Object)node);
        }
        pool.done();
        pool.join();
        TreeSet dates = new TreeSet();
        dates.addAll(uniqueDates.keySet());
        return (Long)dates.last();
    }

    public void updateNodes(NodeList nodes, Document xml) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (DOM.hasChildren((Node)node)) {
                this.updateNodes(node.getChildNodes(), xml);
                continue;
            }
            this.updateNode(node, xml);
        }
    }

    public void updateNode(Node node, Document xml) {
        try {
            node.appendChild(xml.createComment(" "));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getDate(Calendar cal) {
        if (!cal.getTimeZone().equals(tz)) {
            cal = (Calendar)cal.clone();
            cal.setTimeZone(tz);
        }
        StringBuffer str = new StringBuffer(29);
        switch (cal.get(7)) {
            case 2: {
                str.append("Mon, ");
                break;
            }
            case 3: {
                str.append("Tue, ");
                break;
            }
            case 4: {
                str.append("Wed, ");
                break;
            }
            case 5: {
                str.append("Thu, ");
                break;
            }
            case 6: {
                str.append("Fri, ");
                break;
            }
            case 7: {
                str.append("Sat, ");
                break;
            }
            case 1: {
                str.append("Sun, ");
            }
        }
        int i = cal.get(5);
        str.append(i < 10 ? "0" + i : Integer.valueOf(i));
        switch (cal.get(2)) {
            case 0: {
                str.append(" Jan ");
                break;
            }
            case 1: {
                str.append(" Feb ");
                break;
            }
            case 2: {
                str.append(" Mar ");
                break;
            }
            case 3: {
                str.append(" Apr ");
                break;
            }
            case 4: {
                str.append(" May ");
                break;
            }
            case 5: {
                str.append(" Jun ");
                break;
            }
            case 6: {
                str.append(" Jul ");
                break;
            }
            case 7: {
                str.append(" Aug ");
                break;
            }
            case 8: {
                str.append(" Sep ");
                break;
            }
            case 9: {
                str.append(" Oct ");
                break;
            }
            case 10: {
                str.append(" Nov ");
                break;
            }
            case 11: {
                str.append(" Dec ");
            }
        }
        str.append(cal.get(1));
        str.append(" ");
        i = cal.get(11);
        str.append(i < 10 ? "0" + i + ":" : i + ":");
        i = cal.get(12);
        str.append(i < 10 ? "0" + i + ":" : i + ":");
        i = cal.get(13);
        str.append(i < 10 ? "0" + i + " " : i + " ");
        str.append(z);
        return str.toString();
    }

    private String getDate(long milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliseconds);
        return FileManager.getDate(cal);
    }
}

