/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class KeyManager
extends X509ExtendedKeyManager {
    private KeyStore keyStore;
    private char[] password;
    private String alias;
    private HashMap<InetAddress, String> aliases;

    public KeyManager(KeyStore keystore, char[] password, String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias is null.");
        }
        this.keyStore = keystore;
        this.password = password;
        this.alias = alias;
    }

    public KeyManager(KeyStore keystore, char[] password, HashMap<InetAddress, String> aliases) {
        if (aliases == null || aliases.isEmpty()) {
            throw new IllegalArgumentException("Hosts is null or empty.");
        }
        this.keyStore = keystore;
        this.password = password;
        this.aliases = aliases;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.alias != null) {
            return this.alias;
        }
        try {
            ExtendedSSLSession session = (ExtendedSSLSession)engine.getHandshakeSession();
            String hostname = null;
            for (SNIServerName name : session.getRequestedServerNames()) {
                if (name.getType() != 0) continue;
                hostname = ((SNIHostName)name).getAsciiName();
                break;
            }
            String[] arr = hostname.split("\\.");
            hostname = arr[arr.length - 2] + "." + arr[arr.length - 1];
            return this.aliases.get(InetAddress.getByName(hostname));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.alias != null) {
            return this.alias;
        }
        return this.aliases.get(socket.getLocalAddress());
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.password);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(alias);
            if (certs == null || certs.length == 0) {
                return null;
            }
            X509Certificate[] x509 = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509[i] = (X509Certificate)certs[i];
            }
            return x509;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        throw new UnsupportedOperationException("Method getServerAliases() not yet implemented.");
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        throw new UnsupportedOperationException("Method getClientAliases() not yet implemented.");
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        throw new UnsupportedOperationException("Method chooseClientAlias() not yet implemented.");
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] prncpls, SSLEngine ssle) {
        throw new UnsupportedOperationException("Method chooseEngineClientAlias() not yet implemented.");
    }
}

