/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.utils.Date;

public class Logger
implements Runnable {
    private static List pool = new LinkedList();
    private File logDir;
    private FileChannel outChannel;
    private FileOutputStream outputFile;
    private int date;
    private TimeZone tz;
    private Long maxFileSize;

    public Logger(File logDir) {
        this(logDir, null, "UTC");
    }

    public Logger(File logDir, Long maxFileSize, String timezone) {
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        this.logDir = logDir;
        this.date = -1;
        this.maxFileSize = maxFileSize;
        this.tz = Date.getTimeZone((String)timezone);
    }

    public void log(HttpServletRequest request) {
        String clientIP = request.getRemoteAddr();
        if (clientIP.startsWith("/") && clientIP.length() > 1) {
            clientIP = clientIP.substring(1);
        }
        StringBuffer str = new StringBuffer();
        str.append("New Request From: " + clientIP + "\r\n");
        str.append(request.getMethod() + ": " + request.getURL() + "\r\n");
        str.append("TimeStamp: " + this.getDate().toString("yyyy-MM-dd HH:mm a") + "\r\n");
        str.append("\r\n");
        str.append(request.toString());
        this.log(str.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str) {
        if (str != null) {
            if (!str.endsWith("\r\n")) {
                str = str + "\r\n";
            }
            List list = pool;
            synchronized (list) {
                pool.add(pool.size(), str);
                pool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            String request = null;
            List list = pool;
            synchronized (list) {
                while (pool.isEmpty()) {
                    try {
                        pool.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                request = (String)pool.remove(0);
            }
            try {
                byte[] b = request.getBytes();
                if (b.length > 8192) {
                    if (request.length() > 250) {
                        request = request.substring(0, 250);
                    }
                    request = request + "...\r\n";
                    b = request.getBytes();
                }
                ByteBuffer output = ByteBuffer.allocateDirect(b.length);
                output.put(b);
                output.flip();
                this.getFileChannel().write(output);
            }
            catch (Exception exception) {
            }
        }
    }

    private FileChannel getFileChannel() throws Exception {
        int date = Integer.parseInt(new SimpleDateFormat("yyyyMMdd").format(new java.util.Date()));
        if (date > this.date) {
            this.date = date;
            if (this.outputFile != null) {
                this.outputFile.close();
            }
            if (this.outChannel != null) {
                this.outChannel.close();
            }
            File file = new File(this.logDir, this.date + ".log");
            this.outputFile = new FileOutputStream(file, true);
            this.outChannel = this.outputFile.getChannel();
        } else {
            File file = new File(this.logDir, this.date + ".log");
            if (this.maxFileSize != null && file.length() > this.maxFileSize) {
                if (this.outputFile != null) {
                    this.outputFile.close();
                }
                if (this.outChannel != null) {
                    this.outChannel.close();
                }
                throw new Exception("Log file too big: " + file.length() + " vs " + this.maxFileSize);
            }
        }
        return this.outChannel;
    }

    public Date getDate() {
        Date d = new Date();
        d.setTimeZone(this.tz);
        return d;
    }
}

