/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.util.HashMap;
import javaxt.express.Deploy;
import javaxt.express.cms.Content;
import javaxt.express.cms.WebSite;
import javaxt.http.servlet.HttpServlet;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.utils.Console;
import javaxt.utils.Date;

public class Server {
    public static void main(String[] arr) {
        HashMap args = Console.parseArgs((String[])arr);
        if (args.containsKey("-deploy")) {
            Deploy.main(arr);
        } else {
            Directory dir;
            int port;
            try {
                port = Integer.parseInt((String)args.get("-p"));
            }
            catch (Exception e) {
                System.err.println("Port (\"-p\") is required.");
                return;
            }
            try {
                dir = new Directory((String)args.get("-d"));
                if (!dir.exists()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                System.err.println("Directory (\"-d\") is required.");
                return;
            }
            int numThreads = 50;
            try {
                numThreads = Integer.parseInt((String)args.get("-t"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                javaxt.http.Server server = new javaxt.http.Server(port, numThreads, (HttpServlet)new Demo(dir));
                server.start();
            }
            catch (Exception e) {
                System.out.println("Server could not start because of an " + e.getClass());
                System.exit(1);
            }
        }
    }

    private static class Demo
    extends WebSite {
        private Demo(Directory dir) {
            super(dir);
            super.setAuthor("ACME Inc");
        }

        @Override
        public Content getContent(HttpServletRequest request, File file) {
            String path = request.getURL().getPath().toLowerCase();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.equals("wiki")) {
                String html = file.getText();
                java.util.Date date = file.getDate();
                if (file.getName(false).equals("index")) {
                    Content content = this.getIndex(file);
                    Date d = new Date(content.getDate());
                    if (d.isAfter(new Date(date))) {
                        date = d.getDate();
                    }
                    html = html.replace("<%=index%>", content.getHTML());
                }
                return new Content(html, date);
            }
            return super.getContent(request, file);
        }
    }
}

