/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javaxt.express.utils.StringUtils;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.ServletException;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Parser;
import javaxt.utils.Console;
import javaxt.utils.URL;
import javaxt.utils.Value;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SubSelect;

public class ServiceRequest {
    private HttpServletRequest request;
    private String service;
    private String method = "";
    private String[] path;
    private Principal user;
    private URL url;
    private byte[] payload;
    private JSONObject json;
    private HashMap<String, List<String>> parameters;
    private Field[] fields;
    private Filter filter;
    private Sort sort;
    private Long limit;
    private Long offset;
    private Long id;
    private static String[] approvedFunctions = new String[]{"min", "max", "count", "avg", "sum"};
    private Console console = new Console();

    public ServiceRequest(HttpServletRequest request) {
        this(null, request);
    }

    public ServiceRequest(String service, HttpServletRequest request) {
        this.service = service;
        this.request = request;
        this.url = new URL(request.getURL());
        this.parameters = this.url.getParameters();
        this.setPath(request.getPathInfo());
        this.updateOffsetLimit();
    }

    public String getService() {
        return this.service;
    }

    public String getMethod() {
        return this.method;
    }

    public Value getPath(int i) {
        if (this.path == null || i >= this.path.length) {
            return new Value(null);
        }
        return new Value((Object)this.path[i]);
    }

    public String getPath() {
        if (this.path == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (String s : this.path) {
            str.append("/");
            str.append(s);
        }
        return str.toString();
    }

    public void setPath(String path) {
        String name;
        if (path != null) {
            path = path.substring(1);
            boolean addPath = this.service == null;
            ArrayList<String> arr = new ArrayList<String>();
            for (String str : path.split("/")) {
                if (addPath) {
                    arr.add(str);
                }
                if (!str.equalsIgnoreCase(this.service)) continue;
                addPath = true;
            }
            this.path = arr.toArray(new String[arr.size()]);
        }
        if ((name = this.getPath(0).toString()) != null) {
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            String method = this.request.getMethod();
            if (method.equals("GET")) {
                this.method = "get" + name;
            } else if (method.equals("PUT") || method.equals("POST")) {
                this.method = "save" + name;
            } else if (method.equals("DELETE")) {
                this.method = "delete" + name;
            }
        }
        this.id = this.getPath(1).toLong();
        if (this.id == null) {
            this.id = this.getParameter("id").toLong();
        }
    }

    public Long getID() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public Value getParameter(String key) {
        String val;
        List<String> parameters;
        if (key != null && (parameters = ServiceRequest.getParameter(key, this.parameters)) != null && (val = parameters.get(0).trim()).length() > 0) {
            if (val.equalsIgnoreCase("null")) {
                val = null;
            }
            return new Value((Object)val);
        }
        return new Value(null);
    }

    public boolean hasParameter(String key) {
        List<String> parameters;
        return key != null && (parameters = ServiceRequest.getParameter(key, this.parameters)) != null;
    }

    public void setParameter(String key, String val) {
        if (key != null) {
            String k;
            if (val == null) {
                ServiceRequest.removeParameter(key, this.parameters);
                return;
            }
            List<String> parameters = ServiceRequest.getParameter(key, this.parameters);
            if (parameters == null && this.hasParameter(key)) {
                parameters = new ArrayList<String>();
                parameters.add(this.getParameter(key).toString());
                ServiceRequest.setParameter(key, parameters, this.parameters);
            }
            if (parameters == null) {
                if (val != null) {
                    parameters = new ArrayList<String>();
                    parameters.add(val);
                    ServiceRequest.setParameter(key, parameters, this.parameters);
                }
            } else if (val != null) {
                parameters.set(0, val);
            }
            if ((k = key.toLowerCase()).equals("offset") || k.equals("limit") || k.equals("page")) {
                this.updateOffsetLimit();
            }
        }
    }

    public String[] getParameterNames() {
        ArrayList<String> arr = new ArrayList<String>();
        Iterator<String> it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            arr.add(it.next());
        }
        return arr.toArray(new String[arr.size()]);
    }

    private static List<String> getParameter(String key, HashMap<String, List<String>> parameters) {
        return URL.getParameter((String)key, parameters);
    }

    private static void setParameter(String key, List<String> values, HashMap<String, List<String>> parameters) {
        URL.setParameter((String)key, values, parameters);
    }

    private static void removeParameter(String key, HashMap<String, List<String>> parameters) {
        URL.removeParameter((String)key, parameters);
    }

    private void updateOffsetLimit() {
        this.offset = this.getParameter("offset").toLong();
        this.limit = this.getParameter("limit").toLong();
        Long page = this.getParameter("page").toLong();
        if (this.offset == null && page != null) {
            if (this.limit == null) {
                this.limit = 25L;
            }
            this.offset = page * this.limit - this.limit;
        }
    }

    public Long getOffset() {
        return this.offset;
    }

    public Long getLimit() {
        return this.limit;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        this.json = null;
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            try {
                this.payload = this.request.getBody();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.payload;
    }

    public JSONObject getJson() {
        if (this.json == null) {
            String payload = null;
            try {
                payload = new String(this.getPayload(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (payload != null) {
                this.json = new JSONObject(payload);
            }
        }
        return this.json;
    }

    public Principal getUser() {
        if (this.user == null) {
            this.user = this.request.getUserPrincipal();
        }
        return this.user;
    }

    public String[] getCredentials() {
        return this.request.getCredentials();
    }

    public void authenticate() throws ServletException {
        this.request.authenticate();
    }

    public Field[] getFields() {
        if (this.fields != null) {
            return this.fields;
        }
        String fields = this.getParameter("fields").toString();
        if (fields == null || fields.length() == 0) {
            return null;
        }
        try {
            ArrayList<Field> arr = new ArrayList<Field>();
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            Select select = (Select)parserManager.parse((Reader)new StringReader("SELECT " + fields + " FROM T"));
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            for (SelectExpressionItem si : plainSelect.getSelectItems()) {
                Expression expression = si.getExpression();
                String alias = si.getAlias() == null ? null : si.getAlias().getName();
                boolean addField = true;
                String functionName = null;
                try {
                    Function f = (Function)expression;
                    functionName = f.getName().toLowerCase();
                }
                catch (Exception e) {
                    try {
                        SubSelect ss = (SubSelect)expression;
                        functionName = "SELECT";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (functionName != null) {
                    addField = false;
                    if (functionName.startsWith("st_")) {
                        addField = true;
                    } else {
                        for (String fn : approvedFunctions) {
                            if (!fn.equals(functionName)) continue;
                            addField = true;
                            break;
                        }
                    }
                }
                if (!addField) continue;
                Field field = new Field(expression.toString());
                field.setAlias(alias);
                if (functionName != null) {
                    field.isFunction(true);
                }
                arr.add(field);
            }
            this.fields = arr.toArray(new Field[arr.size()]);
        }
        catch (Throwable e) {
            this.fields = this.getFields(fields);
        }
        return this.fields;
    }

    private Field[] getFields(String fields) {
        Parser sqlParser = new Parser("SELECT " + fields + " FROM T");
        ArrayList<Field> arr = new ArrayList<Field>();
        for (Parser.SelectStatement stmt : sqlParser.getSelectStatements()) {
            Field field = new Field(stmt.getField());
            field.setAlias(stmt.getAlias());
            field.isFunction(stmt.isFunction());
            arr.add(field);
        }
        return arr.toArray(new Field[arr.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public Filter getFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (this.hasParameter("filter")) {
            String str = this.getParameter("filter").toString();
            if (str.startsWith("{") && str.endsWith("}")) {
                JSONObject json = new JSONObject(str);
                Iterator it = json.keys();
                while (it.hasNext()) {
                    String string = (String)it.next();
                    params.put(string, json.get(string));
                }
            } else {
                HashMap map = URL.parseQueryString((String)str);
                for (String string : map.keySet()) {
                    List vals = (List)map.get(string);
                    if (vals.isEmpty()) continue;
                    params.put(string, new Value(vals.get(0)));
                }
            }
        } else {
            for (String string : this.getParameterNames()) {
                params.put(string, this.getParameter(string));
            }
        }
        this.filter = new Filter();
        for (String key : params.keySet()) {
            void var5_32;
            CharSequence str;
            CharSequence op;
            void var5_17;
            String k = key.toLowerCase();
            if (k.equals("fields") || k.equals("where") || k.equals("orderby") || k.equals("limit") || k.equals("offset") || k.equals("page") || k.equals("count") || k.equals("_")) continue;
            String string = ((Value)params.get(key)).toString();
            if (string == null) {
                String string2 = "null";
            }
            if (var5_17.contains(",")) {
                void var5_19;
                if (var5_17.startsWith("!")) {
                    String string3 = var5_17.substring(1).trim();
                    op = "NOT IN";
                } else {
                    op = "IN";
                }
                str = new StringBuilder("(");
                int x = 0;
                String nullVal = null;
                for (String s : var5_19.split(",")) {
                    if (s.equalsIgnoreCase("NULL") || s.equalsIgnoreCase("!NULL")) {
                        nullVal = s;
                        continue;
                    }
                    if (x > 0) {
                        ((StringBuilder)str).append(",");
                    }
                    ((StringBuilder)str).append(s);
                    ++x;
                }
                ((StringBuilder)str).append(")");
                if (nullVal != null) {
                    if (((String)op).equals("IN")) {
                        ((StringBuilder)str).append(" OR ");
                        ((StringBuilder)str).append(StringUtils.camelCaseToUnderScore(key));
                        ((StringBuilder)str).append(" IS");
                        if (nullVal.startsWith("!")) {
                            ((StringBuilder)str).append(" NOT");
                        }
                        ((StringBuilder)str).append(" NULL");
                    } else {
                        ((StringBuilder)str).append(" AND ");
                        ((StringBuilder)str).append(StringUtils.camelCaseToUnderScore(key));
                        ((StringBuilder)str).append(" IS");
                        if (nullVal.startsWith("!")) {
                            ((StringBuilder)str).append(" NOT");
                        }
                        ((StringBuilder)str).append(" NULL");
                    }
                }
                String string4 = ((StringBuilder)str).toString();
            } else {
                op = "=";
                block6 : switch (str = var5_17.substring(0, var5_17.length() > 1 ? 2 : 1)) {
                    case "<>": {
                        op = str;
                        String string5 = var5_17.substring(2).trim();
                        break;
                    }
                    case "!=": {
                        op = "<>";
                        String string6 = var5_17.substring(2).trim();
                        break;
                    }
                    case ">=": {
                        op = str;
                        String string7 = var5_17.substring(2).trim();
                        break;
                    }
                    case "<=": {
                        op = str;
                        String string8 = var5_17.substring(2).trim();
                        break;
                    }
                    default: {
                        String s;
                        if (var5_17.toLowerCase().startsWith("startswith(") && var5_17.endsWith(")")) {
                            op = "LIKE";
                            String string9 = "'" + var5_17.substring(11, var5_17.length() - 1).replace("'", "''") + "%'";
                            break;
                        }
                        if (var5_17.toLowerCase().startsWith("endswith(") && var5_17.endsWith(")")) {
                            op = "LIKE";
                            String string10 = "'%" + var5_17.substring(9, var5_17.length() - 1).replace("'", "''") + "'";
                            break;
                        }
                        if (var5_17.toLowerCase().startsWith("contains(") && var5_17.endsWith(")")) {
                            op = "LIKE";
                            String string11 = "'%" + var5_17.substring(9, var5_17.length() - 1).replace("'", "''") + "%'";
                            break;
                        }
                        switch (s = var5_17.substring(0, 1)) {
                            case "=": {
                                op = s;
                                String string12 = var5_17.substring(1).trim();
                                break block6;
                            }
                            case ">": {
                                op = s;
                                String string13 = var5_17.substring(1).trim();
                                break block6;
                            }
                            case "!": {
                                op = "<>";
                                String string14 = var5_17.substring(1).trim();
                                break block6;
                            }
                            case "<": {
                                op = s;
                                String string15 = var5_17.substring(1).trim();
                                break block6;
                            }
                        }
                    }
                }
            }
            if (var5_32.equalsIgnoreCase("null")) {
                if (((String)op).equals("=")) {
                    op = "IS";
                }
                if (((String)op).equals("<>")) {
                    op = "IS NOT";
                }
            }
            this.filter.set(key, (String)op, var5_32);
        }
        return this.filter;
    }

    public String getWhere() {
        return this.getParameter("where").toString();
    }

    public Sort getSort() {
        if (this.sort != null) {
            return this.sort;
        }
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        String orderBy = this.getParameter("orderby").toString();
        if (orderBy != null) {
            if (orderBy.startsWith("[") && orderBy.endsWith("]")) {
                JSONArray arr = new JSONArray(orderBy);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject json = arr.get(i).toJSONObject();
                    String key = json.get("property").toString();
                    String dir = json.get("direction").toString();
                    if (key == null) continue;
                    if (dir == null) {
                        dir = "ASC";
                    }
                    fields.put(key, dir);
                }
            } else {
                for (String field : orderBy.split(",")) {
                    String b;
                    String a;
                    if ((field = field.trim()).length() <= 0) continue;
                    String f = field.toUpperCase();
                    if (f.endsWith(" ASC") || f.endsWith(" DESC")) {
                        int x = field.lastIndexOf(" ");
                        a = field.substring(0, x).trim();
                        b = field.substring(x).trim();
                    } else {
                        a = field;
                        b = "ASC";
                    }
                    a = StringUtils.camelCaseToUnderScore(a).toUpperCase();
                    fields.put(a, b);
                }
            }
        }
        this.sort = new Sort(fields);
        return this.sort;
    }

    public class Filter {
        private LinkedHashMap<String, Item> items = new LinkedHashMap();

        protected Filter() {
        }

        public void set(String col, Object val) {
            this.set(col, "=", val);
        }

        public void set(String col, String op, Object val) {
            this.items.put(col.toLowerCase(), new Item(col, op, val instanceof Value ? (Value)val : new Value(val)));
        }

        public Value get(String col) {
            Item item = this.items.get(col.toLowerCase());
            if (item != null) {
                return item.val;
            }
            return new Value(null);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public Item[] getItems() {
            ArrayList<Item> arr = new ArrayList<Item>();
            for (String key : this.items.keySet()) {
                Item item = this.items.get(key);
                arr.add(item);
            }
            return arr.toArray(new Item[arr.size()]);
        }

        public JSONArray toJson() {
            JSONArray arr = new JSONArray();
            for (Item item : this.getItems()) {
                arr.add((Object)item.toJson());
            }
            return arr;
        }

        public class Item {
            private String col;
            private String op;
            private Value val;

            private Item(String col, String op, Value val) {
                this.col = col;
                this.op = op;
                this.val = val;
            }

            public String toString() {
                return StringUtils.camelCaseToUnderScore(this.col) + " " + this.op + " " + this.val;
            }

            public JSONObject toJson() {
                JSONObject json = new JSONObject();
                json.set("col", (Object)this.col);
                json.set("op", (Object)this.op);
                json.set("val", (Object)this.val);
                return json;
            }
        }
    }

    public class Field {
        private String col;
        private String table;
        private String alias;
        private boolean isFunction;

        public Field(String field) {
            this.col = field;
            this.isFunction = false;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public boolean isFunction() {
            return this.isFunction;
        }

        public void isFunction(boolean isFunction) {
            this.isFunction = isFunction;
        }

        public String toString() {
            String str = this.col;
            if (this.table != null) {
                str = this.table + "." + str;
            }
            if (this.alias != null) {
                str = str + " as " + this.alias;
            }
            return str;
        }

        public boolean equals(Object obj) {
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.equalsIgnoreCase(this.col)) {
                    return true;
                }
                if (str.equalsIgnoreCase(this.alias)) {
                    return true;
                }
                if (str.equalsIgnoreCase(this.toString())) {
                    return true;
                }
            } else if (obj instanceof Field) {
                Field field = (Field)obj;
                return field.equals(this.toString());
            }
            return false;
        }
    }

    public class Sort {
        LinkedHashMap<String, String> fields;

        public Sort(LinkedHashMap<String, String> fields) {
            this.fields = fields;
        }

        public LinkedHashMap<String, String> getFields() {
            return this.fields;
        }

        public Set<String> getKeySet() {
            return this.fields.keySet();
        }

        public String get(String key) {
            return this.fields.get(key);
        }

        public boolean isEmpty() {
            return this.fields.isEmpty();
        }
    }
}

