/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.io.InputStream;
import java.util.HashMap;
import javaxt.io.File;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Model;
import javaxt.utils.Date;

public class ServiceResponse {
    private String contentType = "text/plain";
    private String contentDisposition = null;
    private Long contentLength;
    private int status = 200;
    private Date date;
    private String cacheControl;
    private String authMessage;
    private Object response;
    private HashMap<String, Object> properties = new HashMap();

    public ServiceResponse(byte[] response) {
        this.response = response;
        this.contentLength = response.length;
    }

    public ServiceResponse(File file) {
        this.contentType = file.getContentType();
        this.contentLength = file.getSize();
        this.response = file;
    }

    public ServiceResponse(InputStream response) {
        this.response = response;
    }

    public ServiceResponse(int status, String body) {
        this(ServiceResponse.getBytes(body));
        this.status = status;
    }

    public ServiceResponse(String str) {
        this(200, str);
    }

    public ServiceResponse(StringBuffer str) {
        this(200, str.toString());
    }

    public ServiceResponse(JSONObject json) {
        this(200, json.toString());
        this.contentType = "application/json";
    }

    public ServiceResponse(JSONArray json) {
        this(200, json.toString());
        this.contentType = "application/json";
    }

    public ServiceResponse(Model model) {
        this(model.toJson());
    }

    public ServiceResponse(int status) {
        this.status = status;
    }

    public ServiceResponse(Exception e) {
        this((Throwable)e);
    }

    public ServiceResponse(Throwable e) {
        this(500, e.getMessage() == null || e.getMessage().trim().length() == 0 ? "Unspecified Web Services Error" : e.getMessage());
        String error;
        String s = e.getClass().getName();
        s = s.substring(s.lastIndexOf(".") + 1);
        String message = e.getLocalizedMessage();
        String string = error = message != null ? s + ": " + message : s;
        if (error.equalsIgnoreCase("NullPointerException")) {
            StackTraceElement x;
            String err;
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n && !(err = (x = stackTraceElementArray[i]).toString()).trim().startsWith("org.eclipse.jetty"); ++i) {
                error = error + "\n" + x;
            }
        }
        System.out.println(error);
        this.response = ServiceResponse.getBytes(error);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentDisposition(String fileName) {
        this.contentDisposition = fileName == null ? null : "attachment;filename=\"" + fileName + "\"";
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.clone();
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public int getStatus() {
        return this.status;
    }

    public void setAuthMessage(String msg) {
        this.authMessage = msg;
    }

    public String getAuthMessage() {
        return this.authMessage;
    }

    public void set(String key, Object val) {
        this.properties.put(key, val);
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Object getResponse() {
        return this.response;
    }

    private static byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }
}

