/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.util.ArrayList;
import java.util.HashMap;
import javaxt.io.File;
import javaxt.utils.Date;
import javaxt.utils.Generator;

public class WebLog {
    private File log;
    private Integer id;

    public WebLog(File log) {
        this.log = log;
        try {
            this.id = Integer.parseInt(log.getName(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getID() {
        return this.id;
    }

    public String toString() {
        return this.log.toString();
    }

    public Generator<Entry> getEntries() {
        return new Generator<Entry>(){

            public void run() {
                HashMap<String, Date> map = new HashMap<String, Date>();
                String[] requests = WebLog.this.log.getText().split("\r\n\r\n");
                for (int i = 0; i < requests.length; ++i) {
                    try {
                        Entry entry;
                        String range;
                        if (!requests[i].startsWith("New Request From")) continue;
                        boolean skip = false;
                        String ip = null;
                        String url = null;
                        String op = null;
                        Date date = null;
                        for (String row : requests[i].split("\r\n")) {
                            if (!row.contains(":")) continue;
                            String key = row.substring(0, row.indexOf(":")).trim();
                            String value = row.substring(row.indexOf(":") + 1).trim();
                            if (key.equals("New Request From")) {
                                ip = value;
                                continue;
                            }
                            if (key.equalsIgnoreCase("Timestamp")) {
                                try {
                                    date = new Date(value);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            op = key;
                            url = value;
                        }
                        try {
                            String key = ip + "-" + url.toLowerCase();
                            if (map.containsKey(key)) {
                                Date d = (Date)map.get(key);
                                long seconds = date.compareTo(d, "seconds");
                                if (seconds < 300L) {
                                    skip = true;
                                } else {
                                    map.put(key, date);
                                }
                            } else {
                                map.put(key, date);
                            }
                        }
                        catch (Exception key) {
                            // empty catch block
                        }
                        String requestHeader = requests[++i];
                        if (op != null) {
                            op = op.toUpperCase();
                        }
                        if ((range = (entry = new Entry(date, ip, op, url, requestHeader)).getValue("Range")).contains("bytes=") && WebLog.this.id != null && WebLog.this.id < 20130518) {
                            skip = true;
                        }
                        entry.skip = skip;
                        this.yield(entry);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public void cleanLogFile(String ipAddress) {
        java.util.Date date = this.log.getDate();
        String[] requests = this.log.getText().split("\r\n\r\n");
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < requests.length; ++i) {
            if (!requests[i].startsWith("New Request From")) continue;
            String request = requests[i] + "\r\n\r\n" + requests[i + 1] + "\r\n\r\n";
            ++i;
            if (request.startsWith("New Request From: " + ipAddress)) continue;
            str.append(request);
        }
        this.log.write(str.toString());
        this.log.setDate(date);
    }

    public class Entry {
        private String ip;
        private String host;
        private String method;
        private String url;
        private String path;
        private String protocol;
        private Date date;
        private String[] header;
        private String tld;
        private String domainName;
        private boolean skip = false;

        public Entry(Date date, String ip, String method, String url, String header) {
            this.ip = ip;
            this.url = url;
            this.date = date;
            this.method = method;
            this.header = header.split("\r\n");
            try {
                String str = url.substring(url.indexOf("://") + 3);
                int idx = str.indexOf("/");
                if (idx > 0) {
                    this.host = str.substring(0, idx);
                    this.path = str.substring(idx + 1);
                } else {
                    this.host = str;
                }
                this.host = this.host.toLowerCase();
                if (this.host.contains(".")) {
                    String[] arr = this.host.split("\\.");
                    this.tld = arr[arr.length - 1];
                    this.domainName = arr[arr.length - 2];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String[] getValues(String name) {
            ArrayList<String> values = new ArrayList<String>();
            for (String row : this.header) {
                if (!row.contains(":")) continue;
                String key = row.substring(0, row.indexOf(":")).trim();
                String value = row.substring(row.indexOf(":") + 1).trim();
                if (!key.equalsIgnoreCase(name)) continue;
                values.add(value);
            }
            return values.toArray(new String[values.size()]);
        }

        public String getValue(String name) {
            String[] values = this.getValues(name);
            return values.length > 0 ? values[0] : "";
        }

        public boolean ignore() {
            return this.skip;
        }

        public String getMethod() {
            return this.method;
        }

        public String getURL() {
            return this.url;
        }

        public String getPath() {
            return this.path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Date getDate() {
            return this.date.clone();
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getIP() {
            return this.ip;
        }
    }
}

