/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.express.ServiceRequest;
import javaxt.express.ServiceResponse;
import javaxt.express.utils.DbUtils;
import javaxt.express.utils.StringUtils;
import javaxt.http.servlet.ServletException;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.json.JSONValue;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Model;
import javaxt.sql.Recordset;
import javaxt.utils.Console;

public abstract class WebService {
    private ConcurrentHashMap<String, DomainClass> classes = new ConcurrentHashMap();
    public static Console console = new Console();

    public void addClass(Class c) {
        this.addClass(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(Class c, boolean readOnly) {
        int idx;
        String pkg;
        if (!Model.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException();
        }
        String name = c.getSimpleName();
        if (name.startsWith(pkg = c.getPackage().getName())) {
            name = name.substring(pkg.length() + 1);
        }
        if ((idx = (name = name.toLowerCase()).lastIndexOf(".")) > 0) {
            name = name.substring(idx + 1);
        }
        ConcurrentHashMap<String, DomainClass> concurrentHashMap = this.classes;
        synchronized (concurrentHashMap) {
            this.classes.put(name, new DomainClass(c, readOnly));
            this.classes.notify();
        }
    }

    public ServiceResponse getServiceResponse(ServiceRequest request, Database database) throws ServletException {
        DomainClass c;
        String className;
        String method = request.getMethod().toLowerCase();
        for (Method m : this.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            if (Modifier.isPrivate(m.getModifiers()) || !m.getName().equalsIgnoreCase(method) || !m.getReturnType().equals(ServiceResponse.class) || (params = m.getParameterTypes()).length <= 1 || !ServiceRequest.class.isAssignableFrom(params[0])) continue;
            Object[] inputs = null;
            if (params.length == 1) {
                inputs = new Object[]{request};
            } else if (params.length == 2 && Database.class.isAssignableFrom(params[1])) {
                inputs = new Object[]{request, database};
            }
            if (inputs == null) continue;
            try {
                m.setAccessible(true);
                return (ServiceResponse)m.invoke((Object)this, inputs);
            }
            catch (Exception e) {
                return this.getServiceResponse(e);
            }
        }
        if (method.startsWith("get")) {
            className = method.substring(3);
            DomainClass c2 = this.getClass(className);
            if (c2 != null) {
                return this.get(c2.c, request, database);
            }
            if (className.endsWith("ies")) {
                c2 = this.getClass(className.substring(0, className.length() - 3) + "y");
            } else if (className.endsWith("ses")) {
                c2 = this.getClass(className.substring(0, className.length() - 2));
            } else if (className.endsWith("s")) {
                c2 = this.getClass(className.substring(0, className.length() - 1));
            }
            if (c2 != null) {
                return this.list(c2.c, request, database);
            }
        } else if (method.startsWith("save")) {
            className = method.substring(4);
            DomainClass c3 = this.getClass(className);
            if (c3 != null) {
                if (c3.isReadOnly()) {
                    return new ServiceResponse(403, "Write access forbidden.");
                }
                return this.save(c3.c, request, database);
            }
        } else if (method.startsWith("delete") && (c = this.getClass(className = method.substring(6))) != null) {
            if (c.isReadOnly()) {
                return new ServiceResponse(403, "Delete access forbidden.");
            }
            return this.delete(c.c, request, database);
        }
        return new ServiceResponse(501, "Not Implemented.");
    }

    protected Recordset getRecordset(ServiceRequest request, String op, Class c, String sql, Connection conn) throws Exception {
        Recordset rs = new Recordset();
        if (op.equals("list")) {
            rs.setFetchSize(1000);
        }
        rs.open(sql, conn);
        return rs;
    }

    private ServiceResponse get(Class c, ServiceRequest request, Database database) {
        Connection conn = null;
        try {
            Object obj;
            Long id = request.getID();
            if (id == null) {
                Method get = this.getMethod("get", c);
                String[] keys = request.getParameterNames();
                ArrayList<String> params = new ArrayList<String>();
                for (String key : keys) {
                    if (key.equals("_")) continue;
                    params.add(key + "=");
                    params.add(request.getParameter(key).toString());
                }
                Object[] arr = params.toArray(new Object[params.size()]);
                obj = get.invoke(null, new Object[]{arr});
            } else {
                obj = this.newInstance(c, id);
            }
            if (obj == null) {
                return new ServiceResponse(404);
            }
            id = null;
            conn = database.getConnection();
            Recordset rs = this.getRecordset(request, "get", c, "select id from " + this.getTableName(obj) + " where id=" + this.getMethod("getID", c).invoke(obj, new Object[0]), conn);
            if (!rs.EOF) {
                id = rs.getValue(0).toLong();
            }
            rs.close();
            conn.close();
            if (id == null) {
                return new ServiceResponse(404);
            }
            Method toJson = this.getMethod("toJson", c);
            return new ServiceResponse((JSONObject)toJson.invoke(obj, new Object[0]));
        }
        catch (Exception e) {
            return this.getServiceResponse(e);
        }
    }

    private ServiceResponse list(Class c, ServiceRequest request, Database database) {
        String tableName;
        HashSet<String> spatialFields = new HashSet<String>();
        try {
            Object obj = c.newInstance();
            Field field = obj.getClass().getSuperclass().getDeclaredField("tableName");
            field.setAccessible(true);
            tableName = (String)field.get(obj);
            for (Field f : obj.getClass().getDeclaredFields()) {
                String packageName;
                Class<?> fieldType = f.getType();
                String string = packageName = fieldType.getPackage() == null ? "" : fieldType.getPackage().getName();
                if (!packageName.startsWith("javaxt.geospatial.geometry") && !packageName.startsWith("com.vividsolutions.jts.geom") && !packageName.startsWith("org.locationtech.jts.geom")) continue;
                spatialFields.add(f.getName());
            }
        }
        catch (Exception e) {
            return this.getServiceResponse(e);
        }
        Connection conn = null;
        try {
            Long limit;
            Long offset;
            ServiceRequest.Sort sort;
            StringBuilder str = new StringBuilder("select ");
            ServiceRequest.Field[] fields = request.getFields();
            if (fields == null) {
                str.append(" * ");
            } else {
                for (int i = 0; i < fields.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    ServiceRequest.Field field = fields[i];
                    String fieldName = field.toString();
                    if (field.isFunction()) {
                        str.append(fieldName);
                        continue;
                    }
                    fieldName = StringUtils.camelCaseToUnderScore(fieldName);
                    str.append(fieldName);
                }
            }
            str.append(" from ");
            str.append(tableName);
            ServiceRequest.Filter filter = request.getFilter();
            if (!filter.isEmpty()) {
                str.append(" where ");
                ServiceRequest.Filter.Item[] items = filter.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (i > 0) {
                        str.append(" and ");
                    }
                    str.append("(");
                    str.append(items[i].toString());
                    str.append(")");
                }
            } else {
                String where = request.getWhere();
                if (where != null) {
                    str.append(" where ");
                    str.append(where);
                }
            }
            if (!(sort = request.getSort()).isEmpty()) {
                str.append(" order by ");
                Iterator<String> it = sort.getKeySet().iterator();
                while (it.hasNext()) {
                    String colName = it.next();
                    String direction = sort.get(colName);
                    str.append(colName);
                    str.append(" ");
                    str.append(direction);
                    if (!it.hasNext()) continue;
                    str.append(",");
                }
            }
            if ((offset = request.getOffset()) != null) {
                str.append(" offset ");
                str.append(offset);
            }
            if ((limit = request.getLimit()) == null) {
                limit = 100L;
            }
            if (limit != null) {
                str.append(" limit ");
                str.append(limit);
            }
            long x = 0L;
            JSONArray cols = new JSONArray();
            StringBuilder json = new StringBuilder("{\"rows\":[");
            conn = database.getConnection();
            Recordset rs = this.getRecordset(request, "list", c, str.toString(), conn);
            while (rs.hasNext()) {
                JSONArray row = new JSONArray();
                JSONObject record = DbUtils.getJson(rs);
                for (javaxt.sql.Field field : rs.getFields()) {
                    JSONValue val;
                    String fieldName = field.getName().toLowerCase();
                    fieldName = StringUtils.underscoreToCamelCase(fieldName);
                    if (x == 0L) {
                        cols.add((Object)fieldName);
                    }
                    if (!(val = record.get(fieldName)).isNull() && spatialFields.contains(fieldName) && database.getDriver().equals((Object)"PostgreSQL")) {
                        val = new JSONValue(this.createGeom(val.toString()));
                    }
                    row.add((Object)val);
                }
                if (x > 0L) {
                    json.append(",");
                }
                json.append(row.toString());
                rs.moveNext();
                ++x;
            }
            rs.close();
            conn.close();
            json.append("]");
            json.append(",\"cols\":");
            json.append(cols.toString());
            json.append("}");
            ServiceResponse response = new ServiceResponse(json.toString());
            response.setContentType("application/json");
            return response;
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            return this.getServiceResponse(e);
        }
    }

    private ServiceResponse save(Class c, ServiceRequest request, Database database) {
        Connection conn = null;
        try {
            Object obj;
            JSONObject json = new JSONObject(new String(request.getPayload(), "UTF-8"));
            if (json.isEmpty()) {
                throw new Exception("JSON is empty.");
            }
            Long id = json.get("id").toLong();
            boolean isNew = false;
            if (id != null) {
                obj = this.newInstance(c, id);
                Method update = c.getDeclaredMethod("update", JSONObject.class);
                update.invoke(obj, json);
            } else {
                obj = this.newInstance(c, json);
                isNew = true;
            }
            if (!isNew) {
                conn = database.getConnection();
                Recordset rs = this.getRecordset(request, "save", c, "select id from " + this.getTableName(obj) + " where id=" + this.getMethod("getID", c).invoke(obj, new Object[0]), conn);
                if (!rs.EOF) {
                    id = rs.getValue(0).toLong();
                }
                rs.close();
                conn.close();
                if (id == null) {
                    return new ServiceResponse(404);
                }
            }
            Method save = this.getMethod("save", c);
            save.invoke(obj, new Object[0]);
            Method getID = this.getMethod("getID", c);
            id = (Long)getID.invoke(obj, new Object[0]);
            if (isNew) {
                this.onCreate(obj, request);
            } else {
                this.onUpdate(obj, request);
            }
            return new ServiceResponse(id + "");
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            return this.getServiceResponse(e);
        }
    }

    private ServiceResponse delete(Class c, ServiceRequest request, Database database) {
        Connection conn = null;
        try {
            Long id = null;
            conn = database.getConnection();
            Recordset rs = this.getRecordset(request, "delete", c, "select id from " + this.getTableName(c.newInstance()) + " where id=" + request.getID(), conn);
            if (!rs.EOF) {
                id = rs.getValue(0).toLong();
            }
            rs.close();
            conn.close();
            if (id == null) {
                return new ServiceResponse(404);
            }
            Object obj = this.newInstance(c, id);
            Method delete = this.getMethod("delete", c);
            delete.invoke(obj, new Object[0]);
            this.onDelete(obj, request);
            return new ServiceResponse(200);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            return this.getServiceResponse(e);
        }
    }

    public void onCreate(Object obj, ServiceRequest request) {
    }

    public void onUpdate(Object obj, ServiceRequest request) {
    }

    public void onDelete(Object obj, ServiceRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainClass getClass(String className) {
        ConcurrentHashMap<String, DomainClass> concurrentHashMap = this.classes;
        synchronized (concurrentHashMap) {
            return this.classes.get(className);
        }
    }

    private Method getMethod(String name, Class clazz) {
        while (clazz != null) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private Object newInstance(Class c, long id) throws Exception {
        Constructor constructor = c.getDeclaredConstructor(Long.TYPE);
        return constructor.newInstance(id);
    }

    private Object newInstance(Class c, JSONObject json) throws Exception {
        Constructor constructor = c.getDeclaredConstructor(JSONObject.class);
        return constructor.newInstance(json);
    }

    private String getTableName(Object obj) throws Exception {
        Field field = obj.getClass().getSuperclass().getDeclaredField("tableName");
        field.setAccessible(true);
        String tableName = (String)field.get(obj);
        return tableName;
    }

    private ServiceResponse getServiceResponse(Exception e) {
        if (e instanceof InvocationTargetException) {
            return new ServiceResponse(e.getCause());
        }
        return new ServiceResponse(e);
    }

    public Object createGeom(String hex) throws Exception {
        Class<?> c;
        try {
            c = Class.forName("com.vividsolutions.jts.io.WKBReader");
        }
        catch (ClassNotFoundException e) {
            try {
                c = Class.forName("org.locationtech.jts.io.WKBReader");
            }
            catch (ClassNotFoundException ex) {
                throw new Exception("JTS not found!");
            }
        }
        Method read = null;
        Method hexToBytes = null;
        for (Method method : c.getDeclaredMethods()) {
            Parameter[] parameters;
            String methodName = method.getName();
            if (methodName.equals("hexToBytes")) {
                hexToBytes = method;
                continue;
            }
            if (!methodName.equals("read") || (parameters = method.getParameters()).length != 1 || !parameters[0].getType().equals(byte[].class)) continue;
            read = method;
        }
        byte[] b = (byte[])hexToBytes.invoke(null, hex);
        return read.invoke(c.newInstance(), new Object[]{b});
    }

    private class DomainClass {
        private Class c;
        private boolean readOnly;

        public DomainClass(Class c, boolean readOnly) {
            this.c = c;
            this.readOnly = readOnly;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }
}

