/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.cms;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javaxt.io.File;

public class Redirects {
    private HashMap<String, String> redirects = new HashMap();
    private List<String> sortedKeys = new ArrayList<String>();
    private File file;
    private long lastUpdate;

    public Redirects(File file) {
        this.file = file;
        this.parseRedirects();
    }

    private void parseRedirects() {
        this.redirects.clear();
        this.sortedKeys.clear();
        if (this.file.exists()) {
            this.lastUpdate = this.file.getDate().getTime();
            for (String entry : this.file.getText().split("\r\n")) {
                if ((entry = entry.trim()).length() == 0 || entry.startsWith("#") || entry.startsWith("//")) continue;
                while (entry.contains("\t\t")) {
                    entry = entry.replace("\t\t", "\t");
                }
                String[] arr = entry.split("\t");
                if (arr.length <= 1) continue;
                this.redirects.put(arr[0], arr[1]);
            }
            this.sortedKeys = new ArrayList<String>(this.redirects.keySet());
            Collections.sort(this.sortedKeys, new StringComparator());
        }
    }

    public String getRedirect(URL url) {
        return this.getRedirect(url.toString());
    }

    private String getRedirect(String url) {
        if (this.file.exists() && this.file.getDate().getTime() != this.lastUpdate) {
            this.parseRedirects();
        }
        for (String key : this.sortedKeys) {
            if (!url.toUpperCase().contains(key.toUpperCase())) continue;
            String replacement = this.redirects.get(key);
            int x = url.toUpperCase().indexOf(key.toUpperCase());
            int y = key.length();
            String a = url.substring(0, x);
            String b = url.substring(x + y);
            return a + replacement + b;
        }
        return null;
    }

    private class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String t1, String t2) {
            return new Integer(t2.length()).compareTo(new Integer(t1.length()));
        }
    }
}

