/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.cms;

import java.util.LinkedHashMap;
import javaxt.io.File;

public class Tabs {
    private File file;
    private long lastModified;
    private LinkedHashMap<String, String> items;

    public Tabs(File file) {
        this.file = file;
        this.lastModified = 0L;
        this.items = this.getItems();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public LinkedHashMap<String, String> getItems() {
        if (this.file.exists()) {
            long lastModified = this.file.getDate().getTime();
            if (lastModified > this.lastModified) {
                this.items = new LinkedHashMap();
                for (String row : this.file.getText().split("\n")) {
                    if ((row = row.trim()).length() <= 0 || !row.contains("\t") || row.startsWith("<!--") || row.startsWith("#") || row.startsWith("//")) continue;
                    int idx = row.indexOf("\t");
                    String text = row.substring(0, idx).trim();
                    String link = row.substring(idx).trim();
                    this.items.put(text, link);
                }
                this.lastModified = lastModified;
            }
        } else {
            this.lastModified = 0L;
            this.items = new LinkedHashMap();
        }
        return this.items;
    }
}

