/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.cms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import javaxt.express.FileManager;
import javaxt.express.cms.Content;
import javaxt.express.cms.Redirects;
import javaxt.express.cms.Tabs;
import javaxt.express.utils.WebUtils;
import javaxt.html.Element;
import javaxt.html.Parser;
import javaxt.http.servlet.HttpServlet;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.http.servlet.ServletException;
import javaxt.io.Directory;
import javaxt.utils.Console;
import javaxt.utils.Date;
import javaxt.utils.URL;

public abstract class WebSite
extends HttpServlet {
    protected Console console = new Console();
    private Directory web;
    private FileManager fileManager;
    private javaxt.io.File template;
    private Tabs tabs;
    private String companyName;
    private String companyAcronym;
    private String author;
    private String keywords;
    private Redirects redirects;
    private String[] fileExtensions = new String[]{".html", ".txt"};
    private String[] DefaultFileNames = new String[]{"home", "index", "Overview"};

    public WebSite(Directory web, String servletPath) {
        this.web = web;
        this.template = new javaxt.io.File(web + "style/template.html");
        this.tabs = new Tabs(new javaxt.io.File(web + "style/tabs.txt"));
        this.redirects = new Redirects(new javaxt.io.File(web + "style/redirects.txt"));
        this.setServletPath(servletPath);
        this.fileManager = new FileManager(web);
    }

    public WebSite(Directory web) {
        this(web, "/");
    }

    public Directory getWebDirectory() {
        return this.web;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setCompanyName(String companyName) {
        this.setCompanyName(companyName, null);
    }

    public void setCompanyName(String companyName, String companyAcronym) {
        this.companyName = companyName;
        this.companyAcronym = companyAcronym;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    protected String getCopyright() {
        return "Copyright &copy; " + this.getYear();
    }

    protected int getYear() {
        return new Date().getYear();
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path;
        java.net.URL url = request.getURL();
        if (this.redirect(url, response)) {
            return;
        }
        if (this.supportsHttps()) {
            response.setHeader("Content-Security-Policy", "upgrade-insecure-requests");
            String upgradeRequest = request.getHeader("Upgrade-Insecure-Requests");
            if (upgradeRequest != null && upgradeRequest.equals("1") && !url.getProtocol().equalsIgnoreCase("https")) {
                String location = url.toString();
                location = "https" + location.substring(location.indexOf(":"));
                response.setStatus(307);
                response.setHeader("Vary", "Upgrade-Insecure-Requests");
                response.setHeader("Location", location);
                return;
            }
        }
        if ((path = this.getPath(url)).startsWith(".well-known")) {
            this.console.log((Object)path);
            File file = new File(this.web + path);
            this.console.log((Object)(file + "\t" + file.exists()));
            if (file.exists()) {
                response.write(file, javaxt.io.File.getContentType((String)file.getName()), true);
            } else {
                response.setStatus(404);
                response.setContentType("text/plain");
            }
            return;
        }
        javaxt.io.File file = this.getFile(path);
        if (file != null) {
            boolean sendFile = true;
            String ext = file.getExtension().toLowerCase();
            if (ext.equals("html")) {
                sendFile = !this.isSnippet(file);
            } else if (ext.equals("txt")) {
                String filePath = file.getDirectory().toString();
                int idx = filePath.indexOf("/wiki/");
                boolean bl = sendFile = idx == -1;
            }
            if (sendFile) {
                this.fileManager.sendFile(file, request, response);
                return;
            }
        } else {
            int idx = path.lastIndexOf("/");
            if (idx > -1) {
                path = path.substring(idx);
            }
            if ((idx = path.lastIndexOf(".")) > -1) {
                response.sendError(404);
                return;
            }
        }
        this.sendHTML(request, response);
    }

    protected void sendFile(javaxt.io.File file, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType = file.getContentType();
        String ext = file.getExtension().toLowerCase();
        if (ext.equals("js") || ext.equals("css")) {
            URL url = new URL(request.getURL());
            long currVersion = new Date(file.getLastModifiedTime()).toLong();
            long requestedVersion = 0L;
            try {
                requestedVersion = Long.parseLong(url.getParameter("v"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (requestedVersion < currVersion) {
                url.setParameter("v", currVersion + "");
                response.sendRedirect(url.toString(), true);
                return;
            }
        } else if (ext.equals("xml")) {
            contentType = "text/xml";
        }
        response.write(file.toFile(), contentType, true);
    }

    private String getPath(java.net.URL url) {
        String path = url.getPath();
        String servletPath = this.getServletPath();
        if (!servletPath.endsWith("/")) {
            servletPath = servletPath + "/";
        }
        if ((path = path.substring(path.indexOf(servletPath)).substring(servletPath.length())).startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private javaxt.io.File getFile(String path) {
        if (path.length() == 0 || path.endsWith("/") || path.toLowerCase().startsWith("bin/")) {
            return null;
        }
        for (String p : path.split("/")) {
            if (!p.startsWith(".")) continue;
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        files.add(path);
        files.add("downloads/" + path);
        for (String str : files) {
            javaxt.io.File file = new javaxt.io.File(this.web + str);
            if (!file.exists() || file.isHidden()) continue;
            return file;
        }
        return null;
    }

    private void sendHTML(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String newScript;
        Parser document;
        String servletPath = this.getServletPath();
        if (!servletPath.endsWith("/")) {
            servletPath = servletPath + "/";
        }
        java.net.URL url = request.getURL();
        javaxt.io.File file = this.getHtmlFile(url);
        boolean useTemplate = true;
        String templateParam = request.getParameter("template");
        if (templateParam != null && templateParam.equals("false")) {
            useTemplate = false;
        }
        TreeSet<Long> dates = new TreeSet<Long>();
        if (file != null) {
            dates.add(file.getDate().getTime());
        }
        if (useTemplate) {
            dates.add(this.template.getDate().getTime());
            dates.add(this.tabs.getLastModified());
        }
        Content content = this.getContent(request, file);
        dates.add(content.getDate().getTime());
        String html = content.getHTML();
        html = html.replace("<%=Path%>", servletPath);
        if (useTemplate) {
            document = new Parser(html);
            Object title = null;
            try {
                String[] el = document.getElementByTagName("title");
                html = html.replace(el.getOuterHTML(), "");
                title = el.getInnerText().trim();
            }
            catch (Exception el) {
                // empty catch block
            }
            if (title == null) {
                try {
                    title = document.getElementByTagName("h1").getInnerHTML();
                }
                catch (Exception el) {
                    // empty catch block
                }
            }
            if (title == null) {
                if (this.companyName != null && this.companyAcronym != null) {
                    title = this.companyAcronym + " - " + this.companyName;
                } else if (file != null) {
                    title = file.getName(false);
                    for (String fileName : this.DefaultFileNames) {
                        if (!((String)title).equalsIgnoreCase(fileName)) continue;
                        title = file.getDirectory().getName();
                        break;
                    }
                }
            }
            if (title == null) {
                title = "";
            }
            String description = null;
            try {
                Element el = document.getElementByTagName("description");
                html = html.replace(el.getOuterHTML(), "");
                description = el.getInnerHTML();
            }
            catch (Exception el) {
                // empty catch block
            }
            if (description == null) {
                description = "";
            }
            String keywords = null;
            try {
                Element el = document.getElementByTagName("keywords");
                html = html.replace(el.getOuterHTML(), "");
                keywords = el.getInnerHTML();
            }
            catch (Exception el) {
                // empty catch block
            }
            if (keywords == null) {
                keywords = this.keywords;
            }
            if (keywords == null) {
                keywords = "";
            }
            html = this.template.getText().replace("<%=content%>", html);
            html = html.replace("<%=title%>", (CharSequence)title);
            html = html.replace("<%=description%>", description);
            html = html.replace("<%=keywords%>", keywords);
            html = html.replace("<%=author%>", this.author == null ? "" : this.author);
            html = html.replace("<%=Path%>", servletPath);
            html = html.replace("<%=companyName%>", this.companyName == null ? "" : this.companyName);
            html = html.replace("<%=year%>", this.getYear() + "");
            html = html.replace("<%=copyright%>", this.getCopyright());
            html = html.replace("<%=navbar%>", this.getNavBar(request, file));
            html = html.replace("<%=tabs%>", this.getTabs(url.getPath(), this.tabs));
        }
        document = new Parser(html);
        for (Element script : document.getElementsByTagName("script")) {
            String newSrc;
            String src = script.getAttribute("src");
            if (src.length() <= 0 || src.equals(newSrc = this.getPath(src, "js", url, dates))) continue;
            newScript = script.getOuterHTML().replace(src, newSrc);
            html = html.replace(script.getOuterHTML(), newScript);
        }
        for (Element link : document.getElementsByTagName("link")) {
            String newHref;
            String href = link.getAttribute("href");
            if (href.length() <= 0 || href.equals(newHref = this.getPath(href, "css", url, dates))) continue;
            newScript = link.getOuterHTML().replace(href, newHref);
            html = html.replace(link.getOuterHTML(), newScript);
        }
        html = html.trim();
        long lastModified = dates.last();
        String date = WebUtils.getDate(lastModified);
        String eTag = "W/\"" + html.length() + "-" + lastModified + "\"";
        boolean useCache = true;
        if (useCache) {
            String matchTag = request.getHeader("if-none-match");
            String cacheControl = request.getHeader("cache-control");
            if (matchTag == null) {
                matchTag = "";
            }
            if (cacheControl == null) {
                cacheControl = "";
            }
            if (!cacheControl.equalsIgnoreCase("no-cache")) {
                if (eTag.equalsIgnoreCase(matchTag)) {
                    response.setStatus(304);
                    return;
                }
                matchTag = request.getHeader("if-modified-since");
                if (matchTag != null) {
                    for (String tag : matchTag.split(";")) {
                        if (!tag.trim().equalsIgnoreCase(date)) continue;
                        response.setStatus(304);
                        return;
                    }
                }
            }
        }
        byte[] rsp = html.getBytes("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.setContentLength(rsp.length);
        response.setHeader("ETag", eTag);
        response.setHeader("Last-Modified", date);
        response.write(rsp);
    }

    private String getPath(String src, String ext, java.net.URL url, TreeSet<Long> dates) {
        int idx = src.toLowerCase().indexOf("." + ext.toLowerCase());
        if (idx > 0) {
            String a = src.substring(0, idx);
            String b = src.substring(idx, idx + ext.length() + 1);
            String p = Parser.MapPath((String)src, (java.net.URL)url);
            try {
                javaxt.io.File f = this.getFile(this.getPath(new java.net.URL(p)));
                java.util.Date d = f.getDate();
                dates.add(d.getTime());
                long v = new Date(d).toLong();
                URL u = new URL(p);
                u.setParameter("v", v + "");
                src = a + b + "?" + u.getQueryString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return src;
    }

    protected Content getContent(HttpServletRequest request, javaxt.io.File file) {
        if (file == null || !file.exists()) {
            return new Content("404", new java.util.Date());
        }
        return new Content(file.getText("UTF-8"), file.getDate());
    }

    private javaxt.io.File getHtmlFile(java.net.URL url) {
        String[] contentFolders;
        String folderPath;
        javaxt.io.File file;
        String path = url.getPath();
        String servletPath = this.getServletPath();
        if (!servletPath.endsWith("/")) {
            servletPath = servletPath + "/";
        }
        if ((path = path.substring(path.indexOf(servletPath)).substring(servletPath.length())).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((file = this.getFile(path, folderPath = this.web.toString())) != null) {
            return file;
        }
        for (String folderName : contentFolders = new String[]{"documentation", "wiki"}) {
            folderPath = this.web + folderName + "/";
            file = this.getFile(path, folderPath);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private javaxt.io.File getFile(String path, String folderPath) {
        Directory dir;
        if (path.length() > 0) {
            for (String fileExtension : this.fileExtensions) {
                javaxt.io.File file = new javaxt.io.File(folderPath + path + fileExtension);
                if (!file.exists() || !this.isSnippet(file)) continue;
                return file;
            }
        }
        if ((dir = new Directory(folderPath + path)).exists()) {
            for (String fileName : this.DefaultFileNames) {
                for (String fileExtension : this.fileExtensions) {
                    javaxt.io.File file = new javaxt.io.File(dir, fileName + fileExtension);
                    if (!file.exists() || !this.isSnippet(file)) continue;
                    return file;
                }
            }
        }
        return null;
    }

    private boolean isSnippet(javaxt.io.File file) {
        String str = file.getText("UTF-8").trim();
        return !str.endsWith("</html>");
    }

    protected Content getIndex(javaxt.io.File file) {
        Directory dir = file.getDirectory();
        String path = dir.toString();
        path = path.substring(this.web.toString().length());
        if (!(path = path.replace("\\", "/")).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        LinkedList<javaxt.io.File> files = new LinkedList<javaxt.io.File>();
        TreeSet<Long> dates = new TreeSet<Long>();
        dates.add(file.getDate().getTime());
        for (javaxt.io.File f : dir.getFiles((Object)this.fileExtensions, true)) {
            if (f.equals((Object)file)) continue;
            files.add(f);
            dates.add(f.getDate().getTime());
        }
        StringBuffer toc = new StringBuffer();
        toc.append("<ul>\r\n");
        String prevPath = "";
        int len = dir.getPath().length();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            javaxt.io.File f = (javaxt.io.File)it.next();
            String fileName = f.getName(false);
            String relPath = f.getDirectory().getPath().substring(len).replace("\\", "/");
            String link = path;
            if (relPath.length() > 0) {
                link = link + relPath;
            }
            link = link + fileName;
            String li = "<li><a href=\"" + link + "\">" + fileName.replace("_", " ") + "</a></li>\r\n";
            if (relPath.equals(prevPath)) {
                toc.append(li);
            } else {
                int i;
                int numTags;
                String[] prevDirs = prevPath.split("/");
                String[] currDirs = relPath.split("/");
                if (prevPath.length() > 0) {
                    numTags = prevDirs.length;
                    for (i = 0; i < prevDirs.length; ++i) {
                        String currDir;
                        String prevDir = prevDirs[i];
                        String string = currDir = i < currDirs.length - 1 ? currDirs[i] : "";
                        if (!prevDir.equals(currDir)) break;
                        --numTags;
                    }
                    for (int j = 0; j < numTags; ++j) {
                        toc.append("</ul>\r\n");
                    }
                }
                numTags = currDirs.length;
                if (prevPath.length() > 0) {
                    for (i = 0; i < currDirs.length; ++i) {
                        String prevDir;
                        String currDir = currDirs[i];
                        String string = prevDir = i < prevDirs.length - 1 ? prevDirs[i] : "";
                        if (!currDir.equals(prevDir)) break;
                        --numTags;
                    }
                }
                for (i = 0; i < numTags; ++i) {
                    int offset = currDirs.length - numTags;
                    int idx = offset + i;
                    String dirName = currDirs[idx];
                    String tag = null;
                    if (idx == 0) {
                        tag = "h2";
                    }
                    toc.append("<li>");
                    if (tag != null) {
                        toc.append("<" + tag + ">");
                    }
                    toc.append(dirName.replace("_", " "));
                    if (tag != null) {
                        toc.append("</" + tag + ">");
                    }
                    toc.append("</li>\r\n");
                    toc.append("<ul>\r\n");
                }
                toc.append(li);
                prevPath = relPath;
            }
            if (it.hasNext()) continue;
            String[] currDirs = relPath.split("/");
            int numTags = currDirs.length;
            for (int j = 0; j < numTags; ++j) {
                toc.append("</ul>\r\n");
            }
        }
        toc.append("</ul>\r\n");
        java.util.Date lastModified = new java.util.Date((Long)dates.last());
        return new Content(toc.toString(), lastModified);
    }

    private String getTabs(String reqPath, Tabs tabs) {
        LinkedHashMap<String, String> items = tabs.getItems();
        Iterator<String> it = items.keySet().iterator();
        String servletPath = this.getServletPath();
        if (!servletPath.endsWith("/")) {
            servletPath = servletPath + "/";
        }
        StringBuffer str = new StringBuffer();
        while (it.hasNext()) {
            String text = it.next();
            String link = items.get(text).replace("<%=Path%>", servletPath);
            boolean isActive = this.isActiveTab(text, link, reqPath);
            str.append("<a href=\"" + link + "\">");
            str.append("<div");
            if (isActive) {
                str.append(" class=\"active\"");
            }
            str.append(">");
            str.append(text);
            str.append("</div>");
            str.append("</a>");
        }
        return str.toString();
    }

    protected boolean isActiveTab(String tabLabel, String tabLink, String reqPath) {
        boolean isActive = false;
        if (reqPath.startsWith(tabLink)) {
            String servletPath = this.getServletPath();
            if (!servletPath.endsWith("/")) {
                servletPath = servletPath + "/";
            }
            isActive = tabLink.equals(servletPath) ? reqPath.equals(servletPath) : true;
        }
        return isActive;
    }

    protected String getNavBar(HttpServletRequest request, javaxt.io.File file) {
        return "";
    }

    private boolean redirect(java.net.URL url, HttpServletResponse response) throws ServletException, IOException {
        String redirect = this.redirects.getRedirect(url);
        if (redirect != null) {
            response.sendRedirect(redirect, true);
            return true;
        }
        return false;
    }
}

