/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.email;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;

public class EmailMessage {
    private String subject = "UNTITLED";
    private String content = "";
    private String contentType = "text/plain";
    private InternetAddress from;
    private ArrayList<InternetAddress> to;
    private Message message;

    public EmailMessage(Session session) {
        this.message = new MimeMessage(session);
        this.to = new ArrayList();
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContent(String content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    public void setFrom(String emailAddress, String alias) throws Exception {
        this.from = new InternetAddress(emailAddress, alias);
    }

    public void addRecipient(String emailAddress) throws Exception {
        this.to.add(new InternetAddress(emailAddress));
    }

    public void send() throws Exception {
        this.message.addFrom((Address[])new InternetAddress[]{this.from});
        for (InternetAddress recipient : this.to) {
            this.message.addRecipient(MimeMessage.RecipientType.TO, (Address)recipient);
        }
        this.message.setSubject(this.subject);
        this.message.setContent((Object)this.content, this.contentType);
        Transport.send((Message)this.message);
    }
}

