/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.email;

import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.util.Properties;
import javaxt.express.email.EmailMessage;

public class EmailService {
    private Properties properties;
    private String host;
    private Integer port;
    private String username;
    private String password;
    private Authenticator authenticator;

    public EmailService(String host, int port, String username, String password) {
        this.authenticator = new Authenticator(username, password);
        this.properties = new Properties();
        this.setHost(host, port);
        this.properties.setProperty("mail.smtp.submitter", username);
        this.properties.setProperty("mail.smtp.auth", "true");
        this.properties.setProperty("mail.smtp.ssl.enable", "true");
        this.properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
    }

    public void setHost(String host, int port) {
        this.setHost(host);
        this.setPort(port);
    }

    public void setHost(String host) {
        if (host == null) {
            this.host = null;
        } else if ((host = host.trim()).contains(":")) {
            try {
                this.host = host.substring(0, host.indexOf(":"));
                this.port = Integer.valueOf(host.substring(host.indexOf(":") + 1));
            }
            catch (Exception e) {
                this.host = host;
            }
        } else {
            this.host = host;
        }
        this.properties.setProperty("mail.smtp.host", host);
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
        this.properties.setProperty("mail.smtp.port", port + "");
    }

    public Integer getPort() {
        return this.port;
    }

    public EmailMessage createEmail() {
        return new EmailMessage(this.getSession());
    }

    public Session getSession() {
        return Session.getInstance((Properties)this.properties, (jakarta.mail.Authenticator)this.authenticator);
    }

    private class Authenticator
    extends jakarta.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(String username, String password) {
            this.authentication = new PasswordAuthentication(username, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

