/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.services;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javaxt.express.ServiceRequest;
import javaxt.express.ServiceResponse;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.utils.Date;

public class FileService {
    private Directory baseDir;
    private static int numDigits = "9223372036854775807".length();
    private static String zeros = FileService.getZeros();

    private static String getZeros() {
        String str = "";
        for (int i = 0; i < numDigits; ++i) {
            str = str + "0";
        }
        return str;
    }

    public FileService() {
        this.baseDir = null;
    }

    public FileService(Directory baseDir) {
        this.baseDir = baseDir;
    }

    public ServiceResponse getList(ServiceRequest request) throws Exception {
        Boolean showHidden;
        String path = this.getPath(request);
        String filter = request.getParameter("filter").toString();
        List list = this.getList(path, filter);
        boolean isDriveList = path.isEmpty() && this.baseDir == null;
        String sortBy = "name";
        String direction = "ASC";
        ServiceRequest.Sort sort = request.getSort();
        if (sort != null && !sort.isEmpty()) {
            sortBy = sort.getKeySet().iterator().next();
            direction = sort.get(sortBy);
            sortBy = sortBy.toLowerCase();
        }
        if ((showHidden = request.getParameter("hidden").toBoolean()) == null) {
            showHidden = false;
        }
        TreeMap<String, Object> files = new TreeMap<String, Object>();
        TreeMap<String, JSONArray> folders = new TreeMap<String, JSONArray>();
        long totalSize = 0L;
        for (int i = 0; i < list.size(); ++i) {
            boolean isFolder;
            boolean isHidden;
            Long size;
            String type;
            String name;
            java.util.Date date;
            Object obj = list.get(i);
            if (obj instanceof File) {
                File f = (File)obj;
                date = f.getDate();
                name = f.getName();
                type = f.getContentType();
                size = f.getSize();
                isHidden = f.isHidden();
                isFolder = false;
            } else {
                if (!(obj instanceof Directory)) continue;
                Directory d = (Directory)obj;
                if (isDriveList) {
                    name = d.getPath();
                    date = null;
                    type = "Drive";
                    isHidden = false;
                } else {
                    name = d.getName();
                    date = d.getDate();
                    type = "Folder";
                    isHidden = d.isHidden();
                }
                size = 0L;
                isFolder = true;
            }
            if (!isHidden) {
                isHidden = name.startsWith(".");
            }
            if (isHidden && !showHidden.booleanValue()) continue;
            totalSize += size.longValue();
            JSONArray item = new JSONArray();
            item.add((Object)name);
            item.add((Object)type);
            item.add((Object)date);
            item.add((Object)size);
            String key = "";
            if (sortBy.equals("date")) {
                if (date == null) {
                    key = "00000000000000000";
                } else {
                    Date d = new Date(date);
                    key = d.toLong() + "";
                }
            } else if (sortBy.equals("size")) {
                String s = size + "";
                int x2 = numDigits - s.length();
                key = zeros.substring(0, x2) + s;
            } else if (sortBy.equals("type")) {
                key = type;
            }
            key = key + "|" + name.toLowerCase();
            if (isFolder) {
                folders.put(key, item);
                continue;
            }
            files.put(key, item);
        }
        Long offset = request.getOffset();
        Long limit = request.getLimit();
        long start = offset == null ? 0L : offset;
        long end = limit == null ? Long.MAX_VALUE : start + limit;
        Long x = 0L;
        JSONArray arr = new JSONArray();
        if (sortBy.equals("name")) {
            JSONArray item;
            if (direction.equalsIgnoreCase("DESC")) {
                Long l;
                for (String k : files.descendingKeySet()) {
                    item = (JSONArray)files.get(k);
                    if (x >= start && x < end) {
                        arr.add((Object)item);
                    }
                    Long x2 = x;
                    l = x = Long.valueOf(x + 1L);
                }
                if (x < end) {
                    for (String k : folders.descendingKeySet()) {
                        item = (JSONArray)folders.get(k);
                        if (x >= start && x < end) {
                            arr.add((Object)item);
                        }
                        Long x2 = x;
                        l = x = Long.valueOf(x + 1L);
                    }
                }
            } else {
                Long l;
                for (String k : folders.keySet()) {
                    item = (JSONArray)folders.get(k);
                    if (x >= start && x < end) {
                        arr.add((Object)item);
                    }
                    Long x2 = x;
                    l = x = Long.valueOf(x + 1L);
                }
                if (x < end) {
                    for (String k : files.keySet()) {
                        item = (JSONArray)files.get(k);
                        if (x >= start && x < end) {
                            arr.add((Object)item);
                        }
                        Long x2 = x;
                        l = x = Long.valueOf(x + 1L);
                    }
                }
            }
        } else {
            TreeMap<String, Object> items;
            if (files.size() > folders.size()) {
                items = files;
                items.putAll(folders);
            } else {
                items = folders;
                items.putAll(files);
            }
            Iterator it = direction.equalsIgnoreCase("DESC") ? items.descendingKeySet().iterator() : items.keySet().iterator();
            while (it.hasNext()) {
                String k = (String)it.next();
                JSONArray item = (JSONArray)items.get(k);
                if (x >= start && x < end) {
                    arr.add((Object)item);
                }
                Long l = x;
                Long l2 = x = Long.valueOf(x + 1L);
            }
        }
        JSONObject json = new JSONObject();
        json.set("dir", (Object)path);
        json.set("items", (Object)arr);
        json.set("count", (Object)(files.size() + folders.size()));
        json.set("size", (Object)totalSize);
        json.set("pathSeparator", (Object)Directory.PathSeparator);
        return new ServiceResponse(json);
    }

    private List getList(String path, Object filter) throws Exception {
        path = path == null ? "" : path.trim();
        List<Directory> list = new LinkedList();
        if (path.isEmpty()) {
            if (this.baseDir == null) {
                for (Directory dir : Directory.getRootDirectories()) {
                    list.add(dir);
                }
            } else {
                list = this.baseDir.getChildren(false, filter);
            }
        } else {
            Directory dir;
            if (this.baseDir == null) {
                dir = new Directory(path);
            } else {
                path = path.replace("\\", "/");
                String[] arr = path.split("/");
                path = this.baseDir.toString();
                for (String str : arr) {
                    if ((str = str.trim()).equals(".") || str.equals("..")) {
                        throw new Exception("Illegal path");
                    }
                    path = path + str + "/";
                }
                dir = new Directory(path);
            }
            list = dir.getChildren(false, filter);
        }
        return list;
    }

    public ServiceResponse getFile(ServiceRequest request) throws Exception {
        String path = this.getPath(request);
        if (path.isEmpty()) {
            return new ServiceResponse(400, "Path is required");
        }
        File file = this.getFile(path);
        if (!file.exists()) {
            return new ServiceResponse(404);
        }
        try {
            ServiceResponse response = new ServiceResponse(file.getInputStream());
            response.setContentLength(file.getSize());
            response.setContentType(file.getContentType());
            response.setDate(new Date(file.getDate()));
            return response;
        }
        catch (Exception e) {
            return new ServiceResponse(e);
        }
    }

    public File getPhysicalFile(ServiceRequest request) {
        String path = this.getPath(request);
        return this.getFile(path);
    }

    private File getFile(String path) {
        File file;
        if (this.baseDir == null) {
            file = new File(path);
        } else {
            path = path.replace("\\", "/");
            String[] arr = path.split("/");
            path = this.baseDir.toString();
            for (String str : arr) {
                if ((str = str.trim()).equals("") || str.equals(".") || str.equals("..")) {
                    throw new RuntimeException("Illegal path");
                }
                path = path + str + "/";
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            file = new File(path);
        }
        return file;
    }

    private String getPath(ServiceRequest request) {
        String path = request.getParameter("path").toString();
        path = path == null ? "" : path.trim();
        return path;
    }
}

