/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.services;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.express.ServiceRequest;
import javaxt.express.ServiceResponse;
import javaxt.express.User;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Field;
import javaxt.sql.Recordset;
import javaxt.sql.Table;
import javaxt.utils.Console;
import javaxt.utils.Date;
import javaxt.utils.Value;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class QueryService {
    private Directory jobDir;
    private Directory logDir;
    private Map<String, QueryJob> jobs = new ConcurrentHashMap<String, QueryJob>();
    private List<String> pendingJobs = new LinkedList<String>();
    private List<String> completedJobs = new LinkedList<String>();
    private List<SelectItem> selectCount;
    public static Console console = Console.console;

    public QueryService(Database database, Directory jobDir, Directory logDir) {
        if (jobDir != null && !jobDir.exists()) {
            jobDir.create();
        }
        if (jobDir == null || !jobDir.exists()) {
            throw new IllegalArgumentException("Invalid \"jobDir\"");
        }
        this.jobDir = jobDir;
        if (logDir != null && !logDir.exists()) {
            logDir.create();
        }
        if (logDir != null && logDir.exists()) {
            this.logDir = logDir;
        }
        for (Directory dir : jobDir.getSubDirectories()) {
            dir.delete();
        }
        try {
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            Select select = (Select)parserManager.parse((Reader)new StringReader("SELECT count(*) FROM T"));
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            this.selectCount = plainSelect.getSelectItems();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to instantiate JSqlParser");
        }
        int numThreads = 1;
        for (int i = 0; i < numThreads; ++i) {
            new Thread(new QueryProcessor(database, this)).start();
        }
    }

    public ServiceResponse getServiceResponse(ServiceRequest request, Database database) {
        String path = request.getPath(0).toString();
        if (path != null) {
            if (path.equals("jobs")) {
                return this.list(request);
            }
            if (path.equals("job")) {
                String method = request.getRequest().getMethod();
                if (method.equals("GET")) {
                    return this.getJob(request);
                }
                if (method.equals("POST")) {
                    return this.query(request, true);
                }
                if (method.equals("DELETE")) {
                    return this.cancel(request, database);
                }
                return new ServiceResponse(501, "Not implemented");
            }
            if (path.equals("tables")) {
                return this.getTables(request, database);
            }
            return new ServiceResponse(501, "Not implemented");
        }
        return this.query(request, false);
    }

    public void notify(QueryJob job) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse query(ServiceRequest request, boolean async) {
        try {
            Boolean count;
            Long page;
            String query = this.getParameter("q", request).toString();
            if (query == null) {
                query = this.getParameter("query", request).toString();
            }
            if (query == null) {
                throw new IllegalArgumentException("Query is required");
            }
            Long offset = this.getParameter("offset", request).toLong();
            Long limit = this.getParameter("limit", request).toLong();
            if (limit == null) {
                limit = 25L;
            }
            if (offset == null && (page = this.getParameter("page", request).toLong()) != null) {
                offset = page * limit - limit;
            }
            Select select = null;
            CreateTable createTempTable = null;
            Statements statements = CCJSqlParserUtil.parseStatements((String)query);
            if (statements != null) {
                for (Statement statement : statements.getStatements()) {
                    if (statement instanceof CreateTable) {
                        String option;
                        CreateTable createTable = (CreateTable)statement;
                        boolean isTemporaryTable = false;
                        Iterator i2 = createTable.getCreateOptionsStrings().iterator();
                        if (i2.hasNext() && (option = (String)i2.next()).equalsIgnoreCase("TEMPORARY")) {
                            isTemporaryTable = true;
                        }
                        if (isTemporaryTable) {
                            if (select != null) {
                                throw new IllegalArgumentException("Temporary table must be created before the SELECT statement");
                            }
                            if (createTempTable != null) {
                                throw new IllegalArgumentException("Only 1 temp table allowed");
                            }
                            createTempTable = createTable;
                            continue;
                        }
                        throw new IllegalArgumentException("CREATE TABLE statements not allowed");
                    }
                    if (statement instanceof Select) {
                        if (select != null) {
                            throw new IllegalArgumentException("Only 1 SELECT statement allowed");
                        }
                        select = (Select)statement;
                        continue;
                    }
                    throw new IllegalArgumentException(statement.getClass().getSimpleName() + " statements not allowed");
                }
            }
            this.checkSelect((PlainSelect)select.getSelectBody());
            JSONObject params = new JSONObject();
            params.set("format", (Object)request.getParameter("format").toString());
            Boolean addMetadata = this.getParameter("metadata", request).toBoolean();
            if (addMetadata != null && addMetadata.booleanValue()) {
                params.set("metadata", (Object)true);
            }
            if ((count = this.getParameter("count", request).toBoolean()) != null && count.booleanValue()) {
                params.set("count", (Object)true);
            }
            User user = (User)((Object)request.getUser());
            QueryJob job = new QueryJob(user.getID(), select, offset, limit, params);
            if (createTempTable != null) {
                job.addTempTable(createTempTable);
            }
            String key = job.getKey();
            job.log();
            this.notify(job);
            List<String> list = this.jobs;
            synchronized (list) {
                this.jobs.put(key, job);
                this.jobs.notify();
            }
            list = this.pendingJobs;
            synchronized (list) {
                this.pendingJobs.add(key);
                this.pendingJobs.notify();
            }
            if (async) {
                return new ServiceResponse(job.toJson());
            }
            list = this.completedJobs;
            synchronized (list) {
                while (!this.completedJobs.contains(key)) {
                    try {
                        this.completedJobs.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            return this.getJobResponse(job);
        }
        catch (Exception e) {
            if (e instanceof JSQLParserException) {
                e = new Exception("Unsupported or Invalid SQL Statement");
            }
            return new ServiceResponse(e);
        }
    }

    protected void checkSelect(PlainSelect plainSelect) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse list(ServiceRequest request) {
        User user = (User)((Object)request.getUser());
        JSONArray arr = new JSONArray();
        Map<String, QueryJob> map = this.jobs;
        synchronized (map) {
            for (String key : this.jobs.keySet()) {
                QueryJob job = this.jobs.get(key);
                long userID = job.userID;
                if (user.getAccessLevel() < 5 && userID != user.getID()) continue;
                arr.add((Object)job.toJson());
            }
        }
        return new ServiceResponse(arr);
    }

    private ServiceResponse getJob(ServiceRequest request) {
        User user;
        String id = request.getPath(1).toString();
        QueryJob job = this.getJob(id, user = (User)((Object)request.getUser()));
        if (job == null) {
            return new ServiceResponse(404);
        }
        return this.getJobResponse(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryJob getJob(String jobID, User user) {
        Map<String, QueryJob> map = this.jobs;
        synchronized (map) {
            return this.jobs.get(user.getID() + ":" + jobID);
        }
    }

    private ServiceResponse getJobResponse(QueryJob job) {
        ServiceResponse response;
        if (job.status.equals("failed")) {
            File file = job.getOutput();
            String str = file.getText();
            response = new ServiceResponse(500, str);
            this.deleteJob(job);
        } else if (job.status.equals("complete")) {
            File file = job.getOutput();
            String str = file.getText();
            response = new ServiceResponse(str);
            response.setContentType(file.getContentType());
            this.deleteJob(job);
        } else {
            response = new ServiceResponse(job.status);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteJob(QueryJob job) {
        String key = job.getKey();
        Object object = this.pendingJobs;
        synchronized (object) {
            this.pendingJobs.remove(key);
            this.pendingJobs.notify();
        }
        object = this.completedJobs;
        synchronized (object) {
            this.completedJobs.remove(key);
            this.completedJobs.notify();
        }
        object = this.jobs;
        synchronized (object) {
            this.jobs.remove(key);
            this.jobs.notify();
        }
        File file = job.getOutput();
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse cancel(ServiceRequest request, Database database) {
        User user;
        String id = request.getPath(1).toString();
        QueryJob job = this.getJob(id, user = (User)((Object)request.getUser()));
        if (job == null) {
            return new ServiceResponse(404);
        }
        String key = job.getKey();
        List<String> list = this.pendingJobs;
        synchronized (list) {
            this.pendingJobs.remove(key);
            this.pendingJobs.notify();
        }
        Connection conn = null;
        try {
            job.status = "canceled";
            job.updated = new Date();
            this.notify(job);
            conn = database.getConnection();
            Integer pid = this.getPid(job.getKey(), conn);
            if (pid != null) {
                boolean jobCanceled = false;
                Recordset rs = new Recordset();
                rs.open("SELECT pg_cancel_backend(" + pid + ")", conn);
                if (!rs.EOF) {
                    jobCanceled = rs.getValue(0).toBoolean();
                }
                rs.close();
                if (!jobCanceled) {
                    rs.open("SELECT pg_terminate_backend(" + pid + ")", conn);
                    if (!rs.EOF) {
                        jobCanceled = rs.getValue(0).toBoolean();
                    }
                    rs.close();
                }
                if (!jobCanceled) {
                    throw new Exception();
                }
            }
            conn.close();
            this.deleteJob(job);
            return new ServiceResponse(job.toJson());
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            return new ServiceResponse(500, "failed to cancel query");
        }
    }

    private Integer getPid(String key, Connection conn) throws SQLException {
        Integer pid = null;
        Recordset rs = new Recordset();
        rs.open("SELECT pid from pg_stat_activity where query like '--" + key + "%'", conn);
        if (!rs.EOF) {
            pid = rs.getValue(0).toInteger();
        }
        rs.close();
        return pid;
    }

    public ServiceResponse getTables(ServiceRequest request, Database database) {
        Connection conn = null;
        try {
            JSONArray arr = new JSONArray();
            conn = database.getConnection();
            for (Table table : Database.getTables((Connection)conn)) {
                JSONArray columns = new JSONArray();
                for (Column column : table.getColumns()) {
                    JSONObject col = new JSONObject();
                    col.set("name", (Object)column.getName());
                    col.set("type", (Object)column.getType());
                    if (column.isPrimaryKey()) {
                        col.set("primaryKey", (Object)true);
                    }
                    columns.add((Object)col);
                }
                JSONObject json = new JSONObject();
                json.set("name", (Object)table.getName());
                json.set("schema", (Object)table.getSchema());
                json.set("columns", (Object)columns);
                arr.add((Object)json);
            }
            conn.close();
            JSONObject json = new JSONObject();
            json.set("tables", (Object)arr);
            return new ServiceResponse(json);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            return new ServiceResponse(e);
        }
    }

    private Value getParameter(String name, ServiceRequest request) {
        if (request.getRequest().getMethod().equals("GET")) {
            return request.getParameter(name);
        }
        JSONObject json = request.getJson();
        if (json.has(name)) {
            return new Value(json.get(name).toObject());
        }
        return request.getParameter(name);
    }

    private class QueryProcessor
    implements Runnable {
        private Database database;
        private QueryService queryService;

        public QueryProcessor(Database database, QueryService queryService2) {
            this.database = database;
            this.queryService = queryService2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object obj = null;
                List list = QueryService.this.pendingJobs;
                synchronized (list) {
                    while (QueryService.this.pendingJobs.isEmpty()) {
                        try {
                            QueryService.this.pendingJobs.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    obj = QueryService.this.pendingJobs.get(0);
                    if (obj != null) {
                        QueryService.this.pendingJobs.remove(0);
                    }
                    QueryService.this.pendingJobs.notifyAll();
                }
                if (obj == null) break;
                String key = obj;
                QueryJob job = null;
                Map map = QueryService.this.jobs;
                synchronized (map) {
                    job = (QueryJob)QueryService.this.jobs.get(key);
                }
                if (job == null || job.isCanceled()) continue;
                Connection conn = null;
                try {
                    job.status = "running";
                    job.updated = new Date();
                    long startTime = System.currentTimeMillis();
                    this.queryService.notify(job);
                    conn = this.database.getConnection();
                    CreateTable createTempTable = job.getTempTable();
                    if (createTempTable != null) {
                        conn.execute("--" + job.getKey() + "\n" + createTempTable.toString());
                        if (job.isCanceled()) {
                            conn.execute("DROP TABLE " + createTempTable.getTable().getName());
                            throw new Exception();
                        }
                    }
                    String query = job.getQuery();
                    Writer writer = new Writer(job.getOutputFormat(), job.addMetadata());
                    Recordset rs = new Recordset();
                    rs.setFetchSize(1000);
                    rs.open("--" + job.getKey() + "\n" + query, conn);
                    while (rs.hasNext()) {
                        writer.write(rs);
                        rs.moveNext();
                    }
                    rs.close();
                    if (job.isCanceled()) {
                        throw new Exception();
                    }
                    if (job.countTotal()) {
                        Long ttl;
                        rs = new Recordset();
                        rs.open(job.getCountQuery(), conn);
                        if (!rs.EOF && (ttl = rs.getValue(0).toLong()) != null) {
                            writer.setCount(ttl);
                        }
                        rs.close();
                    }
                    if (job.isCanceled()) {
                        throw new Exception();
                    }
                    if (createTempTable != null) {
                        conn.execute("DROP TABLE " + createTempTable.getTable().getName());
                    }
                    if (job.isCanceled()) {
                        throw new Exception();
                    }
                    conn.close();
                    writer.setElapsedTime(System.currentTimeMillis() - startTime);
                    File file = job.getOutput();
                    file.write(writer.toString());
                    job.status = "complete";
                    job.updated = new Date();
                    this.queryService.notify(job);
                }
                catch (Exception e) {
                    if (conn != null) {
                        conn.close();
                    }
                    File file = job.getOutput();
                    if (job.isCanceled()) {
                        file.delete();
                    }
                    job.status = "failed";
                    job.updated = new Date();
                    this.queryService.notify(job);
                    PrintStream ps = null;
                    try {
                        file.create();
                        ps = new PrintStream(file.toFile());
                        e.printStackTrace(ps);
                        ps.close();
                    }
                    catch (Exception ex) {
                        if (ps != null) {
                            ps.close();
                        }
                        file.write(e.getMessage());
                    }
                }
                if (job.isCanceled()) continue;
                List list2 = QueryService.this.completedJobs;
                synchronized (list2) {
                    QueryService.this.completedJobs.add(job.getKey());
                    QueryService.this.completedJobs.notify();
                }
            }
        }
    }

    public class QueryJob {
        private String id = UUID.randomUUID().toString();
        private long userID;
        private Select select;
        private Long offset;
        private LongValue limit;
        private Date created;
        private Date updated;
        private String status;
        private String format;
        private boolean countTotal = false;
        private boolean addMetadata = false;
        private CreateTable tempTable;

        public QueryJob(long userID, Select select, Long offset, Long limit, JSONObject params) {
            this.userID = userID;
            this.select = select;
            this.offset = offset;
            this.limit = limit == null ? null : new LongValue(limit.longValue());
            this.created = new Date();
            this.updated = this.created.clone();
            this.status = "pending";
            String format = params.get("format").toString();
            if (format == null) {
                format = "";
            }
            this.format = (format = format.trim().toLowerCase()).equals("csv") || format.equals("tsv") ? format : "json";
            if (params.has("count")) {
                this.countTotal = params.get("count").toBoolean();
            }
            if (params.has("metadata")) {
                this.addMetadata = params.get("metadata").toBoolean();
            }
        }

        public String getID() {
            return this.id;
        }

        public long getUserID() {
            return this.userID;
        }

        public String getStatus() {
            return this.status;
        }

        public void addTempTable(CreateTable stmt) {
            this.tempTable = stmt;
        }

        public CreateTable getTempTable() {
            return this.tempTable;
        }

        public String getKey() {
            return this.userID + ":" + this.id;
        }

        public boolean isCanceled() {
            return this.status.equals("canceled");
        }

        public String getQuery() {
            Limit l;
            PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
            if (this.offset != null) {
                Offset o = plainSelect.getOffset();
                if (o == null) {
                    o = new Offset();
                }
                o.setOffset(this.offset.longValue());
                plainSelect.setOffset(o);
            }
            if (this.limit != null && (l = plainSelect.getLimit()) == null) {
                l = new Limit();
                l.setRowCount((Expression)this.limit);
                plainSelect.setLimit(l);
            }
            String query = plainSelect.toString();
            if (this.select.getWithItemsList() != null) {
                Iterator i2 = this.select.getWithItemsList().iterator();
                query = "with " + i2.next() + " \r\n" + query;
            }
            return query;
        }

        public String getCountQuery() {
            PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
            plainSelect.setSelectItems(QueryService.this.selectCount);
            String query = plainSelect.toString();
            if (!this.select.getWithItemsList().isEmpty()) {
                Iterator i2 = this.select.getWithItemsList().iterator();
                query = "with " + i2.next() + " \r\n" + query;
            }
            return query;
        }

        public boolean countTotal() {
            return this.countTotal && this.format.equals("json");
        }

        public boolean addMetadata() {
            return this.addMetadata;
        }

        public String getOutputFormat() {
            return this.format;
        }

        public File getOutput() {
            return new File(QueryService.this.jobDir.toString() + this.userID + "/" + this.id + "." + this.format);
        }

        public String getContentType() {
            if (this.format.equals("tsv")) {
                return "text/plain";
            }
            if (this.format.equals("csv")) {
                return "text/csv";
            }
            return "application/json";
        }

        public void log() {
            if (QueryService.this.logDir != null) {
                File file = new File(QueryService.this.logDir.toString() + this.userID + "/" + this.id + ".json");
                file.write(this.toJson().toString());
            }
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.set("user_id", (Object)this.userID);
            json.set("job_id", (Object)this.id);
            json.set("status", (Object)this.status);
            json.set("query", (Object)this.getQuery());
            json.set("created_at", (Object)this.created);
            json.set("updated_at", (Object)this.updated);
            return json;
        }
    }

    private class Writer {
        private String format;
        private StringBuilder str = new StringBuilder();
        private long x = 0L;
        private Long elapsedTime;
        private Long count;
        private JSONArray metadata;
        private boolean addMetadata = false;
        private boolean isClosed = false;

        public Writer(String format, boolean addMetadata) {
            this.format = format;
            this.addMetadata = addMetadata;
            if (format.equals("json")) {
                this.str.append("{\"rows\":[");
            }
        }

        /*
         * WARNING - void declaration
         */
        public void write(Recordset rs) {
            if (this.isClosed) {
                return;
            }
            Field[] fields = rs.getFields();
            if (this.x == 0L) {
                this.metadata = new JSONArray();
                int count = 1;
                Field[] fieldArray = fields;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    JSONObject json = new JSONObject();
                    json.set("id", (Object)count);
                    json.set("name", (Object)field.getName());
                    json.set("type", (Object)field.getType());
                    json.set("class", (Object)field.getClassName());
                    json.set("table", (Object)field.getTable());
                    this.metadata.add((Object)json);
                    ++count;
                }
                if (this.format.equals("tsv") || this.format.equals("csv")) {
                    String string = this.format.equals("tsv") ? "\t" : ",";
                    for (int i = 0; i < fields.length; ++i) {
                        if (i > 0) {
                            this.str.append(string);
                        }
                        this.str.append(fields[i].getName());
                    }
                    this.str.append("\r\n");
                }
            }
            if (this.format.equals("json")) {
                JSONObject json = new JSONObject();
                for (Field field : fields) {
                    String s;
                    Object val = field.getValue().toObject();
                    if (val == null) {
                        val = "null";
                    } else if (val instanceof String && (s = (String)val).trim().length() == 0) {
                        val = "null";
                    }
                    json.set(field.getName(), val);
                }
                if (this.x > 0L) {
                    this.str.append(",");
                }
                this.str.append(json.toString().replace("\"null\"", "null"));
            } else if (this.format.equals("tsv") || this.format.equals("csv")) {
                void var4_11;
                String s = this.format.equals("tsv") ? "\t" : ",";
                boolean bl = false;
                while (var4_11 < fields.length) {
                    Object value;
                    if (var4_11 > 0) {
                        this.str.append(s);
                    }
                    if ((value = fields[var4_11].getValue().toObject()) == null) {
                        value = "";
                    } else if (value instanceof String) {
                        String v = (String)value;
                        if (v.contains(s)) {
                            value = "\"" + v + "\"";
                        }
                    } else if (value instanceof Date) {
                        value = ((Date)value).toISOString();
                    } else if (value instanceof java.util.Date) {
                        value = new Date((java.util.Date)value).toISOString();
                    } else if (value instanceof Calendar) {
                        value = new Date((Calendar)value).toISOString();
                    }
                    this.str.append(value);
                    ++var4_11;
                }
                this.str.append("\r\n");
            }
            ++this.x;
        }

        public void includeMetadata(boolean b) {
            this.addMetadata = b;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public void close() {
            this.isClosed = true;
            if (this.format.equals("json")) {
                this.str.append("]");
                if (this.addMetadata && this.metadata != null) {
                    this.str.append(",\"metadata\":");
                    this.str.append(this.metadata);
                }
                if (this.count != null) {
                    this.str.append(",\"total_rows\":");
                    this.str.append(this.count);
                }
                if (this.elapsedTime != null) {
                    double elapsedTime = (double)this.elapsedTime.longValue() / 1000.0;
                    BigDecimal time = new BigDecimal(elapsedTime).setScale(3, 4);
                    this.str.append(",\"time\":");
                    this.str.append(time);
                }
                this.str.append("}");
            }
        }

        public String toString() {
            if (!this.isClosed) {
                this.close();
            }
            return this.str.toString();
        }
    }
}

