/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.utils;

import java.util.ArrayList;
import javaxt.utils.Value;

public class CSV {
    public static final String UTF8_BOM = "\ufeff";

    public static Columns getColumns(String row, String delimiter) {
        Columns cols = new Columns();
        boolean insideDoubleQuotes = false;
        boolean isCSV = delimiter.equals(",");
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < row.length(); ++i) {
            String c = row.substring(i, i + 1);
            if (c.equals("\"") && isCSV) {
                insideDoubleQuotes = !insideDoubleQuotes;
            }
            if (c.equals(delimiter) && !insideDoubleQuotes) {
                cols.add(CSV.getValue(str));
                str = new StringBuilder();
                continue;
            }
            str.append(c);
        }
        cols.add(CSV.getValue(str));
        return cols;
    }

    public static String readLine(String data) {
        StringBuilder str = new StringBuilder();
        boolean insideDoubleQuotes = false;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '\"') {
                insideDoubleQuotes = !insideDoubleQuotes;
            }
            if ((c == '\r' || c == '\n') && !insideDoubleQuotes) break;
            str.append(c);
        }
        return str.toString();
    }

    private static Value getValue(StringBuilder str) {
        String col = str.toString().trim();
        if (col.length() == 0) {
            col = null;
        }
        if (col != null && col.startsWith("\"") && col.endsWith("\"") && (col = col.substring(1, col.length() - 1).trim()).length() == 0) {
            col = null;
        }
        return new Value((Object)col);
    }

    public static class Columns {
        private ArrayList<Value> cols = new ArrayList();

        public void add(Value col) {
            this.cols.add(col);
        }

        public Value get(int idx) {
            try {
                return this.cols.get(idx);
            }
            catch (Exception e) {
                return new Value(null);
            }
        }

        public int length() {
            return this.cols.size();
        }
    }
}

