/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.utils;

import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javaxt.express.utils.StringUtils;
import javaxt.io.File;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Field;
import javaxt.sql.Function;
import javaxt.sql.Recordset;
import javaxt.sql.Table;
import javaxt.sql.Value;
import javaxt.utils.Console;

public class DbUtils {
    private static Console console = new Console();

    public static void initSchema(Database database, String schema) throws Exception {
        DbUtils.initSchema(database, schema, null);
    }

    public static boolean initSchema(Database database, String schema, String tableSpace) throws Exception {
        boolean schemaInitialized = false;
        ArrayList<String> statements = new ArrayList<String>();
        for (String s : schema.split(";")) {
            StringBuffer str = new StringBuffer();
            for (String i : s.split("\r\n")) {
                if (i.trim().startsWith("--") || i.trim().startsWith("COMMENT ")) continue;
                str.append(i + "\r\n");
            }
            String cmd = str.toString().trim();
            if (cmd.length() <= 0) continue;
            statements.add(StringUtils.rtrim(str.toString()) + ";");
        }
        if (database.getDriver().equals((Object)"H2")) {
            File db = new File(database.getHost() + ".mv.db");
            if (!db.exists()) {
                Properties properties = new Properties();
                properties.setProperty("MODE", "PostgreSQL");
                database.setProperties(properties);
                ArrayList<String> arr = null;
                for (String statement : statements) {
                    int idx;
                    String str = statement.trim().toUpperCase();
                    if (arr == null && (str.startsWith("CREATE TABLE") || str.startsWith("CREATE SCHEMA"))) {
                        arr = new ArrayList<String>();
                    }
                    if (arr == null) continue;
                    if (str.startsWith("CREATE TRIGGER")) {
                        statement = "";
                    }
                    if ((idx = statement.toUpperCase().indexOf("geometry(Geometry,4326)".toUpperCase())) > 0) {
                        String a = statement.substring(0, idx) + "geometry";
                        String b = statement.substring(idx + "geometry(Geometry,4326)".length());
                        statement = a + b;
                    }
                    arr.add(statement);
                }
                Connection conn = null;
                try {
                    conn = database.getConnection();
                    conn.execute("CREATE domain IF NOT EXISTS text AS varchar");
                    conn.execute("CREATE domain IF NOT EXISTS jsonb AS varchar");
                    schemaInitialized = DbUtils.initSchema(arr, conn);
                    conn.close();
                }
                catch (SQLException e) {
                    if (conn != null) {
                        conn.close();
                    }
                    String fileName = db.getName();
                    fileName = fileName.substring(0, fileName.indexOf("."));
                    for (File file : db.getParentDirectory().getFiles((Object)(fileName + ".*.db"))) {
                        file.delete();
                    }
                    throw new Exception(e.getMessage());
                }
            }
        } else if (database.getDriver().equals((Object)"PostgreSQL")) {
            Connection conn = null;
            try {
                conn = database.getConnection();
            }
            catch (Exception e) {
                Database db = database.clone();
                db.setName("postgres");
                Connection c2 = null;
                try {
                    c2 = db.getConnection();
                    boolean createDatabase = true;
                    for (String dbName : Database.getCatalogs((Connection)c2)) {
                        if (!dbName.equalsIgnoreCase(database.getName())) continue;
                        createDatabase = false;
                        break;
                    }
                    if (createDatabase) {
                        c2.execute("CREATE DATABASE " + database.getName());
                    }
                    c2.close();
                    conn = database.getConnection();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (c2 != null) {
                        c2.close();
                    }
                    throw new Exception("Failed to connect to the database");
                }
            }
            ArrayList<String> arr = new ArrayList<String>();
            if (tableSpace != null) {
                arr.add("SET default_tablespace = " + tableSpace + ";");
            }
            block13: for (int i = 0; i < statements.size(); ++i) {
                String statement = (String)statements.get(i);
                String str = statement.trim().toLowerCase();
                if (str.startsWith("create function") || str.startsWith("create or replace function")) {
                    while (i < statements.size()) {
                        statement = statement + "\r\n";
                        str = (statement = statement + (String)statements.get(++i)).trim().toLowerCase();
                        if (!str.contains("language plpgsql")) continue;
                        arr.add(statement);
                        continue block13;
                    }
                    continue;
                }
                arr.add(statement);
            }
            try {
                schemaInitialized = DbUtils.initSchema(arr, conn);
                conn.close();
            }
            catch (Exception e) {
                if (conn != null) {
                    conn.close();
                }
                throw e;
            }
        }
        return schemaInitialized;
    }

    private static boolean initSchema(ArrayList<String> statements, Connection conn) throws SQLException {
        Table[] tables = Database.getTables((Connection)conn);
        if (tables.length > 0) {
            for (String cmd : statements) {
                String tableName = DbUtils.getTableName(cmd);
                if (tableName == null) continue;
                tableName = tableName.replace("\"", "");
                String schema = null;
                if (tableName.contains(".")) {
                    String[] arr = tableName.split("\\.");
                    schema = arr[0];
                    tableName = arr[1];
                }
                for (Table table : tables) {
                    if (!(schema == null ? table.getName().equalsIgnoreCase(tableName) : table.getSchema() != null && table.getSchema().equalsIgnoreCase(schema) && table.getName().equalsIgnoreCase(tableName))) continue;
                    return false;
                }
            }
        }
        Statement stmt = conn.getConnection().createStatement();
        for (String cmd : statements) {
            try {
                stmt.execute(cmd);
            }
            catch (SQLException e) {
                System.out.println(cmd);
                throw e;
            }
        }
        stmt.close();
        return true;
    }

    private static String getTableName(String cmd) {
        if ((cmd = cmd.trim()).startsWith("CREATE TABLE")) {
            String tableName = cmd.substring(cmd.indexOf("TABLE") + 5, cmd.indexOf("(")).trim();
            if (tableName.startsWith("\"") && tableName.endsWith("\"")) {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
            return tableName.trim();
        }
        return null;
    }

    public static LinkedHashMap<String, Boolean> getColumns(String tableName, Database sourceDB) throws Exception {
        LinkedHashMap<String, Boolean> columns = new LinkedHashMap<String, Boolean>();
        Connection conn = null;
        try {
            conn = sourceDB.getConnection();
            for (Table table : Database.getTables((Connection)conn)) {
                if (!table.getName().equalsIgnoreCase(tableName)) continue;
                for (Column column : table.getColumns()) {
                    columns.put(column.getName().toLowerCase(), false);
                }
                break;
            }
            if (sourceDB.getDriver().equals((Object)"PostgreSQL")) {
                Recordset rs = new Recordset();
                if (columns.isEmpty()) {
                    rs.open("select \n    ns.nspname as schema_name, \n    cls.relname as table_name, \n    attr.attname as column_name,\n    trim(leading '_' from tp.typname) as datatype\nfrom pg_catalog.pg_attribute as attr\njoin pg_catalog.pg_class as cls on cls.oid = attr.attrelid\njoin pg_catalog.pg_namespace as ns on ns.oid = cls.relnamespace\njoin pg_catalog.pg_type as tp on tp.typelem = attr.atttypid\nwhere \n    ns.nspname = 'public' and\n    cls.relname = '" + tableName + "' and \n    not attr.attisdropped and \n    cast(tp.typanalyze as text) = 'array_typanalyze' and \n    attr.attnum > 0\norder by \n    attr.attnum", conn);
                    while (rs.hasNext()) {
                        String columnName = rs.getValue("column_name").toString().toLowerCase();
                        String dataType = rs.getValue("datatype").toString();
                        boolean isGeometry = dataType.equalsIgnoreCase("geometry");
                        columns.put(columnName, isGeometry);
                        rs.moveNext();
                    }
                    if (columns.isEmpty()) {
                        rs.close();
                        conn.close();
                        throw new IllegalArgumentException("Invalid table name");
                    }
                } else {
                    rs.open("select column_name from information_schema.columns where table_name='" + tableName + "' and udt_name='geometry'", conn);
                    while (rs.hasNext()) {
                        String columnName = rs.getValue(0).toString().toLowerCase();
                        columns.put(columnName, true);
                        rs.moveNext();
                    }
                }
                rs.close();
            }
            conn.close();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
        return columns;
    }

    public static void executeBatch(ArrayList<String> statements, Connection conn) throws Exception {
        if (statements.isEmpty()) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.append("BEGIN;\n");
        for (String statement : statements) {
            statement = statement.trim();
            str.append(statement);
            if (!statement.endsWith(";")) {
                str.append(";");
            }
            str.append("\n");
        }
        str.append("END;\n");
        conn.execute(str.toString());
    }

    public static void copyTable(String tableName, String where, Database sourceDB, Database destDB, int pageSize, int numThreads) throws Exception {
        final long startTime = System.currentTimeMillis();
        final AtomicLong counter = new AtomicLong(0L);
        LinkedHashMap<String, Boolean> columns = DbUtils.getColumns(tableName, sourceDB);
        long minID = 0L;
        long maxID = 0L;
        String t = tableName;
        if (t.equals("user")) {
            t = "\"" + t + "\"";
        }
        Connection conn = null;
        try {
            conn = sourceDB.getConnection();
            Recordset rs = new Recordset();
            rs.open("select min(id), max(id) from " + t + (where == null ? "" : " where " + where), conn);
            if (!rs.EOF) {
                minID = rs.getValue(0).toLong();
                maxID = rs.getValue(1).toLong();
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            e.printStackTrace();
        }
        long diff = maxID - minID;
        long numRowsPerThread = Math.round(diff / (long)numThreads);
        long startRow = minID;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < numThreads; ++i) {
            long endRow = startRow + numRowsPerThread;
            Thread thread = new Thread(new TableProcessor(t, where, sourceDB, destDB, columns, startRow, endRow, pageSize, counter));
            thread.setName("t" + i);
            threads.add(thread);
            thread.start();
            startRow = endRow + 1L;
        }
        Runnable statusLogger = new Runnable(){
            private String statusText = "000,000 records per second";

            @Override
            public void run() {
                long currTime = System.currentTimeMillis();
                double elapsedTime = (currTime - startTime) / 1000L;
                long recordsPerSecond = Math.round((double)counter.get() / elapsedTime);
                for (int i = 0; i < this.statusText.length(); ++i) {
                    System.out.print("\b");
                }
                this.statusText = DbUtils.pad(DbUtils.format(recordsPerSecond)) + " records per second";
                System.out.print(this.statusText);
            }
        };
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(statusLogger, 0L, 1L, TimeUnit.SECONDS);
        while (true) {
            try {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        executor.shutdown();
        threads.clear();
        if (destDB.getDriver().equals((Object)"PostgreSQL")) {
            try {
                conn = destDB.getConnection();
                conn.execute("SELECT setval('" + tableName + "_id_seq', (SELECT MAX(id) FROM " + t + "));");
                conn.close();
            }
            catch (Exception e) {
                if (conn != null) {
                    conn.close();
                }
                e.printStackTrace();
            }
        }
        System.out.println("\r\nProcessed " + DbUtils.format(counter.get()) + " records in " + DbUtils.format((System.currentTimeMillis() - startTime) / 1000L) + " seconds");
    }

    private static Long getLastRowID(String tableName, String where, Database destDB) {
        Long id;
        block3: {
            id = null;
            Connection c2 = null;
            try {
                c2 = destDB.getConnection();
                Recordset rs = new Recordset();
                rs.open("select max(id) from " + tableName + (where == null ? "" : " where " + where), c2);
                if (!rs.EOF) {
                    id = rs.getValue(0).toLong();
                }
                rs.close();
                c2.close();
            }
            catch (Exception e) {
                if (c2 == null) break block3;
                c2.close();
            }
        }
        return id;
    }

    public static void findMismatch(String tableName, Database sourceDB, Database destDB, int pageSize, long offset, AtomicLong rowID) {
        Connection c1 = null;
        Connection c2 = null;
        try {
            Long destCount;
            Long sourceCount;
            c1 = sourceDB.getConnection();
            c2 = destDB.getConnection();
            Recordset r1 = new Recordset();
            Recordset r2 = new Recordset();
            boolean foundMismatch = false;
            while (true) {
                sourceCount = null;
                destCount = null;
                String sql = "select count(id) from " + tableName + " where id>=" + offset + " and id<" + (offset + (long)pageSize);
                r1.open(sql, c1);
                if (!r1.EOF) {
                    sourceCount = r1.getValue(0).toLong();
                }
                r1.close();
                r2.open(sql, c2);
                if (!r2.EOF) {
                    destCount = r2.getValue(0).toLong();
                }
                r2.close();
                if (sourceCount == null || sourceCount == null) break;
                if (!sourceCount.equals(destCount)) {
                    foundMismatch = true;
                    break;
                }
                offset += (long)pageSize;
            }
            if (foundMismatch) {
                if (sourceCount == null) {
                    sourceCount = 0L;
                }
                if (destCount == null) {
                    destCount = 0L;
                }
                long delta = sourceCount - destCount;
                if (pageSize > 1) {
                    offset -= (long)pageSize;
                    if ((pageSize = Math.round(pageSize / 10)) < 1) {
                        pageSize = 1;
                    }
                    DbUtils.findMismatch(tableName, sourceDB, destDB, pageSize, offset, rowID);
                } else {
                    rowID.set(offset);
                }
            }
            c1.close();
            c2.close();
        }
        catch (Exception e) {
            if (c1 != null) {
                c1.close();
            }
            if (c2 != null) {
                c2.close();
            }
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDuplicates(String tableName, Database database, Long startRow, Long endRow, int pageSize, int numThreads) {
        if (!database.getDriver().equals((Object)"PostgreSQL")) {
            throw new IllegalArgumentException(database.getDriver().getVendor() + " not supported");
        }
        final long startTime = System.currentTimeMillis();
        final AtomicLong dupCounter = new AtomicLong(0L);
        final AtomicLong recordCounter = new AtomicLong(0L);
        LinkedList dups = new LinkedList();
        long minID = 0L;
        long maxID = 0L;
        Connection conn = null;
        try {
            conn = database.getConnection();
            Recordset rs = new Recordset();
            rs.open("select min(id), max(id) from " + tableName, conn);
            if (!rs.EOF) {
                minID = rs.getValue(0).toLong();
                maxID = rs.getValue(1).toLong();
            }
            rs.close();
            if (startRow != null && startRow > minID) {
                minID = startRow;
            }
            if (endRow != null && endRow < maxID) {
                maxID = endRow;
            }
            conn.close();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            e.printStackTrace();
        }
        Thread dupProcessor = new Thread(new DupProcessor(tableName, database, dups));
        dupProcessor.start();
        long diff = maxID - minID;
        long numRowsPerThread = Math.round(diff / (long)numThreads);
        startRow = minID;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < numThreads; ++i) {
            endRow = startRow + numRowsPerThread;
            System.out.println(i + ":\t" + startRow + "-" + endRow);
            Thread thread = new Thread(new DupFinder(tableName, database, startRow, endRow, pageSize, dupCounter, recordCounter, dups));
            threads.add(thread);
            thread.start();
            startRow = endRow;
        }
        Runnable statusLogger = new Runnable(){
            private String statusText = "Found 000,000,000 records at 000,000,000,000 records per second";

            @Override
            public void run() {
                long currTime = System.currentTimeMillis();
                double elapsedTime = (currTime - startTime) / 1000L;
                long recordsPerSecond = Math.round((double)recordCounter.get() / elapsedTime);
                for (int i = 0; i < this.statusText.length(); ++i) {
                    System.out.print("\b");
                }
                this.statusText = DbUtils.pad(DbUtils.format(dupCounter.get())) + " records at " + DbUtils.pad(DbUtils.format(recordsPerSecond)) + " records per second";
                System.out.print(this.statusText);
            }
        };
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(statusLogger, 0L, 1L, TimeUnit.SECONDS);
        while (true) {
            try {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        LinkedList e = dups;
        synchronized (e) {
            dups.add(null);
            dups.notify();
        }
        while (true) {
            try {
                dupProcessor.join();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
        executor.shutdown();
        threads.clear();
        System.out.println("\r\nProcessed " + DbUtils.format(recordCounter.get()) + " records in " + DbUtils.format((System.currentTimeMillis() - startTime) / 1000L) + " seconds");
        System.out.println("Deleted " + DbUtils.format(dupCounter.get()) + " duplicates");
    }

    public static JSONObject getJson(Recordset rs) {
        JSONObject json = new JSONObject();
        for (Field field : rs.getFields()) {
            String fieldName = field.getName().toLowerCase();
            fieldName = StringUtils.underscoreToCamelCase(fieldName);
            Value val = field.getValue();
            if (!val.isNull()) {
                String packageName;
                Object obj = val.toObject();
                Class<?> cls = obj.getClass();
                String className = cls.getSimpleName();
                Package pkg = cls.getPackage();
                String string = packageName = pkg == null ? "" : pkg.getName();
                if (packageName.equals("java.lang") && className.equals("String") || !packageName.startsWith("java")) {
                    String s = obj.toString().trim();
                    if (s.startsWith("{") && s.endsWith("}")) {
                        try {
                            val = new Value((Object)new JSONObject(s));
                        }
                        catch (Exception exception) {}
                    } else if (s.startsWith("[") && s.endsWith("]")) {
                        try {
                            val = new Value((Object)new JSONArray(s));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (packageName.equals("org.h2.api") && className.equals("TimestampWithTimeZone")) {
                    val = new Value((Object)val.toDate());
                }
            }
            json.set(fieldName, (Object)val);
        }
        return json;
    }

    private static String format(long l) {
        return NumberFormat.getNumberInstance(Locale.US).format(l);
    }

    private static String pad(String s) {
        while (s.length() < 7) {
            s = " " + s;
        }
        return s;
    }

    private static class DupProcessor
    implements Runnable {
        private String tableName;
        private Database database;
        private List dups;

        public DupProcessor(String tableName, Database database, List dups) {
            this.tableName = tableName;
            this.database = database;
            this.dups = dups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection conn;
            try {
                conn = this.database.getConnection();
            }
            catch (Exception e) {
                return;
            }
            ArrayList<String> stmts = new ArrayList<String>(1000);
            while (true) {
                Object obj = null;
                List list = this.dups;
                synchronized (list) {
                    while (this.dups.isEmpty()) {
                        try {
                            this.dups.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    obj = this.dups.get(0);
                    if (obj != null) {
                        this.dups.remove(0);
                    }
                    this.dups.notifyAll();
                }
                if (obj == null) break;
                Object[] arr = obj;
                long id = (Long)arr[0];
                String ctid = (String)arr[1];
                String stmt = "delete from " + this.tableName + " where id=" + id + " and ctid<>'" + ctid + "'";
                stmts.add(stmt);
                if (stmts.size() < 1000) continue;
                this.executeBatch(stmts, conn);
            }
            this.executeBatch(stmts, conn);
            conn.close();
        }

        private void executeBatch(ArrayList<String> stmts, Connection conn) {
            if (!stmts.isEmpty()) {
                try {
                    StringBuilder str = new StringBuilder();
                    str.append("BEGIN;\n");
                    for (String stmt : stmts) {
                        str.append(stmt);
                        str.append(";\n");
                    }
                    str.append("END;\n");
                    conn.execute(str.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                stmts.clear();
            }
        }
    }

    private static class DupFinder
    implements Runnable {
        private String tableName;
        private Database database;
        private long startRow;
        private long endRow;
        private int pageSize;
        private AtomicLong dupCounter;
        private AtomicLong recordCounter;
        private List dups;

        public DupFinder(String tableName, Database database, long startRow, long endRow, int pageSize, AtomicLong dupCounter, AtomicLong recordCounter, List dups) {
            this.tableName = tableName;
            this.database = database;
            this.pageSize = pageSize;
            this.dupCounter = dupCounter;
            this.recordCounter = recordCounter;
            this.startRow = startRow;
            this.endRow = endRow;
            this.dups = dups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection conn;
            try {
                conn = this.database.getConnection();
            }
            catch (Exception e) {
                return;
            }
            int maxPoolSize = 5000;
            try {
                Recordset rs = new Recordset();
                while (this.startRow < this.endRow) {
                    String sql = "SELECT MIN(ctid) as ctid, id FROM " + this.tableName + " WHERE ID>" + this.startRow + " AND ID<=" + (this.startRow + (long)this.pageSize) + " GROUP BY id HAVING COUNT(*) > 1";
                    rs.setFetchSize(1000);
                    rs.open(sql, conn);
                    if (rs.EOF) {
                        this.startRow += (long)this.pageSize;
                    } else {
                        while (rs.hasNext()) {
                            long id = rs.getValue("id").toLong();
                            String ctid = rs.getValue("ctid").toString();
                            if (id > this.endRow) {
                                this.startRow = this.endRow;
                                break;
                            }
                            List list = this.dups;
                            synchronized (list) {
                                while (this.dups.size() > maxPoolSize) {
                                    try {
                                        this.dups.wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                        break;
                                    }
                                }
                                this.dups.add(new Object[]{id, ctid});
                                this.dups.notify();
                            }
                            this.dupCounter.incrementAndGet();
                            this.startRow = id;
                            rs.moveNext();
                        }
                        rs.close();
                    }
                    this.recordCounter.addAndGet(this.pageSize);
                }
                conn.close();
            }
            catch (Exception e) {
                if (conn != null) {
                    conn.close();
                }
                e.printStackTrace();
            }
        }
    }

    private static class TableProcessor
    implements Runnable {
        private String tableName;
        private Database sourceDB;
        private Database destDB;
        private int pageSize;
        private AtomicLong counter;
        private long startRow;
        private long endRow;
        private String where;
        private LinkedHashMap<String, Boolean> columns;
        private String columnNames;
        private boolean hasGeometry = false;

        public TableProcessor(String tableName, String where, Database sourceDB, Database destDB, LinkedHashMap<String, Boolean> columns, long startRow, long endRow, int pageSize, AtomicLong counter) {
            this.tableName = tableName;
            this.sourceDB = sourceDB;
            this.destDB = destDB;
            this.columns = columns;
            this.pageSize = pageSize;
            this.counter = counter;
            this.startRow = startRow;
            this.endRow = endRow;
            this.where = where;
            this.columnNames = "";
            Iterator<String> it = columns.keySet().iterator();
            while (it.hasNext()) {
                String columnName = it.next();
                if (columns.get(columnName).booleanValue()) {
                    this.hasGeometry = true;
                    this.columnNames = this.columnNames + "ST_AsText(" + columnName + ") as " + columnName;
                } else {
                    this.columnNames = this.columnNames + columnName;
                }
                if (!it.hasNext()) continue;
                this.columnNames = this.columnNames + ", ";
            }
        }

        @Override
        public void run() {
            Connection c1 = null;
            Connection c2 = null;
            try {
                int x;
                c1 = this.sourceDB.getConnection();
                c2 = this.destDB.getConnection();
                try {
                    long orgStart = this.startRow;
                    String sql = "SELECT max(id) FROM " + this.tableName + " WHERE " + (this.where == null ? "" : "(" + this.where + ") AND ") + "ID>" + this.startRow + " AND ID<" + this.endRow;
                    Recordset rs = new Recordset();
                    rs.open(sql, c2);
                    if (!rs.EOF && !rs.getValue(0).isNull()) {
                        this.startRow = rs.getValue(0).toLong();
                    }
                    rs.close();
                }
                catch (Exception e) {
                    if (c1 != null) {
                        c1.close();
                    }
                    if (c2 != null) {
                        c2.close();
                    }
                    e.printStackTrace();
                    return;
                }
                boolean unlog = false;
                if (this.sourceDB.getDriver().equals((Object)"PostgreSQL")) {
                    // empty if block
                }
                Recordset r2 = new Recordset();
                r2.open("select * from " + this.tableName + " where id=-1", c2, false);
                r2.setBatchSize(1);
                Recordset rs = new Recordset();
                do {
                    x = 0;
                    String sql = "SELECT " + (this.hasGeometry ? this.columnNames : "*") + " FROM " + this.tableName + " WHERE ID>=" + this.startRow + " ORDER BY ID LIMIT " + this.pageSize;
                    if (this.where != null) {
                        sql = "SELECT " + (this.hasGeometry ? this.columnNames : "*") + " FROM " + this.tableName + " WHERE ID>=" + this.startRow + " AND ID<=" + this.endRow + " AND " + this.where + " ORDER BY ID LIMIT " + this.pageSize;
                    }
                    rs.setFetchSize(1000);
                    rs.open(sql, c1);
                    while (rs.hasNext()) {
                        long id;
                        block21: {
                            id = rs.getValue("id").toLong();
                            if (id > this.endRow) {
                                this.startRow = this.endRow;
                                break;
                            }
                            r2.addNew();
                            for (Field field : rs.getFields()) {
                                String fieldName = field.getName();
                                boolean isGeometry = this.columns.get(fieldName.toLowerCase());
                                if (isGeometry) {
                                    r2.setValue(fieldName, (Object)new Function("ST_GeomFromText(?, 4326)", new Object[]{rs.getValue(fieldName).toString()}));
                                    continue;
                                }
                                r2.setValue(fieldName, rs.getValue(fieldName));
                            }
                            try {
                                r2.update();
                            }
                            catch (SQLException e) {
                                if (rs.getBatchSize() <= 1) break block21;
                                throw e;
                            }
                        }
                        ++x;
                        this.startRow = id;
                        this.counter.getAndIncrement();
                        rs.moveNext();
                    }
                    rs.close();
                } while (x >= this.pageSize);
                r2.close();
                if (unlog) {
                    try {
                        c2.execute("alter table " + this.tableName + "SET LOGGED");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c1.close();
                c2.close();
            }
            catch (Exception e) {
                if (c1 != null) {
                    c1.close();
                }
                if (c2 != null) {
                    c2.close();
                }
                throw new RuntimeException(e);
            }
        }
    }
}

