/*
 * Decompiled with CFR 0.152.
 */
package javaxt.express.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private StringUtils() {
    }

    public static String camelCaseToUnderScore(String input) {
        StringBuffer result = new StringBuffer();
        boolean begin = true;
        boolean lastUppercase = false;
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (begin) {
                    result.append(ch);
                } else if (lastUppercase) {
                    if (i + 1 < input.length()) {
                        char next = input.charAt(i + 1);
                        if (Character.isUpperCase(next)) {
                            result.append(ch);
                        } else {
                            result.append('_').append(ch);
                        }
                    } else {
                        result.append(ch);
                    }
                } else {
                    result.append('_').append(ch);
                }
                lastUppercase = true;
            } else {
                result.append(Character.toUpperCase(ch));
                lastUppercase = false;
            }
            begin = false;
        }
        return result.toString().toLowerCase();
    }

    public static String underscoreToCamelCase(String input) {
        Pattern p = Pattern.compile("_(.)");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        String str = sb.toString();
        if (str.endsWith("Id") && input.toLowerCase().endsWith("_id")) {
            str = str.substring(0, str.length() - 2) + "ID";
        }
        return str;
    }

    public static String capitalize(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }
}

