/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javaxt.http.servlet.FormInput;
import javaxt.http.servlet.FormValue;
import javaxt.http.servlet.HttpServlet;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.http.servlet.ServletContext;
import javaxt.http.servlet.ServletException;
import javaxt.http.websocket.WebSocketListener;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class Server
extends Thread {
    private static int numThreads;
    private InetSocketAddress[] addresses;
    private HttpServlet servlet;
    private static HttpServlet exceptionServlet;
    private Double tlsVersion = 1.0;
    public static boolean debug;

    public Server(int port, int numThreads, HttpServlet servlet) {
        this(new InetSocketAddress(port), numThreads, servlet);
    }

    public Server(InetSocketAddress address, int numThreads, HttpServlet servlet) {
        this(new InetSocketAddress[]{address}, numThreads, servlet);
    }

    public Server(InetSocketAddress[] addresses, int numThreads, HttpServlet servlet) {
        this.addresses = addresses;
        Server.numThreads = numThreads;
        this.servlet = servlet;
    }

    public Server(List<InetSocketAddress> addresses, int numThreads, HttpServlet servlet) {
        this(addresses.toArray(new InetSocketAddress[addresses.size()]), numThreads, servlet);
    }

    public void setMinTLSVersion(Double tlsVersion) {
        this.tlsVersion = tlsVersion == null ? null : (tlsVersion >= 1.0 && tlsVersion <= 1.2 ? tlsVersion : null);
    }

    public static void main(String[] args) throws Exception {
        File dir = null;
        InetSocketAddress[] addresses = null;
        File keystore = null;
        String keypass = null;
        if (args.length > 0) {
            if (args.length == 1) {
                addresses = Server.getAddresses(args[0]);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    String val;
                    String key = args[i];
                    if (!key.startsWith("-")) continue;
                    String string = val = i < args.length - 1 ? args[i + 1] : null;
                    if (val == null || val.startsWith("-")) continue;
                    ++i;
                    if (key.startsWith("-p")) {
                        addresses = Server.getAddresses(val);
                        continue;
                    }
                    if (key.startsWith("-debug")) {
                        if (!val.equalsIgnoreCase("true")) continue;
                        debug = true;
                        continue;
                    }
                    if (key.startsWith("-dir")) {
                        File f = new File(val);
                        if (!f.exists()) continue;
                        if (f.isFile()) {
                            f = f.getParentFile();
                        }
                        dir = f;
                        continue;
                    }
                    if (key.startsWith("-keystore")) {
                        keystore = new File(val);
                        continue;
                    }
                    if (!key.startsWith("-keypass")) continue;
                    keypass = val;
                }
            }
        }
        if (addresses == null) {
            addresses = new InetSocketAddress[]{new InetSocketAddress(80), new InetSocketAddress(443)};
        }
        Server webserver = new Server(addresses, 250, (HttpServlet)new ServletTest(dir, keystore, keypass));
        webserver.start();
    }

    private static InetSocketAddress[] getAddresses(String str) throws IllegalArgumentException {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String s : str.split(",")) {
            try {
                int port = Integer.parseInt(s);
                if (port < 0 || port > 65535) {
                    throw new Exception();
                }
                addresses.add(new InetSocketAddress(port));
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
        }
        return addresses.toArray(new InetSocketAddress[addresses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConcurrentMap<String, Logger> loggers;
        Log serverLog = new Log();
        org.eclipse.jetty.util.log.Log.setLog(serverLog);
        ConcurrentMap<String, Logger> concurrentMap = loggers = org.eclipse.jetty.util.log.Log.getMutableLoggers();
        synchronized (concurrentMap) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String string : loggers.keySet()) {
                Logger logger = (Logger)loggers.get(string);
                if (logger instanceof Log) continue;
                keys.add(string);
            }
            if (!keys.isEmpty()) {
                for (String string : keys) {
                    loggers.put(string, serverLog);
                }
                loggers.notifyAll();
            }
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(numThreads);
        org.eclipse.jetty.server.Server server = new org.eclipse.jetty.server.Server(threadPool);
        server.setHandler(new RequestHandler(this.servlet));
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setBlockingTimeout(30000L);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        for (InetSocketAddress address : this.addresses) {
            String hostName = address.getHostName();
            try {
                ServerConnector http;
                HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfig);
                SSLContext sslContext = this.servlet.getSSLContext();
                if (sslContext != null) {
                    SslContextFactory sslContextFactory = new SslContextFactory();
                    if (this.tlsVersion != null && this.tlsVersion < 1.2) {
                        sslContextFactory.setExcludeCipherSuites("SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
                    }
                    sslContextFactory.setSslContext(sslContext);
                    _SslConnectionFactory ssl = new _SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
                    HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
                    http = new ServerConnector(server, ssl, new HttpConnectionFactory(httpsConfig));
                } else {
                    http = new ServerConnector(server, http1);
                }
                http.setHost(hostName);
                http.setPort(address.getPort());
                http.setIdleTimeout(30000L);
                server.addConnector(http);
                System.out.print("Accepting connections on " + hostName + ":" + address.getPort() + "\r\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            server.start();
            server.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object obj) {
        String str;
        if (!debug) {
            return;
        }
        String md = "[" + Server.getTime() + "] ";
        String padding = "";
        for (int i = 0; i < md.length(); ++i) {
            padding = padding + " ";
        }
        if (obj instanceof String) {
            str = (String)obj;
            if (str.length() > 0) {
                String[] arr = str.split("\n");
                for (int i = 0; i < arr.length; ++i) {
                    str = i == 0 ? md + arr[i].trim() + "\r\n" : str + padding + arr[i].trim() + "\r\n";
                }
                str = str.trim();
            }
        } else if (obj instanceof Exception) {
            str = md + obj;
            ((Exception)obj).printStackTrace();
        } else {
            str = md + obj;
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(str);
        }
    }

    private static String getTime() {
        Date d = new Date();
        return Server.pad(d.getHours()) + ":" + Server.pad(d.getMinutes()) + ":" + Server.pad(d.getSeconds());
    }

    private static String pad(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return i + "";
    }

    static {
        exceptionServlet = new ExceptionServlet();
        debug = false;
    }

    private static class SessionStore
    extends AbstractSessionDataStore {
        private SessionStore() {
        }

        @Override
        public SessionData load(String id) throws Exception {
            return null;
        }

        @Override
        public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
            return new SessionData(id, this._context.getCanonicalContextPath(), this._context.getVhost(), created, accessed, lastAccessed, maxInactiveMs);
        }

        @Override
        public boolean delete(String id) throws Exception {
            return true;
        }

        @Override
        public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        }

        @Override
        public Set<String> doGetExpired(Set<String> candidates) {
            return candidates;
        }

        @Override
        public boolean isPassivating() {
            return false;
        }

        @Override
        public boolean exists(String id) {
            return false;
        }
    }

    @ManagedObject(value="JavaXT Logging Implementation")
    private static class Log
    extends AbstractLogger {
        private final String _name;

        public Log() {
            this(null);
        }

        public Log(String name) {
            this(name, null);
        }

        public Log(String name, Properties props) {
            this._name = name == null ? "" : name;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public void setPrintLongNames(boolean printLongNames) {
        }

        public boolean isPrintLongNames() {
            return false;
        }

        public void setHideStacks(boolean hideStacks) {
        }

        public boolean isHideStacks() {
            return true;
        }

        public void setSource(boolean source) {
        }

        public boolean isSource() {
            return false;
        }

        @Override
        public void ignore(Throwable ignored) {
        }

        @Override
        public void warn(String msg, Object ... args) {
        }

        @Override
        public void warn(Throwable thrown) {
        }

        @Override
        public void warn(String msg, Throwable thrown) {
        }

        @Override
        public void info(String msg, Object ... args) {
        }

        @Override
        public void info(Throwable thrown) {
        }

        @Override
        public void info(String msg, Throwable thrown) {
        }

        @Override
        public void debug(String msg, Object ... args) {
        }

        @Override
        public void debug(String msg, long arg) {
        }

        @Override
        public void debug(Throwable thrown) {
        }

        @Override
        public void debug(String msg, Throwable thrown) {
        }

        @Override
        public void setDebugEnabled(boolean enabled) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        public void setLevel(int level) {
        }

        public int getLevel() {
            return 0;
        }

        public void setStdErrStream(PrintStream stream) {
        }

        protected void format(StringBuilder buffer, Throwable thrown) {
        }

        protected void format(StringBuilder buffer, Throwable thrown, String indent) {
        }

        public static int getLoggingLevel(Properties props, String name) {
            return Log.lookupLoggingLevel(props, name);
        }

        public static Log getLogger(Class<?> clazz) {
            Log log = Log.getLogger(clazz);
            if (log instanceof Log) {
                return log;
            }
            throw new RuntimeException("Invalid logger for " + clazz);
        }

        @Override
        protected Log newLogger(String fullname) {
            return new Log(fullname);
        }

        public String toString() {
            return "";
        }
    }

    private class _SslConnectionFactory
    extends AbstractConnectionFactory {
        private final SslContextFactory _sslContextFactory;
        private final String _nextProtocol;

        public _SslConnectionFactory() {
            this(HttpVersion.HTTP_1_1.asString());
        }

        public _SslConnectionFactory(String nextProtocol) {
            this((SslContextFactory)null, nextProtocol);
        }

        public _SslConnectionFactory(@Name(value="next") SslContextFactory factory, String nextProtocol) {
            super("SSL");
            this._sslContextFactory = factory == null ? new SslContextFactory() : factory;
            this._nextProtocol = nextProtocol;
            this.addBean(this._sslContextFactory);
        }

        public SslContextFactory getSslContextFactory() {
            return this._sslContextFactory;
        }

        @Override
        protected void doStart() throws Exception {
            super.doStart();
            SSLEngine engine = this._sslContextFactory.newSSLEngine();
            engine.setUseClientMode(false);
            SSLSession session = engine.getSession();
            if (session.getPacketBufferSize() > this.getInputBufferSize()) {
                this.setInputBufferSize(session.getPacketBufferSize());
            }
        }

        @Override
        public Connection newConnection(Connector connector, EndPoint realEndPoint) {
            EndPoint plainEndpoint;
            SslConnection sslConnection;
            ReadAheadEndpoint aheadEndpoint = new ReadAheadEndpoint(realEndPoint, 1);
            byte[] bytes = aheadEndpoint.getBytes();
            boolean isSSL = false;
            if (bytes == null || bytes.length == 0) {
                isSSL = true;
            } else {
                byte b = bytes[0];
                boolean bl = isSSL = b >= 127 || b < 32 && b != 10 && b != 13 && b != 9;
            }
            if (isSSL) {
                SSLEngine engine = this._sslContextFactory.newSSLEngine(aheadEndpoint.getRemoteAddress());
                engine.setUseClientMode(false);
                sslConnection = this.newSslConnection(connector, aheadEndpoint, engine);
                sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
                this.configure(sslConnection, connector, aheadEndpoint);
                plainEndpoint = sslConnection.getDecryptedEndPoint();
            } else {
                sslConnection = null;
                plainEndpoint = aheadEndpoint;
            }
            ConnectionFactory next = connector.getConnectionFactory(this._nextProtocol);
            Connection connection = next.newConnection(connector, plainEndpoint);
            plainEndpoint.setConnection(connection);
            return sslConnection == null ? connection : sslConnection;
        }

        protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
            return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, engine);
        }

        @Override
        public String toString() {
            return String.format("%s@%x{%s->%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this._nextProtocol);
        }

        private class ReadAheadEndpoint
        implements EndPoint {
            private final EndPoint endPoint;
            private final ByteBuffer start;
            private int leftToRead;
            private final byte[] bytes;
            private IOException pendingException = null;

            @Override
            public InetSocketAddress getLocalAddress() {
                return this.endPoint.getLocalAddress();
            }

            @Override
            public InetSocketAddress getRemoteAddress() {
                return this.endPoint.getRemoteAddress();
            }

            @Override
            public boolean isOpen() {
                return this.endPoint.isOpen();
            }

            @Override
            public long getCreatedTimeStamp() {
                return this.endPoint.getCreatedTimeStamp();
            }

            @Override
            public boolean isOutputShutdown() {
                return this.endPoint.isOutputShutdown();
            }

            @Override
            public boolean isInputShutdown() {
                return this.endPoint.isInputShutdown();
            }

            @Override
            public void shutdownOutput() {
                this.endPoint.shutdownOutput();
            }

            @Override
            public void close() {
                this.endPoint.close();
            }

            @Override
            public Object getTransport() {
                return this.endPoint.getTransport();
            }

            @Override
            public long getIdleTimeout() {
                return this.endPoint.getIdleTimeout();
            }

            @Override
            public Connection getConnection() {
                return this.endPoint.getConnection();
            }

            @Override
            public void onOpen() {
                this.endPoint.onOpen();
            }

            @Override
            public void onClose() {
                this.endPoint.onClose();
            }

            @Override
            public boolean isOptimizedForDirectBuffers() {
                return this.endPoint.isOptimizedForDirectBuffers();
            }

            @Override
            public boolean isFillInterested() {
                return this.endPoint.isFillInterested();
            }

            @Override
            public boolean flush(ByteBuffer ... v) throws IOException {
                return this.endPoint.flush(v);
            }

            @Override
            public void setIdleTimeout(long v) {
                this.endPoint.setIdleTimeout(v);
            }

            @Override
            public void write(Callback v, ByteBuffer ... b) throws WritePendingException {
                this.endPoint.write(v, b);
            }

            @Override
            public void setConnection(Connection v) {
                this.endPoint.setConnection(v);
            }

            @Override
            public void upgrade(Connection v) {
                this.endPoint.upgrade(v);
            }

            @Override
            public void fillInterested(Callback v) throws ReadPendingException {
                this.endPoint.fillInterested(v);
            }

            @Override
            public boolean tryFillInterested(Callback v) {
                return this.endPoint.tryFillInterested(v);
            }

            public int hashCode() {
                return this.endPoint.hashCode();
            }

            public boolean equals(Object obj) {
                return this.endPoint.equals(obj);
            }

            public String toString() {
                return this.endPoint.toString();
            }

            public byte[] getBytes() {
                if (this.pendingException == null) {
                    try {
                        this.readAhead();
                    }
                    catch (IOException e) {
                        this.pendingException = e;
                    }
                }
                return this.bytes;
            }

            private void throwPendingException() throws IOException {
                if (this.pendingException != null) {
                    IOException e = this.pendingException;
                    this.pendingException = null;
                    throw e;
                }
            }

            public ReadAheadEndpoint(EndPoint channel, int readAheadLength) {
                this.endPoint = channel;
                this.bytes = new byte[readAheadLength];
                this.start = ByteBuffer.wrap(this.bytes);
                this.start.flip();
                this.leftToRead = readAheadLength;
            }

            private synchronized void readAhead() throws IOException {
                if (this.leftToRead > 0) {
                    int numBytesRead = this.endPoint.fill(this.start);
                    int numRetries = 0;
                    if (numBytesRead == 0) {
                        while ((numBytesRead = this.endPoint.fill(this.start)) < 1) {
                            if (numBytesRead == -1) {
                                throw new IOException("Received -1 bytes. Socket is closed.");
                            }
                            if (++numRetries > 15000) {
                                throw new IOException("Timeout waiting for bytes from the client.");
                            }
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                throw new IOException("Interrupt!");
                            }
                        }
                    }
                    if (numBytesRead == -1) {
                        throw new IOException("Received -1 bytes. Socket is closed.");
                    }
                    this.leftToRead -= numBytesRead;
                    if (this.leftToRead <= 0) {
                        this.start.rewind();
                    }
                }
            }

            private int readFromStart(ByteBuffer dst) throws IOException {
                int n = Math.min(dst.remaining(), this.start.remaining());
                if (n > 0) {
                    dst.put(this.bytes, this.start.position(), n);
                    this.start.position(this.start.position() + n);
                    dst.flip();
                }
                return n;
            }

            @Override
            public synchronized int fill(ByteBuffer dst) throws IOException {
                this.throwPendingException();
                if (this.leftToRead > 0) {
                    this.readAhead();
                }
                if (this.leftToRead > 0) {
                    return 0;
                }
                int sr = this.start.remaining();
                if (sr > 0) {
                    dst.compact();
                    int n = this.readFromStart(dst);
                    if (n < sr) {
                        return n;
                    }
                }
                return sr + this.endPoint.fill(dst);
            }
        }
    }

    private static class RequestHandler
    extends AbstractHandler {
        private final HttpServlet servlet;
        private SessionHandler sessionHandler;
        private SessionDataStore sessionStore;

        private RequestHandler(HttpServlet servlet) {
            this(servlet, (SessionDataStore)null);
        }

        private RequestHandler(HttpServlet servlet, SessionDataStore sessionStore) {
            this.servlet = servlet;
            this.sessionStore = sessionStore;
        }

        @Override
        public void doStart() throws Exception {
            ContextHandler.Context context = ContextHandler.getCurrentContext();
            ContextHandler.StaticContext servletContext = context == null ? new ContextHandler.StaticContext() : context;
            servletContext.setAttribute("org.eclipse.jetty.server.Handler", this);
            this.servlet.setServletContext(new ServletContext(servletContext));
            String jettyVersion = servletContext.getServerInfo();
            String javaxtVersion = this.servlet.getServletContext().getServerInfo();
            this.sessionHandler = new SessionHandler();
            DefaultSessionCache sessionCache = new DefaultSessionCache(this.sessionHandler);
            if (this.sessionStore == null) {
                this.sessionStore = new SessionStore();
            }
            sessionCache.setSessionDataStore(this.sessionStore);
            this.sessionHandler.setSessionCache(sessionCache);
            try {
                org.eclipse.jetty.server.Server server = this.getServer();
                this.sessionHandler.setServer(server);
                this.sessionHandler.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object ServletConfig2 = null;
            this.servlet.init(ServletConfig2);
            super.doStart();
        }

        @Override
        public void handle(String target, Request baseRequest, javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws IOException, javax.servlet.ServletException {
            request.setAttribute("org.eclipse.jetty.server.Request", baseRequest);
            request.setAttribute("javax.servlet.http.HttpServletRequest", request);
            request.setAttribute("javax.servlet.http.HttpServletResponse", response);
            baseRequest.setSessionHandler(this.sessionHandler);
            EndPoint endPoint = baseRequest.getHttpChannel().getEndPoint();
            if (endPoint instanceof SslConnection.DecryptedEndPoint) {
                baseRequest.setScheme("https");
                baseRequest.setSecure(true);
            } else {
                baseRequest.setScheme("http");
                baseRequest.setSecure(false);
            }
            HttpServletRequest _request = new HttpServletRequest(request, this.servlet);
            HttpServletResponse _response = new HttpServletResponse(_request, response);
            try {
                this.servlet.processRequest(_request, _response);
                baseRequest.setHandled(true);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                this.sendError(e, _request, _response, request, response);
                baseRequest.setHandled(true);
            }
            catch (Throwable e) {
                String s = e.getClass().getName();
                String message = e.getLocalizedMessage();
                s = message != null ? s + ": " + message : s;
                ServletException ex = new ServletException(500, s);
                ex.setStackTrace(e.getStackTrace());
                this.sendError(ex, _request, _response, request, response);
            }
        }

        private void sendError(ServletException e, HttpServletRequest request, HttpServletResponse response, javax.servlet.http.HttpServletRequest req, javax.servlet.http.HttpServletResponse rsp) {
            Server.log(e.getMessage());
            try {
                if (request == null) {
                    request = new HttpServletRequest(req, exceptionServlet);
                    response = new HttpServletResponse(request, rsp);
                } else if (response == null) {
                    response = new HttpServletResponse(request, rsp);
                }
                response.setStatus(e.getStatusCode());
                response.setContentType("text/plain");
                String s = e.getClass().getName();
                s = s.substring(s.lastIndexOf(".") + 1);
                String message = e.getLocalizedMessage();
                String error = message != null ? s + ": " + message : s;
                for (StackTraceElement x : e.getStackTrace()) {
                    error = error + "\n" + x;
                }
                response.write(error);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void doStop() {
            this.servlet.destroy();
        }
    }

    private static class ServletTest
    extends HttpServlet {
        private final File dir;
        private final String s = System.getProperty("file.separator");

        public ServletTest(File dir, File keystore, String keypass) throws Exception {
            this.dir = dir;
            if (keystore != null) {
                try {
                    this.setKeyStore(keystore, keypass);
                    this.setTrustStore(keystore, keypass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void processRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.log();
            this.log("New Request From: " + request.getRemoteAddr());
            this.log("TimeStamp: " + new Date());
            this.log(request.getMethod() + ": " + request.getURL().toString());
            this.log();
            if (request.isWebSocket()) {
                new WebSocketListener(request, response){

                    @Override
                    public void onConnect() {
                        this.send("Hello There!");
                    }

                    @Override
                    public void onText(String str) {
                        this.send("Message recieved at " + new Date());
                    }

                    public void onDisconnect(int statusCode, String reason, boolean remote) {
                    }
                };
                return;
            }
            if (request.getMethod().equals("POST")) {
                boolean fileUploaded = false;
                StringBuilder str = new StringBuilder();
                HttpServletRequest.FormIterator it = request.getFormInputs();
                while (it.hasNext()) {
                    FormInput input = (FormInput)it.next();
                    String name = input.getName();
                    FormValue value = input.getValue();
                    str.append(name);
                    str.append(": ");
                    if (input.isFile()) {
                        value.toFile(new File(this.dir + this.s + "uploads" + this.s + input.getFileName()));
                        str.append(input.getFileName());
                        str.append("*");
                        fileUploaded = true;
                    } else {
                        str.append(value);
                    }
                    str.append("\r\n");
                }
                if (fileUploaded) {
                    str.append("\r\n* File uploaded to the uploads directory");
                }
                response.setContentType("text/plain");
                response.write(str.toString());
                return;
            }
            if (this.dir != null) {
                File file;
                String path = request.getURL().getPath();
                if (path.length() > 1 && path.startsWith("/")) {
                    path = path.substring(1);
                }
                if ((file = new File(this.dir + this.s + path)).exists() && file.isDirectory()) {
                    file = new File(file, "index.html");
                }
                if (!file.exists()) {
                    response.setStatus(404);
                } else {
                    String ext = null;
                    int x = file.getName().lastIndexOf(".");
                    if (x != -1) {
                        ext = file.getName().substring(x + 1).toLowerCase();
                    }
                    response.setBufferSize(64768);
                    response.write(file, this.getContentType(ext), true);
                }
            } else {
                try {
                    byte[] header = request.toString().getBytes("UTF-8");
                    byte[] body = request.getBody();
                    byte[] msg = new byte[header.length + body.length];
                    System.arraycopy(header, 0, msg, 0, header.length);
                    System.arraycopy(body, 0, msg, header.length, body.length);
                    header = null;
                    body = null;
                    response.setContentType("text/plain");
                    response.write(msg);
                    msg = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log(request.toString());
            this.log(response.toString());
        }

        private String getContentType(String ext) {
            if (ext != null) {
                if (ext.equals("css")) {
                    return "text/css";
                }
                if (ext.equals("htm") || ext.equals("html")) {
                    return "text/html";
                }
                if (ext.equals("js")) {
                    return "text/javascript";
                }
                if (ext.equals("txt")) {
                    return "text/plain";
                }
                if (ext.equals("gif")) {
                    return "image/gif";
                }
                if (ext.equals("jpg")) {
                    return "image/jpeg";
                }
                if (ext.equals("png")) {
                    return "image/png";
                }
                if (ext.equals("ico")) {
                    return "image/vnd.microsoft.icon";
                }
            }
            return "application/octet-stream";
        }

        public void log() {
            this.log("");
        }

        @Override
        public void log(String msg) {
            Server.log(msg);
        }
    }

    private static class ExceptionServlet
    extends HttpServlet {
        private ExceptionServlet() {
        }

        @Override
        public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        }
    }
}

