/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javaxt.http.servlet.Cookie;
import javaxt.http.servlet.HttpServlet;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.http.servlet.ServletException;
import javaxt.http.servlet.ServletInputStream;
import javaxt.http.servlet.ServletOutputStream;

public class CgiServlet
extends HttpServlet {
    private File executable;

    public CgiServlet(File executable) {
        this.executable = executable;
    }

    public String getServletInfo() {
        return "JavaXT CGI Servlet";
    }

    protected ArrayList<String> getParameters(HttpServletRequest request) {
        String authType;
        String remoteUser;
        String queryString;
        String pathTranslated;
        String pathInfo;
        String contentType;
        ArrayList<String> env = new ArrayList<String>();
        env.add("GATEWAY_INTERFACE=CGI/1.1");
        env.add("SERVER_SOFTWARE=" + this.getServletContext().getServerInfo());
        env.add("SERVER_PROTOCOL=" + request.getProtocol());
        env.add("SERVER_NAME=" + request.getServerName());
        env.add("SERVER_PORT=" + request.getServerPort());
        env.add("REMOTE_ADDR=" + request.getRemoteAddr());
        env.add("REMOTE_HOST=" + request.getRemoteHost());
        env.add("REQUEST_METHOD=" + request.getMethod());
        env.add("SCRIPT_NAME=" + request.getServletPath());
        int contentLength = request.getContentLength();
        if (contentLength != -1) {
            env.add("CONTENT_LENGTH=" + contentLength);
        }
        if ((contentType = request.getContentType()) != null) {
            env.add("CONTENT_TYPE=" + contentType);
        }
        if ((pathInfo = request.getPathInfo()) != null) {
            env.add("PATH_INFO=" + pathInfo);
        }
        if ((pathTranslated = request.getPathTranslated()) != null) {
            env.add("PATH_TRANSLATED=" + pathTranslated);
        }
        if ((queryString = request.getQueryString()) != null) {
            env.add("QUERY_STRING=" + queryString);
        }
        if ((remoteUser = request.getRemoteUser()) != null) {
            env.add("REMOTE_USER=" + remoteUser);
        }
        if ((authType = request.getAuthType()) != null) {
            env.add("AUTH_TYPE=" + authType);
        }
        Enumeration<String> hnEnum = request.getHeaderNames();
        while (hnEnum.hasMoreElements()) {
            String name = hnEnum.nextElement();
            String value = request.getHeader(name);
            if (value == null) {
                value = "";
            }
            env.add("HTTP_" + name.toUpperCase().replace('-', '_') + "=" + value);
        }
        return env;
    }

    @Override
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod().toUpperCase();
        if (!method.equals("GET") && !method.equals("POST")) {
            response.sendError(501);
            return;
        }
        ArrayList<String> env = this.getParameters(request);
        String[] parameters = new String[env.size() + 1];
        parameters[0] = this.executable.toString();
        for (int i = 0; i < parameters.length; ++i) {
            if (i <= 0) continue;
            parameters[i] = env.get(i - 1);
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(parameters, null, this.executable.getParentFile());
            if (method.equals("POST")) {
                OutputStream outputStream = process.getOutputStream();
                ServletInputStream inputStream = request.getInputStream();
                byte[] b = new byte[1024];
                int x = 0;
                while ((x = inputStream.read(b)) != -1) {
                    outputStream.write(b, 0, x);
                }
                inputStream.close();
                outputStream.close();
            }
            StreamReader s1 = new StreamReader(process.getInputStream(), response);
            ErrorStreamReader s2 = new ErrorStreamReader(process.getErrorStream());
            s1.start();
            s2.start();
            process.waitFor();
            s1.join();
            s2.join();
            try {
                process.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                process.getErrorStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                process.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                process.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            process = null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private class ErrorStreamReader
    implements Runnable {
        private InputStream is;
        private Thread thread;
        private byte[] b = new byte[1];

        public ErrorStreamReader(InputStream is) {
            this.is = is;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            try {
                while (this.is.read(this.b) != -1) {
                }
                this.is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        public void join() throws InterruptedException {
            this.thread.join();
        }
    }

    private class StreamReader
    implements Runnable {
        private InputStream is;
        private HttpServletResponse response;
        private Thread thread;
        private byte[] b = new byte[1];

        public StreamReader(InputStream is, HttpServletResponse response) {
            this.is = is;
            this.response = response;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            try {
                String line;
                boolean firstLine = true;
                while ((line = this.readLine()) != null && !(line = line.trim()).equals("")) {
                    int colon = line.indexOf(":");
                    if (colon == -1) {
                        if (!firstLine) continue;
                        StringTokenizer tok = new StringTokenizer(line, " ");
                        try {
                            switch (tok.countTokens()) {
                                case 2: {
                                    tok.nextToken();
                                    this.response.setStatus(Integer.parseInt(tok.nextToken()));
                                    break;
                                }
                                case 3: {
                                    tok.nextToken();
                                    this.response.setStatus(Integer.parseInt(tok.nextToken()), tok.nextToken());
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    String name = line.substring(0, colon);
                    String value = line.substring(colon + 1).trim();
                    if (name.equalsIgnoreCase("Status")) {
                        StringTokenizer tok = new StringTokenizer(value, " ");
                        try {
                            switch (tok.countTokens()) {
                                case 1: {
                                    this.response.setStatus(Integer.parseInt(tok.nextToken()));
                                    break;
                                }
                                case 2: {
                                    this.response.setStatus(Integer.parseInt(tok.nextToken()), tok.nextToken());
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("Content-type")) {
                        this.response.setContentType(value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("Content-length")) {
                        try {
                            this.response.setContentLength(Integer.parseInt(value));
                        }
                        catch (NumberFormatException tok) {}
                        continue;
                    }
                    if (name.equalsIgnoreCase("Location")) {
                        this.response.setStatus(302);
                        this.response.setHeader(name, value);
                        continue;
                    }
                    if (name.equalsIgnoreCase("Set-Cookie")) {
                        int x = value.indexOf("=");
                        if (x <= 0) continue;
                        String n = value.substring(0, x);
                        String v = value.substring(x + 1).trim();
                        this.response.addCookie(new Cookie(n, v));
                        continue;
                    }
                    this.response.setHeader(name, value);
                }
                this.response.setHeader("Transfer-Encoding", "Chunked");
                ServletOutputStream outputStream = this.response.getOutputStream();
                byte[] b = new byte[1024];
                int x = 0;
                while ((x = this.is.read(b)) != -1) {
                    outputStream.write(b, 0, x);
                }
                ((OutputStream)outputStream).close();
                this.is.close();
            }
            catch (IOException firstLine) {
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        private String readLine() throws IOException {
            byte c;
            StringBuffer str = new StringBuffer();
            while (this.is.read(this.b) != -1 && (c = this.b[0]) != 10) {
                str.append((char)c);
            }
            return str.toString();
        }

        public void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

