/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import javaxt.http.servlet.FormValue;
import javaxt.http.servlet.ServletInputStream;

public class FormInput {
    private String name;
    private ServletInputStream is;
    private boolean readFully = false;
    private FormValue value;
    private String boundary;
    private HashMap<String, String> metadata;
    private String contentDisposition;
    private String fileName;

    protected FormInput(ServletInputStream is, FormInput prevInput, String boundary) throws IOException {
        this.is = is;
        this.boundary = boundary;
        if (prevInput != null) {
            if (!prevInput.readFully) {
                prevInput.getValue().readFully();
            }
            prevInput.readFully = true;
        }
        if (boundary.equals("&")) {
            byte a;
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            while ((a = (byte)is.read()) != 61 && a != -1) {
                bas.write(a);
            }
            if (bas.size() < 1) {
                throw new IOException();
            }
            this.name = bas.toString();
            this.value = new FormValue(this);
        } else {
            String str;
            if (prevInput == null) {
                is.readLine();
            }
            this.metadata = new HashMap();
            while ((str = new String(is.readLine(), "UTF-8").trim()).length() != 0) {
                String key = str.substring(0, str.indexOf(":")).trim();
                String val = str.substring(str.indexOf(":") + 1).trim();
                this.metadata.put(key, val);
            }
            for (String key : this.metadata.keySet()) {
                if (!key.equalsIgnoreCase("Content-Disposition")) continue;
                this.contentDisposition = this.metadata.get(key);
                if (this.contentDisposition == null) break;
                for (String str2 : this.contentDisposition.split(";")) {
                    if (!(str2 = str2.trim()).contains("=")) continue;
                    String val = str2.substring(str2.indexOf("\"") + 1, str2.lastIndexOf("\"")).trim();
                    if (str2.toLowerCase().startsWith("name=")) {
                        this.name = val;
                        continue;
                    }
                    if (!str2.toLowerCase().startsWith("filename=") || val.length() <= 0) continue;
                    this.fileName = val;
                }
            }
            if (this.name == null) {
                throw new IOException();
            }
            if (this.isFile() && this.fileName == null) {
                return;
            }
            this.value = new FormValue(this);
        }
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFile() {
        return this.fileName != null;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public FormValue getValue() {
        return this.value;
    }

    protected String getBoundary() {
        return this.boundary;
    }

    protected ServletInputStream getInputStream() {
        return this.is;
    }

    protected void setReadFully() {
        this.readFully = true;
    }

    protected boolean isFullyRead() {
        return this.readFully;
    }
}

