/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import javaxt.http.servlet.FormInput;
import javaxt.http.servlet.ServletInputStream;

public class FormValue {
    private FormInput input;
    private byte[] value = null;
    private static final byte[] CRLF = new byte[]{13, 10};
    private FormInputStream formInputStream;

    protected FormValue(FormInput input) {
        this.input = input;
        this.formInputStream = new FormInputStream();
    }

    public Integer toInteger() {
        if (this.isNull()) {
            return null;
        }
        try {
            return Integer.valueOf(this.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Short toShort() {
        if (this.isNull()) {
            return null;
        }
        try {
            return Short.valueOf(this.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double toDouble() {
        if (this.isNull()) {
            return null;
        }
        try {
            return Double.valueOf(this.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long toLong() {
        if (this.isNull()) {
            return null;
        }
        try {
            return Long.valueOf(this.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigDecimal toBigDecimal() {
        if (this.isNull()) {
            return null;
        }
        try {
            return BigDecimal.valueOf(this.toDouble());
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] toByteArray() {
        return this.getByteArray();
    }

    public Boolean toBoolean() {
        if (this.isNull()) {
            return null;
        }
        String value = this.toString().toLowerCase().trim();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("yes")) {
            return true;
        }
        if (value.equals("no")) {
            return false;
        }
        if (value.equals("y")) {
            return true;
        }
        if (value.equals("n")) {
            return false;
        }
        if (value.equals("t")) {
            return true;
        }
        if (value.equals("f")) {
            return false;
        }
        if (value.equals("1")) {
            return true;
        }
        if (value.equals("0")) {
            return false;
        }
        return null;
    }

    public boolean isNumeric() {
        if (this.isNull()) {
            return false;
        }
        return this.toDouble() != null;
    }

    public boolean isNull() {
        return this.getByteArray().length < 1;
    }

    public String toString() {
        String value = new String(this.getByteArray());
        if (this.input.getBoundary().equals("&")) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (Exception e) {
                String[] find = new String[]{"%2C", "%2F", "%3A"};
                String[] replace = new String[]{",", "/", ":"};
                for (int i = 0; i < find.length; ++i) {
                    value = value.replace(find[i], replace[i]);
                }
            }
        }
        return value;
    }

    public boolean toFile(File file) {
        try {
            if (this.value == null) {
                int bufferSize = 2048;
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileOutputStream output = new FileOutputStream(file);
                ReadableByteChannel inputChannel = Channels.newChannel(this.getInputStream());
                WritableByteChannel outputChannel = Channels.newChannel(output);
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
                while (inputChannel.read(buffer) != -1) {
                    buffer.flip();
                    outputChannel.write(buffer);
                    buffer.compact();
                }
                buffer.flip();
                while (buffer.hasRemaining()) {
                    outputChannel.write(buffer);
                }
                inputChannel.close();
                outputChannel.close();
                return true;
            }
            FileOutputStream output = new FileOutputStream(file);
            output.write(this.value);
            output.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public InputStream getInputStream() {
        return this.formInputStream;
    }

    protected void readFully() {
        if (this.value != null) {
            return;
        }
        try {
            InputStream inputStream = this.getInputStream();
            while (inputStream.read() != -1) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] getByteArray() {
        if (this.value == null) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            InputStream inputStream = this.getInputStream();
            try {
                int x = 0;
                while ((x = inputStream.read()) != -1) {
                    bas.write(x);
                }
                this.value = bas.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.value = new byte[0];
            }
        }
        return this.value;
    }

    private class FormInputStream
    extends InputStream {
        private byte[] cache;
        private String boundary;
        private ServletInputStream is;

        public FormInputStream() {
            this.boundary = FormValue.this.input.getBoundary();
            this.is = FormValue.this.input.getInputStream();
            this.cache = new byte[0];
        }

        @Override
        public int read() throws IOException {
            if (FormValue.this.input.isFullyRead()) {
                return -1;
            }
            if (this.boundary.equals("&")) {
                int a = this.getNextByte();
                if (a == 38 || a == -1) {
                    FormValue.this.input.setReadFully();
                    return -1;
                }
                return a;
            }
            int a = this.getNextByte();
            if (a == -1) {
                return -1;
            }
            if (a == 13) {
                int b = this.getNextByte();
                if (b == -1) {
                    return -1;
                }
                if (b == 10) {
                    byte[] arr = new byte[this.boundary.length() + 2];
                    this.read(arr);
                    String str = new String(arr);
                    if (str.equalsIgnoreCase("--" + this.boundary)) {
                        while (this.read(arr = new byte[2]) >= 0 && !Arrays.equals(arr, CRLF)) {
                        }
                        FormValue.this.input.setReadFully();
                        return -1;
                    }
                    for (int i = arr.length - 1; i > -1; --i) {
                        this.updateCache(arr[i]);
                    }
                    this.updateCache((byte)b);
                    return a;
                }
                this.updateCache((byte)b);
                return a;
            }
            return a;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int totalBytesRead = 0;
            for (int i = 0; i < b.length; ++i) {
                int x = this.getNextByte();
                if (x == -1) {
                    totalBytesRead = -1;
                    break;
                }
                b[i] = (byte)x;
                ++totalBytesRead;
            }
            return totalBytesRead;
        }

        private void updateCache(byte b) {
            byte[] temp = new byte[this.cache.length + 1];
            temp[0] = b;
            int i = 1;
            byte[] byArray = this.cache;
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                byte _byte;
                temp[i] = _byte = byArray[j];
                ++i;
            }
            this.cache = temp;
            temp = null;
        }

        private int getNextByte() throws IOException {
            if (this.cache.length > 0) {
                byte b = this.cache[0];
                byte[] a = new byte[this.cache.length - 1];
                System.arraycopy(this.cache, 1, a, 0, a.length);
                this.cache = a;
                return b & 0xFF;
            }
            return this.is.read();
        }
    }
}

