/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javaxt.http.servlet.Authenticator;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.http.servlet.ServletContext;
import javaxt.http.servlet.ServletException;
import javaxt.http.websocket.WebSocketServer;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class HttpServlet {
    private Authenticator authenticator;
    private KeyManager[] kms;
    private TrustManager[] tms;
    private String sslProvider;
    private ServletContext servletContext;
    private String servletPath = "/";

    public void init(Object servletConfig) throws ServletException {
    }

    public void destroy() {
    }

    public abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        if (servletContext.getAttribute("org.eclipse.jetty.server.Handler") instanceof AbstractHandler && servletContext.getAttribute("javaxt.http.websocket.WebSocketServer") == null) {
            servletContext.setAttribute("javaxt.http.websocket.WebSocketServer", new WebSocketServer(this));
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        if (servletPath == null) {
            servletPath = "/";
        } else {
            if (servletPath.length() > 1 && servletPath.startsWith("/")) {
                servletPath = servletPath.substring(1);
            }
            if (servletPath.endsWith("/")) {
                servletPath = servletPath.substring(0, servletPath.length() - 1);
            }
            servletPath = "/" + servletPath;
        }
        this.servletPath = servletPath;
    }

    public void log(String str) {
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected Authenticator getAuthenticator(HttpServletRequest request) {
        if (this.authenticator != null) {
            return this.authenticator.newInstance(request);
        }
        return null;
    }

    public void setKeyStore(KeyStore keystore, String passphrase) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, passphrase.toCharArray());
        this.kms = kmf.getKeyManagers();
    }

    public void setKeyStore(File keyStoreFile, String passphrase) throws Exception {
        char[] pw = passphrase.toCharArray();
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(new FileInputStream(keyStoreFile), pw);
        this.setKeyStore(keystore, passphrase);
    }

    public void setKeyManager(KeyManager keyManager) throws Exception {
        this.kms = new KeyManager[]{keyManager};
    }

    public void setTrustStore(KeyStore truststore) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(truststore);
        this.tms = tmf.getTrustManagers();
    }

    public void setTrustStore(File trustStoreFile, String passphrase) throws Exception {
        char[] pw = passphrase.toCharArray();
        KeyStore truststore = KeyStore.getInstance("JKS");
        truststore.load(new FileInputStream(trustStoreFile), pw);
        this.setTrustStore(truststore);
    }

    public void setSSLProvider(Provider provider) {
        this.sslProvider = provider != null ? provider.getName() : null;
    }

    public void setSSLProvider(String provider) {
        this.setSSLProvider(Security.getProvider(provider));
    }

    public SSLContext getSSLContext() throws ServletException {
        SSLContext sslContext = null;
        try {
            sslContext = this.sslProvider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", this.sslProvider);
            sslContext.init(this.kms, this.tms, null);
        }
        catch (Exception e) {
            ServletException se = new ServletException("Failed to initialize SSLContext.");
            se.initCause(e);
            throw se;
        }
        return sslContext;
    }

    public boolean supportsHttps() {
        return this.kms != null && this.kms.length > 0 && this.kms[0] != null;
    }
}

