/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javaxt.http.servlet.Authenticator;
import javaxt.http.servlet.Cookie;
import javaxt.http.servlet.FormInput;
import javaxt.http.servlet.HttpServlet;
import javaxt.http.servlet.HttpSession;
import javaxt.http.servlet.ServletContext;
import javaxt.http.servlet.ServletException;
import javaxt.http.servlet.ServletInputStream;
import javaxt.http.websocket.WebSocketServer;
import org.eclipse.jetty.server.HttpInput;

public class HttpServletRequest {
    private javax.servlet.http.HttpServletRequest request;
    private ServletContext servletContext;
    private String servletPath;
    private URL url;
    private Boolean isKeepAlive;
    private Boolean isWebSocket;
    private Authenticator authenticator;
    private boolean authenticate = true;
    private ServletException authenticationException = null;
    private Principal principal;
    private boolean getUserPrincipal = true;
    private boolean getCredentials = true;
    private String[] credentials = null;

    public HttpServletRequest(javax.servlet.http.HttpServletRequest request, HttpServlet servlet) {
        this.request = request;
        this.servletPath = servlet.getServletPath();
        this.servletContext = servlet.getServletContext();
        try {
            StringBuffer str = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                str.append("?");
                str.append(query);
            }
            this.url = new URL(str.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.authenticator = servlet.getAuthenticator(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public String getHttpVersion() {
        int idx;
        String protocol = this.request.getProtocol();
        if (protocol != null && (idx = protocol.indexOf("/")) > 0) {
            return protocol.substring(idx + 1);
        }
        return null;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) throws NumberFormatException {
        return this.request.getIntHeader(name);
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        return this.request.getDateHeader(name);
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(env);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public String getPath() {
        return this.url.getPath() + (this.url.getQuery() == null ? "" : "?" + this.url.getQuery());
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getPort() {
        int port = this.url.getPort();
        if (port < 0 || port > 65535) {
            port = 80;
        }
        return port;
    }

    public String getServerName() {
        return this.getHost();
    }

    public int getServerPort() {
        return this.getPort();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public boolean isKeepAlive() {
        if (this.isKeepAlive == null) {
            String connType = this.getHeader("Connection");
            this.isKeepAlive = connType == null ? false : connType.toUpperCase().contains("KEEP-ALIVE");
        }
        return this.isKeepAlive;
    }

    public boolean isWebSocket() {
        if (this.isWebSocket == null) {
            this.isWebSocket = false;
            Object obj = this.servletContext.getAttribute("javaxt.http.websocket.WebSocketServer");
            if (obj != null && obj instanceof WebSocketServer) {
                WebSocketServer ws = (WebSocketServer)obj;
                this.isWebSocket = ws.accept(this);
            }
        }
        return this.isWebSocket;
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public URL getURL() {
        return this.url;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getQueryString() {
        return this.url.getQuery();
    }

    public String getParameter(String key) {
        return this.request.getParameter(key);
    }

    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public byte[] getBody() throws IOException {
        if (!this.getMethod().equals("POST")) {
            return new byte[0];
        }
        int contentLength = this.getContentLength();
        if (contentLength < 1) {
            return new byte[0];
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        HttpInput input = (HttpInput)this.request.getInputStream();
        int numBytesRead = -1;
        byte[] buffer = new byte[8192];
        while (input.isReady() && (numBytesRead = input.read(buffer)) != -1) {
            ByteBuffer buf = ByteBuffer.wrap(buffer, 0, numBytesRead);
            byte[] b = new byte[numBytesRead];
            buf.get(b, 0, numBytesRead);
            bas.write(b);
        }
        return bas.toByteArray();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(this.request.getInputStream());
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public FormIterator getFormInputs() throws IOException {
        if (!this.getMethod().equals("POST")) {
            throw new IOException("Unsupported method: " + this.getMethod());
        }
        String contentType = this.getHeader("Content-Type");
        if (contentType == null) {
            throw new IOException("Content-Type is undefined.");
        }
        String boundary = null;
        if (contentType.contains("application/x-www-form-urlencoded")) {
            boundary = "&";
        } else if (contentType.contains("multipart/form-data")) {
            for (String s : contentType.split(";")) {
                if (!(s = s.toLowerCase().trim()).toLowerCase().trim().startsWith("boundary=")) continue;
                boundary = s.trim().substring("boundary=".length());
                break;
            }
        } else {
            throw new IOException("Unsupported Content-Type: " + contentType);
        }
        return new FormIterator(this.getInputStream(), boundary);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return new HttpSession(this.request.getSession(create), this.servletContext);
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session = this.getSession(false);
        return session != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] cookies = this.request.getCookies();
        Cookie[] arr = new Cookie[cookies.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new Cookie(cookies[i]);
        }
        return arr;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public Object getRequestDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public String getPathInfo() {
        int idx;
        String path = this.getURL().getPath();
        String servletPath = this.getContextPath() + this.getServletPath();
        if (servletPath.length() > 0 && (idx = path.toLowerCase().indexOf(servletPath.toLowerCase())) > -1) {
            path = path.substring(idx + servletPath.length());
        }
        if (path.length() == 0) {
            return null;
        }
        if (path.equals("/")) {
            return null;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public String getPathTranslated() {
        String path = this.getPathInfo();
        if (path != null) {
            return this.getRealPath(path);
        }
        return null;
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getAuthType() {
        if (this.authenticator != null) {
            return this.authenticator.getAuthType();
        }
        return null;
    }

    public String[] getCredentials() {
        if (this.getCredentials) {
            try {
                this.credentials = this.authenticator.getCredentials();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getCredentials = false;
        }
        return this.credentials;
    }

    public void authenticate() throws ServletException {
        if (this.authenticate) {
            try {
                this.authenticator.authenticate();
            }
            catch (ServletException e) {
                this.authenticationException = e;
            }
            catch (Exception e) {
                this.authenticationException = new ServletException(e.getLocalizedMessage());
                this.authenticationException.setStackTrace(e.getStackTrace());
            }
            this.authenticate = false;
        }
        if (this.authenticationException != null) {
            throw this.authenticationException;
        }
    }

    public String getRemoteUser() {
        try {
            String[] credentials = this.getCredentials();
            this.authenticate();
            return credentials[0];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isUserInRole(String role) {
        try {
            return this.authenticator.isUserInRole(role);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Principal getUserPrincipal() {
        if (this.getUserPrincipal) {
            try {
                this.principal = this.authenticator.getPrinciple();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getUserPrincipal = false;
        }
        return this.principal;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest sr, ServletResponse sr1) throws IllegalStateException {
        return this.request.startAsync(sr, sr1);
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.getMethod());
        out.append(" ");
        out.append(this.getPath());
        out.append(" ");
        out.append(this.getProtocol());
        out.append("\r\n");
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = headerNames.nextElement();
            Enumeration<String> headerValues = this.request.getHeaders(name);
            while (headerValues.hasMoreElements()) {
                String value = headerValues.nextElement();
                out.append(name);
                out.append(": ");
                out.append(value);
                out.append("\r\n");
            }
        }
        out.append("\r\n");
        return out.toString();
    }

    private class FormIterator
    implements Iterator {
        private FormInput currInput = null;
        private FormInput prevInput = null;
        private ServletInputStream is;
        private String boundary;

        private FormIterator(ServletInputStream is, String boundary) {
            this.is = is;
            this.boundary = boundary;
        }

        @Override
        public boolean hasNext() {
            if (this.currInput == null) {
                this.getNextInput();
            }
            return this.currInput != null;
        }

        public FormInput next() {
            if (this.currInput == null) {
                this.getNextInput();
            }
            FormInput input = this.currInput;
            this.prevInput = this.currInput;
            this.currInput = null;
            return input;
        }

        private void getNextInput() {
            try {
                FormInput input = new FormInput(this.is, this.prevInput, this.boundary);
                if (this.currInput != null) {
                    this.prevInput = this.currInput;
                }
                this.currInput = input;
            }
            catch (Exception e) {
                this.currInput = null;
            }
        }

        @Override
        public void remove() {
        }
    }

    private class StreamReader
    implements Runnable {
        private ByteArrayOutputStream bas;

        public StreamReader(ByteArrayOutputStream bas) {
            this.bas = bas;
        }

        @Override
        public void run() {
            try {
                final HttpInput input = (HttpInput)HttpServletRequest.this.request.getInputStream();
                final AsyncContext async = HttpServletRequest.this.request.startAsync();
                input.setReadListener(new ReadListener(){

                    @Override
                    public void onDataAvailable() throws IOException {
                        int numBytesRead = -1;
                        byte[] buffer = new byte[8192];
                        while (this.ready() && (numBytesRead = input.read(buffer)) != -1) {
                            ByteBuffer buf = ByteBuffer.wrap(buffer, 0, numBytesRead);
                            if (numBytesRead <= 0) break;
                            byte[] b = new byte[numBytesRead];
                            buf.get(b, 0, numBytesRead);
                            StreamReader.this.bas.write(b);
                        }
                        this.end();
                    }

                    @Override
                    public void onAllDataRead() throws IOException {
                        this.end();
                    }

                    @Override
                    public void onError(Throwable t) {
                        HttpServletRequest.this.request.getServletContext().log("Async Error", t);
                    }

                    void end() {
                        System.out.println("Done!");
                        async.complete();
                        try {
                            StreamReader.this.bas.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    boolean ready() {
                        return input.isReady();
                    }
                });
                return;
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

