/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.AsyncContext;
import javax.servlet.WriteListener;
import javaxt.http.servlet.Cookie;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.ServletOutputStream;
import org.eclipse.jetty.server.HttpOutput;

public class HttpServletResponse {
    private javax.servlet.http.HttpServletResponse response;
    private HttpServletRequest request;
    private Integer statusCode;
    private String statusMessage;
    private int bufferSize = 8096;
    private static final String z = "GMT";
    private static final TimeZone tz = TimeZone.getTimeZone("GMT");
    private String charSet = "UTF-8";
    private ConcurrentHashMap<String, ByteBuffer> cache = new ConcurrentHashMap();
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_FOUND = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;

    public HttpServletResponse(HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {
        this.request = request;
        this.response = response;
        if (request.getHeader("Upgrade") == null) {
            this.setHeader("Connection", request.isKeepAlive() ? "Keep-Alive" : "Close");
            this.setHeader("Server", request.getServletContext().getServerInfo());
            this.setHeader("Date", HttpServletResponse.getDate(Calendar.getInstance()));
            this.setStatus(200, "OK");
        }
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie.getCookie());
    }

    public void setContentLength(int contentLength) {
        this.response.setContentLengthLong(contentLength);
    }

    public void setContentLength(long contentLength) {
        this.response.setContentLengthLong(contentLength);
    }

    public Long getContentLength() {
        try {
            long l = Long.parseLong(this.getHeader("Content-Length"));
            if (l < 0L) {
                return null;
            }
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setCharacterEncoding(String charset) throws UnsupportedEncodingException {
        this.response.setCharacterEncoding(charset);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setLocale(Locale locale) {
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if (name == null) {
            return;
        }
        if (name.equalsIgnoreCase("Transfer-Encoding") && value != null && value.equalsIgnoreCase("chunked")) {
            String httpClient = this.request.getHttpVersion();
            if (httpClient == null) {
                return;
            }
            if (httpClient.equals("0.9") || httpClient.equals("1.0")) {
                return;
            }
        }
        this.response.setHeader(name, value);
    }

    public String getHeader(String name) {
        return this.response.getHeader(name);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public void setDateHeader(String name, long date) {
        this.response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.response.addDateHeader(name, date);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addIntHeader(name, value);
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void setStatus(int sc) {
        this.setStatus(sc, HttpServletResponse.getStatusMessage(sc));
    }

    public void setStatus(int statusCode, String statusMessage) {
        this.response.setStatus(statusCode, statusMessage);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    protected static String getStatusMessage(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Partial Information";
            }
            case 204: {
                return "No Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 304: {
                return "Not Modified";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 500: {
                return "Internal Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc, msg);
        this.write("<head><title>" + sc + " - " + msg + "</title></head><body><h1>" + sc + "</h1>" + msg + "</body>");
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, HttpServletResponse.getStatusMessage(sc));
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, false);
    }

    public void sendRedirect(String location, boolean movedPermanently) throws IOException {
        if (movedPermanently) {
            this.setStatus(301);
        } else {
            this.setStatus(307);
        }
        this.setHeader("Location", location);
        this.write("<head><title>Document Moved</title></head><body><h1>Object Moved</h1>This document may be found <a href=\"" + location + "\">here</a></body>");
    }

    public void write(String text, boolean compressOutput) throws IOException {
        try {
            this.write(text.getBytes(this.charSet), compressOutput);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void write(String text) throws IOException {
        this.write(text, true);
    }

    public void write(byte[] bytes, boolean compressOutput) throws IOException {
        String acceptEncoding;
        if (bytes == null) {
            return;
        }
        boolean gzip = false;
        if (compressOutput && bytes.length > 50 && (acceptEncoding = this.request.getHeader("Accept-Encoding")) != null && acceptEncoding.toLowerCase().contains("gzip")) {
            gzip = true;
        }
        if (gzip) {
            if (bytes.length <= this.bufferSize) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
                GZIPOutputStream out = new GZIPOutputStream((OutputStream)bos, bytes.length);
                out.write(bytes);
                out.finish();
                out.close();
                bytes = bos.toByteArray();
                bos.reset();
                bos = null;
                out = null;
                this.setContentLength(bytes.length);
                this.setHeader("Content-Encoding", "gzip");
                ByteBuffer output = ByteBuffer.allocateDirect(bytes.length);
                output.put(bytes);
                output.flip();
                this.write(output);
                output.clear();
                output = null;
            } else {
                this.setHeader("Content-Length", null);
                this.setHeader("Transfer-Encoding", "chunked");
                this.setHeader("Content-Encoding", "gzip");
                HttpOutput out = (HttpOutput)this.response.getOutputStream();
                out.setBufferSize(this.bufferSize);
                GZIPOutputStream gz = new GZIPOutputStream((OutputStream)out, this.bufferSize);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                byte[] b = new byte[this.bufferSize];
                int x = 0;
                while ((x = inputStream.read(b)) != -1) {
                    gz.write(b, 0, x);
                }
                ((InputStream)inputStream).close();
                gz.finish();
                gz.close();
                gz = null;
                b = null;
            }
        } else {
            this.setContentLength(bytes.length);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            HttpOutput out = (HttpOutput)this.response.getOutputStream();
            out.setBufferSize(this.bufferSize);
            byte[] b = new byte[this.bufferSize];
            int x = 0;
            while ((x = inputStream.read(b)) != -1) {
                out.write(b, 0, x);
            }
            ((InputStream)inputStream).close();
            inputStream = null;
            out.close();
            out = null;
            b = null;
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, true);
    }

    public void write(File file, String contentType, boolean useCache) throws IOException {
        String fileName = null;
        if (!contentType.startsWith("image") && !contentType.startsWith("text")) {
            fileName = file.getName();
        }
        this.write(file, fileName, contentType, useCache);
    }

    public void write(File file, String fileName, String contentType, boolean useCache) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            this.setStatus(404);
            return;
        }
        long fileSize = file.length();
        long fileDate = file.lastModified();
        if (useCache) {
            String eTag = "W/\"" + fileSize + "-" + fileDate + "\"";
            this.setHeader("ETag", eTag);
            this.setHeader("Last-Modified", this.getDate(fileDate));
            String matchTag = this.request.getHeader("if-none-match");
            String cacheControl = this.request.getHeader("cache-control");
            if (matchTag == null) {
                matchTag = "";
            }
            if (cacheControl == null) {
                cacheControl = "";
            }
            if (!cacheControl.equalsIgnoreCase("no-cache")) {
                if (eTag.equalsIgnoreCase(matchTag)) {
                    this.setStatus(304);
                    return;
                }
                matchTag = this.request.getHeader("if-modified-since");
                if (matchTag != null) {
                    for (String tag : matchTag.split(";")) {
                        if (!tag.trim().equalsIgnoreCase(this.getDate(fileDate))) continue;
                        this.setStatus(304);
                        return;
                    }
                }
            }
        } else {
            this.setHeader("Cache-Control", "no-cache");
        }
        this.setContentType(contentType);
        if (fileName != null) {
            this.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
        }
        if (fileSize <= (long)this.bufferSize) {
            this.setContentLength(fileSize);
            HttpOutput out = (HttpOutput)this.response.getOutputStream();
            out.setBufferSize(this.bufferSize);
            out.sendContent(FileChannel.open(file.toPath(), StandardOpenOption.READ));
            return;
        }
        boolean gzip = false;
        String acceptEncoding = this.request.getHeader("Accept-Encoding");
        if (acceptEncoding != null && acceptEncoding.toLowerCase().contains("gzip")) {
            gzip = true;
        }
        if (gzip) {
            this.setHeader("Content-Length", null);
            this.setHeader("Transfer-Encoding", "chunked");
            this.setHeader("Content-Encoding", "gzip");
            HttpOutput out = (HttpOutput)this.response.getOutputStream();
            out.setBufferSize(this.bufferSize);
            GZIPOutputStream gz = new GZIPOutputStream((OutputStream)out, this.bufferSize);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] b = new byte[this.bufferSize];
            int x = 0;
            while ((x = ((InputStream)inputStream).read(b)) != -1) {
                gz.write(b, 0, x);
            }
            ((InputStream)inputStream).close();
            gz.finish();
            gz.close();
            gz = null;
            b = null;
        } else {
            this.setContentLength(fileSize);
            String path = file.getPath();
            ByteBuffer mapped = this.cache.get(path);
            if (mapped == null) {
                try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                    MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                    mapped = this.cache.putIfAbsent(path, buf);
                    if (mapped == null) {
                        mapped = buf;
                    }
                }
            }
            this.write(mapped.asReadOnlyBuffer());
        }
    }

    public void write(final ByteBuffer content) throws IOException {
        final HttpOutput out = (HttpOutput)this.response.getOutputStream();
        out.setBufferSize(this.bufferSize);
        final AsyncContext async = this.request.startAsync();
        out.setWriteListener(new WriteListener(){

            @Override
            public void onWritePossible() throws IOException {
                while (out.isReady()) {
                    if (!content.hasRemaining()) {
                        async.complete();
                        return;
                    }
                    out.write(content);
                }
            }

            @Override
            public void onError(Throwable t) {
                t.printStackTrace();
                HttpServletResponse.this.request.getServletContext().log("Async Error", t);
                async.complete();
            }
        });
    }

    public void write(InputStream inputStream, boolean compressOutput) throws IOException {
        String acceptEncoding;
        if (inputStream == null) {
            return;
        }
        boolean gzip = false;
        if (compressOutput && (acceptEncoding = this.request.getHeader("Accept-Encoding")) != null && acceptEncoding.toLowerCase().contains("gzip")) {
            gzip = true;
        }
        this.setHeader("Content-Length", null);
        this.setHeader("Transfer-Encoding", "chunked");
        if (gzip) {
            this.setHeader("Content-Encoding", "gzip");
        }
        OutputStream out = gzip ? new GZIPOutputStream((OutputStream)this.response.getOutputStream(), this.bufferSize) : this.response.getOutputStream();
        byte[] b = new byte[this.bufferSize];
        int x = 0;
        while ((x = inputStream.read(b)) != -1) {
            out.write(b, 0, x);
        }
        inputStream.close();
        out.close();
        out = null;
        b = null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(this.response.getOutputStream());
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public String getHeader() {
        boolean isKeepAlive;
        String TransferEncoding;
        if (this.statusCode == null) {
            this.statusCode = 200;
        }
        if (this.statusMessage == null) {
            this.statusMessage = HttpServletResponse.getStatusMessage(this.statusCode);
        }
        boolean chunked = (TransferEncoding = this.getHeader("Transfer-Encoding")) != null ? TransferEncoding.equalsIgnoreCase("chunked") : false;
        String connType = this.getHeader("Connection");
        boolean bl = isKeepAlive = connType != null ? connType.equalsIgnoreCase("Keep-Alive") : false;
        if (isKeepAlive && this.getContentLength() == null && !chunked) {
            this.setHeader("Connection", "Close");
        }
        StringBuffer header = new StringBuffer();
        header.append("HTTP/1.1 " + this.statusCode + (this.statusMessage == null ? "" : " " + this.statusMessage) + "\r\n");
        for (String name : this.response.getHeaderNames()) {
            for (String value : this.response.getHeaders(name)) {
                header.append(name);
                header.append(": ");
                header.append(value);
                header.append("\r\n");
            }
        }
        header.append("\r\n");
        return header.toString();
    }

    public String toString() {
        return this.getHeader();
    }

    private static String getDate(Calendar cal) {
        if (!cal.getTimeZone().equals(tz)) {
            cal = (Calendar)cal.clone();
            cal.setTimeZone(tz);
        }
        StringBuffer str = new StringBuffer(29);
        switch (cal.get(7)) {
            case 2: {
                str.append("Mon, ");
                break;
            }
            case 3: {
                str.append("Tue, ");
                break;
            }
            case 4: {
                str.append("Wed, ");
                break;
            }
            case 5: {
                str.append("Thu, ");
                break;
            }
            case 6: {
                str.append("Fri, ");
                break;
            }
            case 7: {
                str.append("Sat, ");
                break;
            }
            case 1: {
                str.append("Sun, ");
            }
        }
        int i = cal.get(5);
        str.append(i < 10 ? "0" + i : Integer.valueOf(i));
        switch (cal.get(2)) {
            case 0: {
                str.append(" Jan ");
                break;
            }
            case 1: {
                str.append(" Feb ");
                break;
            }
            case 2: {
                str.append(" Mar ");
                break;
            }
            case 3: {
                str.append(" Apr ");
                break;
            }
            case 4: {
                str.append(" May ");
                break;
            }
            case 5: {
                str.append(" Jun ");
                break;
            }
            case 6: {
                str.append(" Jul ");
                break;
            }
            case 7: {
                str.append(" Aug ");
                break;
            }
            case 8: {
                str.append(" Sep ");
                break;
            }
            case 9: {
                str.append(" Oct ");
                break;
            }
            case 10: {
                str.append(" Nov ");
                break;
            }
            case 11: {
                str.append(" Dec ");
            }
        }
        str.append(cal.get(1));
        str.append(" ");
        i = cal.get(11);
        str.append(i < 10 ? "0" + i + ":" : i + ":");
        i = cal.get(12);
        str.append(i < 10 ? "0" + i + ":" : i + ":");
        i = cal.get(13);
        str.append(i < 10 ? "0" + i + " " : i + " ");
        str.append(z);
        return str.toString();
    }

    private String getDate(long milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliseconds);
        return HttpServletResponse.getDate(cal);
    }

    public void reset() {
        this.response.reset();
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }
}

