/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.servlet;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javaxt.http.servlet.ServletException;

public class ServletContext {
    private String serverInfo;
    private File jarFile;
    private javax.servlet.ServletContext servletContext;
    public final String PathSeparator = System.getProperty("file.separator");
    private String contextPath = "";

    public ServletContext(javax.servlet.ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public int getMajorVersion() {
        return this.servletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.servletContext.getMinorVersion();
    }

    public Object getAttribute(String name) {
        return this.servletContext.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.servletContext.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.servletContext.removeAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public javax.servlet.ServletContext getContext(String uripath) {
        return this.servletContext.getContext(uripath);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getServletContextName() {
        return this.servletContext.getServletContextName();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.servletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public Object getRequestDispatcher(String path) {
        return this.servletContext.getRequestDispatcher(path);
    }

    public Object getNamedDispatcher(String name) {
        return this.servletContext.getNamedDispatcher(name);
    }

    public Object getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public void log(String msg) {
    }

    public void log(Exception exception, String msg) {
    }

    public void log(String message, Throwable throwable) {
    }

    public String getRealPath(String path) {
        int i;
        String currDir = this.contextPath;
        if (!(currDir = currDir.replace("\\", "/")).endsWith("/")) {
            currDir = currDir + "/";
        }
        if ((path = path.replace("\\", "/")).startsWith("/")) {
            return (currDir + path.substring(1)).replace("/", this.PathSeparator);
        }
        String[] arrRelPath = path.split("/");
        String[] arrAbsPath = currDir.split("/");
        int x = -1;
        path = "";
        String dir = "";
        for (i = 0; i < arrRelPath.length; ++i) {
            dir = arrRelPath[i];
            if (dir.equals("..")) {
                ++x;
                continue;
            }
            if (dir.equals(".")) continue;
            path = path + "\\" + arrRelPath[i];
        }
        dir = "";
        for (i = 0; i < arrAbsPath.length - (x + 1); ++i) {
            dir = dir + arrAbsPath[i] + "\\";
        }
        dir = dir.substring(0, dir.length() - 1);
        dir = dir + path.replace("/", "\\");
        dir = dir.replace("\\", this.PathSeparator);
        return dir;
    }

    public String getServerInfo() {
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        if (this.jarFile == null) {
            this.jarFile = this.getJarFile();
        }
        try {
            JarFile jar = new JarFile(this.jarFile);
            Manifest manifest = jar.getManifest();
            String versionNumber = null;
            Attributes attributes = manifest.getMainAttributes();
            if (attributes != null) {
                for (Attributes.Name name : attributes.keySet()) {
                    String keyword = name.toString();
                    if (!keyword.equals("Implementation-Version") && !keyword.equals("Bundle-Version")) continue;
                    versionNumber = (String)attributes.get(name);
                    break;
                }
            }
            jar.close();
            this.serverInfo = "JavaXT Web Server" + (versionNumber != null ? "/" + versionNumber : "");
            return this.serverInfo;
        }
        catch (Exception exception) {
            return "JavaXT Web Server";
        }
    }

    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    private File getJarFile() {
        block6: {
            Package Package2 = this.getClass().getPackage();
            String path = Package2.getName().replace(".", "/");
            String url = this.getClass().getClassLoader().getResource(path).toString();
            url = url.replace(" ", "%20");
            try {
                URI uri = new URI(url);
                if (uri.getPath() == null) {
                    path = uri.toString();
                    if (path.startsWith("jar:file:")) {
                        path = path.substring(path.indexOf("file:/"));
                        if ((path = path.substring(0, path.toLowerCase().indexOf(".jar") + 4)).startsWith("file://")) {
                            path = "C:/" + path.substring(path.indexOf("file:/") + 7);
                            path = "/" + new URI(path).getPath();
                        } else {
                            path = new URI(path).getPath();
                        }
                        return new File(path);
                    }
                    break block6;
                }
                return new File(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

