/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http.websocket;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javaxt.http.servlet.Cookie;
import javaxt.http.servlet.HttpServletRequest;
import javaxt.http.servlet.HttpServletResponse;
import javaxt.http.websocket.WebSocketServer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

public class WebSocketListener {
    private Session session;
    private ServletUpgradeRequest request;
    private Cookie[] cookies;

    public WebSocketListener(HttpServletRequest request, HttpServletResponse response) {
        Object obj = request.getServletContext().getAttribute("javaxt.http.websocket.WebSocketServer");
        WebSocketServer webSocketServer = (WebSocketServer)obj;
        final WebSocketListener me = this;
        WebSocketAdapter wrapper = new WebSocketAdapter(){

            @Override
            public void onWebSocketConnect(Session session) {
                super.onWebSocketConnect(session);
                try {
                    me.session = session;
                    ServletUpgradeRequest upgradeRequest = (ServletUpgradeRequest)session.getUpgradeRequest();
                    me.request = upgradeRequest;
                    me.onConnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void onWebSocketClose(int statusCode, String reason) {
                super.onWebSocketClose(statusCode, reason);
                try {
                    me.onDisconnect(statusCode, reason);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void onWebSocketText(String message) {
                super.onWebSocketText(message);
                try {
                    me.onText(message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        webSocketServer.processRequest(wrapper, request, response);
    }

    public void onConnect() {
    }

    public void onDisconnect(int statusCode, String reason) {
    }

    public void onText(String str) {
    }

    public final void send(String str) {
        try {
            this.session.getRemote().sendString(str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this.session.close();
    }

    public void disconnect() throws IOException {
        this.session.disconnect();
    }

    public URI getURI() {
        return this.request.getRequestURI();
    }

    public String getLocalAddress() {
        return this.request.getLocalAddress();
    }

    public String getLocalHostName() {
        return this.request.getLocalHostName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public String getRemoteAddress() {
        return this.request.getRemoteAddress();
    }

    public String getRemoteHostName() {
        return this.request.getRemoteHostName();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public X509Certificate[] getCertificates() {
        return this.request.getCertificates();
    }

    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] requestCookies;
        if (this.cookies == null && (requestCookies = this.request.getHttpServletRequest().getCookies()) != null) {
            this.cookies = new Cookie[requestCookies.length];
            for (int i = 0; i < this.cookies.length; ++i) {
                this.cookies[i] = new Cookie(requestCookies[i].getName(), requestCookies[i].getValue());
            }
        }
        return this.cookies;
    }

    public Enumeration<String> getExtensions() {
        return this.request.getHttpServletRequest().getHeaders("Sec-WebSocket-Extensions");
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Map<String, List<String>> getHeaders() {
        return this.request.getHeaders();
    }

    public List<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getHttpServletRequest().getParameterMap();
    }

    public String getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public boolean hasSubProtocol(String test) {
        return this.request.hasSubProtocol(test);
    }

    public List<String> getSubProtocols() {
        return this.request.getSubProtocols();
    }
}

